#declare fan_outer_chain_even_radius = 100.0000;

#declare fan_outer_chain_odd_radius = 100.0000;

#declare fan_inner_chain_even_radius = 30.9375;

#declare fan_inner_chain_odd_radius = 30.9375;

#declare fan_thickness = 9.9996;

#declare fan_min_elevation = 20.00000; // Degrees.

#declare fan_max_elevation = 70.00000; // Degrees.

#declare fan_num_faces = 16;

#declare fan_num_edges = 42;

#declare fan_num_vertices = 28;

#declare fan_num_outer_chain_edges = 6;

#declare fan_num_inner_chain_edges = 6;

#declare fan_outer_chain_shape = 0;

#macro fan_vertices()
  #local Nv = fan_num_vertices;
  // Returns an array {V} of {Nv+1} elements.
  // Element {V[kv]} is the vertex with OBJ index {kv} in {1..Nv}.
  // Element {V[0]} is not used.
  #local V = array[Nv+1]
  #local V[   0] = < -1, -1, -1>; // Not used.
  #local V[   1] = < 4.9998, 93.9692, 34.2020 >; // vo.0.0
  #local V[   2] = < 4.9998, 88.0202, 47.4600 >; // vo.0.1
  #local V[   3] = < 4.9998, 80.2124, 59.7158 >; // vo.0.2
  #local V[   4] = < 4.9998, 70.7106, 70.7106 >; // vo.0.3
  #local V[   5] = < 4.9998, 59.7158, 80.2124 >; // vo.0.4
  #local V[   6] = < 4.9998, 47.4600, 88.0202 >; // vo.0.5
  #local V[   7] = < 4.9998, 34.2020, 93.9692 >; // vo.0.6
  #local V[   8] = < 4.9998, 29.0718, 10.5812 >; // vi.0.0
  #local V[   9] = < 4.9998, 27.2312, 14.6830 >; // vi.0.1
  #local V[  10] = < 4.9998, 24.8156, 18.4746 >; // vi.0.2
  #local V[  11] = < 4.9998, 21.8760, 21.8760 >; // vi.0.3
  #local V[  12] = < 4.9998, 18.4746, 24.8156 >; // vi.0.4
  #local V[  13] = < 4.9998, 14.6830, 27.2312 >; // vi.0.5
  #local V[  14] = < 4.9998, 10.5812, 29.0718 >; // vi.0.6
  #local V[  15] = < -4.9998, 93.9692, 34.2020 >; // vo.1.0
  #local V[  16] = < -4.9998, 88.0202, 47.4600 >; // vo.1.1
  #local V[  17] = < -4.9998, 80.2124, 59.7158 >; // vo.1.2
  #local V[  18] = < -4.9998, 70.7106, 70.7106 >; // vo.1.3
  #local V[  19] = < -4.9998, 59.7158, 80.2124 >; // vo.1.4
  #local V[  20] = < -4.9998, 47.4600, 88.0202 >; // vo.1.5
  #local V[  21] = < -4.9998, 34.2020, 93.9692 >; // vo.1.6
  #local V[  22] = < -4.9998, 29.0718, 10.5812 >; // vi.1.0
  #local V[  23] = < -4.9998, 27.2312, 14.6830 >; // vi.1.1
  #local V[  24] = < -4.9998, 24.8156, 18.4746 >; // vi.1.2
  #local V[  25] = < -4.9998, 21.8760, 21.8760 >; // vi.1.3
  #local V[  26] = < -4.9998, 18.4746, 24.8156 >; // vi.1.4
  #local V[  27] = < -4.9998, 14.6830, 27.2312 >; // vi.1.5
  #local V[  28] = < -4.9998, 10.5812, 29.0718 >; // vi.1.6
  V
#end

#macro fan_edges()
  #local Ne = fan_num_edges;
  // Returns an array {E} of {Ne+1} elements.
  // Element {E[ke]} is the triple {<ko[ke],kd[ke],ty[ke]>}, for {ke} in {1..Ne}.
  // Here {ko[ke],kd[ke]} are the indices of the vertices
  // which are the endpoints of edge {E[ke]},
  // and {ty[ke]} is an edge type code:
  // 
  //   100-199 outer chain edge of plaza [0].
  //   200-299 inner chain edge of plaza [0].
  //   300-399 outer chain edge of plaza [1].
  //   400-499 inner chain edge of plaza [1].
  //   0       other.
  // 
  // The index of the edge in the chain is {ty[ke] % 100}.
  #local E = array[Ne+1]
  #local E[   0] = < -1, -1, -1 >; // Not used.
  #local E[   1] = < 1, 15, 0 >;
  #local E[   2] = < 15, 16, 300 >;
  #local E[   3] = < 2, 16, 0 >;
  #local E[   4] = < 16, 17, 301 >;
  #local E[   5] = < 3, 17, 0 >;
  #local E[   6] = < 17, 18, 302 >;
  #local E[   7] = < 4, 18, 0 >;
  #local E[   8] = < 18, 19, 303 >;
  #local E[   9] = < 5, 19, 0 >;
  #local E[  10] = < 19, 20, 304 >;
  #local E[  11] = < 6, 20, 0 >;
  #local E[  12] = < 20, 21, 305 >;
  #local E[  13] = < 8, 9, 100 >;
  #local E[  14] = < 9, 23, 0 >;
  #local E[  15] = < 9, 10, 101 >;
  #local E[  16] = < 10, 24, 0 >;
  #local E[  17] = < 10, 11, 102 >;
  #local E[  18] = < 11, 25, 0 >;
  #local E[  19] = < 11, 12, 103 >;
  #local E[  20] = < 12, 26, 0 >;
  #local E[  21] = < 12, 13, 104 >;
  #local E[  22] = < 13, 27, 0 >;
  #local E[  23] = < 13, 14, 105 >;
  #local E[  24] = < 14, 28, 0 >;
  #local E[  25] = < 8, 22, 0 >;
  #local E[  26] = < 1, 8, 0 >;
  #local E[  27] = < 7, 21, 0 >;
  #local E[  28] = < 21, 28, 0 >;
  #local E[  29] = < 1, 2, 100 >;
  #local E[  30] = < 2, 3, 101 >;
  #local E[  31] = < 3, 4, 102 >;
  #local E[  32] = < 4, 5, 103 >;
  #local E[  33] = < 5, 6, 104 >;
  #local E[  34] = < 6, 7, 105 >;
  #local E[  35] = < 7, 14, 0 >;
  #local E[  36] = < 15, 22, 0 >;
  #local E[  37] = < 22, 23, 400 >;
  #local E[  38] = < 23, 24, 401 >;
  #local E[  39] = < 24, 25, 402 >;
  #local E[  40] = < 25, 26, 403 >;
  #local E[  41] = < 26, 27, 404 >;
  #local E[  42] = < 27, 28, 405 >;
  E
#end

#macro fan_faces()
  #local Nf = fan_num_faces;
  // Returns an array {F} of {Nf+1} elements.
  // Element {F[kf]} is an instance of the
  // 'plane' (halfspace) POV-ray primitive
  // for {kf} in {1..Nf}.
  // The order is outer chain faces, inner chain faces.
  // inner-outer connecting faces,
  // and finally the plazas.
  #local F = array[Nf+1]
  #local F[   0] = sphere{ <0,0,0>, 1000} // Not used.
  #local F[   1] = plane{  < 0.0000000, 0.9123584, 0.4093923 >, 0 translate < 4.9998, 93.9693, 34.2020 > }
  #local F[   2] = plane{  < 0.0000000, 0.8433914, 0.5372996 >, 0 translate < 4.9998, 88.0201, 47.4600 > }
  #local F[   3] = plane{  < 0.0000000, 0.7566148, 0.6538609 >, 0 translate < 4.9998, 80.2123, 59.7159 > }
  #local F[   4] = plane{  < 0.0000000, 0.6538609, 0.7566148 >, 0 translate < 4.9998, 70.7107, 70.7107 > }
  #local F[   5] = plane{  < 0.0000000, 0.5372996, 0.8433914 >, 0 translate < 4.9998, 59.7159, 80.2123 > }
  #local F[   6] = plane{  < 0.0000000, 0.4093923, 0.9123584 >, 0 translate < 4.9998, 47.4600, 88.0201 > }
  #local F[   7] = plane{  < 0.0000000, -0.9123584, -0.4093923 >, 0 translate < -4.9998, 29.0717, 10.5812 > }
  #local F[   8] = plane{  < 0.0000000, -0.8433914, -0.5372996 >, 0 translate < -4.9998, 27.2312, 14.6829 > }
  #local F[   9] = plane{  < 0.0000000, -0.7566148, -0.6538609 >, 0 translate < -4.9998, 24.8157, 18.4746 > }
  #local F[  10] = plane{  < 0.0000000, -0.6538609, -0.7566148 >, 0 translate < -4.9998, 21.8761, 21.8761 > }
  #local F[  11] = plane{  < 0.0000000, -0.5372996, -0.8433914 >, 0 translate < -4.9998, 18.4746, 24.8157 > }
  #local F[  12] = plane{  < 0.0000000, -0.4093923, -0.9123584 >, 0 translate < -4.9998, 14.6829, 27.2312 > }
  #local F[  13] = plane{  < 0.0000000, 0.3420201, -0.9396926 >, 0 translate < 4.9998, 29.0717, 10.5812 > }
  #local F[  14] = plane{  < 0.0000000, -0.9396926, 0.3420201 >, 0 translate < 4.9998, 34.2020, 93.9693 > }
  #local F[  15] = plane{  < 1.0000000, 0.0000000, 0.0000000 >, 0 translate < 4.9998, 29.0717, 10.5812 > }
  #local F[  16] = plane{  < -1.0000000, 0.0000000, 0.0000000 >, 0 translate < -4.9998, 10.5812, 29.0717 > }
  F
#end

