// Last edited on 2024-09-19 08:44:07 by stolfi

#debug "!! Loading slicing_solid.inc ...\n"

#macro slicing_solid(V, F)
  // The 3D volume of the fan.  Parameters:
  
  // {V}         Array of vertex coordinates {V[1..Nv]}.
  // {F}         Array of planes that define the faces, {F[1..Nf]}.
  
  #debug "!! Generating the object's surface ...\n"

  #local Nv = dimension_size(V, 1) - 1;
  #local Nf = dimension_size(F, 1) - 1;

  #debug concat("!!   Nv     = ", str(Nv    ,0,0), "\n")
  #debug concat("!!   Nf     = ", str(Nf    ,0,0), "\n")

  #local tx_face = slicing_tx_face
  
  // A clipping box for the whole object:
  #local vmin = < +9999, +9999, +9999 >;
  #local vmax = < -9999, -9999, -9999 >;
  #for (kv,1,Nv)
    #local vk = V[kv];
    #local vmin = < min(vmin.x, vk.x), min(vmin.y, vk.y), min(vmin.z, vk.z) >;
    #local vmax = < max(vmax.x, vk.x), max(vmax.y, vk.y), max(vmax.z, vk.z) >;
  #end
  slicing_debug_vertex("vmin", -1, vmin)
  slicing_debug_vertex("vmax", -1, vmax)
  #local vdim = vmax - vmin;
  #local bbox1 = box { vmin - 0.05*vdim, vmax + 0.05*vdim }

  #local surf = 
    union{
      // #for (kf, Nf/4, Nf/4)
      #for (kf, 1, Nf)
        object{ F[kf] }
      #end
      
      object{ nothing(1.23) }
      object{ nothing(1.32) }
      
      clipped_by{ bbox1 }
    }

  surf
#end