/* 
  A Bamboo texture for abacus sticks
  
  Requires
  
    color_bamboo_lite
    color_bamboo_dark

  Defines
  
    color_bamboo_mean
    texture_bamboo
    
*/
  
#declare color_bamboo_mean = (color_bamboo_lite + color_bamboo_dark)/2;

#declare texture_bamboo =
  texture{
    pigment{ 
      leopard
      color_map{
        [ 0.0 color rgb color_bamboo_lite ]
        [ 0.1 color rgb color_bamboo_lite ]
        [ 0.2 color rgb color_bamboo_dark ]
        [ 1.0 color rgb color_bamboo_dark ]
      }
      scale < 0.015, 0.015, 100 >
    }
    normal{
      leopard 0.2
      scale < 0.015, 0.015, 100 >
    }
    finish {diffuse 0.9 ambient 0.1}
    rotate < 0, 90, 0 >
  }
  texture{
    pigment{color < 1.00, 1.00, 1.00 > filter 0.80}
    normal{
      wrinkles 0.2
      scale < 0.02, 0.02, 100 >
    }
    finish {diffuse 0.0 ambient 0.0 specular 0.4 roughness 0.02}
    rotate < 0, 90, 0 >
  }
