// Last edited on 2024-09-19 08:33:18 by stolfi

#debug "!! Loading slicing_cut_points.inc ...\n"

#macro slicing_cut_points(V, E, Zp, crad)
  // Generates all intersections between slicing planes and edges. Parameters:
  //
  // {V}      Array of vertex coordinates {V[1..Nv]}.
  // {E}      Array of edges {E[1..Ne]}.
  // {Zp}     {Z}-coordinates of the slicing planes {Zp[1..Np]}.
  // {crad}   Radius for cut points of original (type 0) edges.

  #debug "!! Generating edge-plane cut points ...\n"
  
  #local Nv = dimension_size(V, 1) - 1;
  #local Ne = dimension_size(E, 1) - 1;
  
  #local tx = slicing_tx_cuts;

  #local cuts = 
    union{
      #for (ke,1,Ne)
        slicing_cut_points_single(Zp, V, E[ke], crad, tx)
      #end

      object{ nothing(0.87) }
      object{ nothing(0.85) }
    }

  cuts
#end

#macro slicing_cut_points_single(Zp, V, Ek, crad, tx)
  
  #local Np = dimension_size(Zp, 1) - 1;
  
  #local V_org = V[Ek.x];
  #local V_dst = V[Ek.y];
  #local ty = Ek.z;
  
  #if (ty = 0)
    #local brad = crad;
  #elseif (ty = 1)
    #local brad = 0.85*crad;
  #else
    #local brad = 0;
  #end
  
  #if ((V_org.z != V_dst.z) & (brad > 0))
    #for (kp,1,Np)
      #local Zk = Zp[kp];
      #if ((V_org.z-Zk)*(V_dst.z-Zk) <= 0)
        #local s = (Zk - V_org.z)/(V_dst.z - V_org.z);
        #local U = (1-s)*V_org + s*V_dst;
        sphere{ U, brad texture{ tx } }
      #end
    #end
  #end
#end
  
  
  