// Last edited on 2024-09-19 11:04:37 by stolfi

#debug "!! Loading slicing_planes.inc ...\n"

#macro slicing_planes(Zp, V)
  // A stack of slicing planes. Parameters:
  //
  //   {Zp}      The {Z}-coordinates of the planes, {Zp[1..Np]}.
  //   {V}       Coordinates of vertices.

  #debug "!! Generating the slicing planes ...\n"

  #local Np = dimension_size(Zp, 1) - 1;
  #local Nv = dimension_size(V, 1) - 1;
  
  #if (Np > 0)
    // Find vertex X and Y ranges :
    #local Xmin = +99999;
    #local Xmax = -99999;
    #local Ymin = +99999;
    #local Ymax = -99999;
    #for (kv,1,Nv)
      #local Xk = V[kv].x;
      #if (Xk < Xmin) #local Xmin = Xk; #end
      #if (Xk > Xmax) #local Xmax = Xk; #end
      #local Yk = V[kv].y;
      #if (Yk < Ymin) #local Ymin = Yk; #end
      #if (Yk > Ymax) #local Ymax = Yk; #end
    #end
    #local Xmrg = 0.50*(Xmax - Xmin); // Extra margin in X.
    #local Ymrg = 0.10*(Xmax - Xmin); // Extra margin in Y.

    #local P = 
      union{
        #for (kp,1,Np)
          object{ slicing_plane(Xmin, Xmax, Ymin, Ymax, Xmrg, Ymrg, Zp[kp]) }
        #end
        object{ nothing(3.14) } // In case {Np} is 1.
      }
  #else
    #local P = object{ nothing(3.14) }
  #end

  P
#end

#macro slicing_plane(Xmin, Xmax, Ymin, Ymax, Xmrg, Ymrg Z)
  #local dZ = 0.1; // Half-thickness of plane.
  intersection{
    box{ 
      < Xmin-Xmrg-eps, Ymin-Ymrg-eps, Z-dZ >,
      < Xmax+Xmrg+eps, Ymax+Ymrg+eps, Z+dZ >
      texture{ slicing_tx_spla }
    }
    box{ 
      < Xmin-Xmrg, Ymin-Ymrg, Z-dZ-eps >,
      < Xmax+Xmrg, Ymax+Ymrg, Z+dZ+eps >
      texture{ slicing_tx_spla_edge }
    }
  }
    
#end
