# Last edited on 2002-01-16 18:11:39 by stolfi

# Factors a text by placing "{}" around each basic glyph.
# Assumes that the field is encoded with properly capitalized EVA. 
# To be included in factor-field-general etc.

function factor_text(x,   y,e)
{
  # Assumes x is capitalized EVA.  Factors it into
  # basic glyphs, wraps each glyph in braces.
  
  # Clean up any junk:
  gsub(/{[^{}]*}/, "", x);
  gsub(/[!]/, "", x);
  if (match(x, /[^-=\/,. *?%a-zA-Z]/)) 
    { data_error(("invalid char in word \"" x "\"")); }
  
  # Split word into basic glyphs:
  y = "";
  while (x != "") 
    { if (match(x, /^[-=\/,. ]+/))
        { e = substr(x,1,RLENGTH); x = substr(x, RLENGTH+1);
          y = ( y e );
        }
      else
        { match(x, /^([A-Z]*[a-z]|[A-Z]+[?][A-Z?]*[h]|[?][KTPFH]*[h]|[A-Z]*[?])/); 
          if (RSTART != 1) { data_error("duh?"); }
          e = substr(x, 1, RLENGTH); x = substr(x, RLENGTH+1);
          y = ( y "{" e "}");
        }
    }
  return y;
}
