# Last edited on 2002-01-17 03:24:29 by stolfi
# Makefile for computing frequencies of basic glyphs

all: 
	${MAKE} GLYPH_KIND=basic -f glyph-freqs.make  joined
	${MAKE} GLYPH_KIND=rare  -f glyph-freqs.make  joined

######################################################################
# Recursive make (caller must define ${GLYPH_KIND})
#
GLYPH_KIND := GLYPH_KIND.IS.UNDEFINED
ifneq "${GLYPH_KIND}" "GLYPH_KIND.IS.UNDEFINED"

ifeq "${GLYPH_KIND}" "basic"
  # The "basic" glyphs:

  GLYPHS := e,i,o,a,y,q,l,d,r,s,n,m,Ch,Sh,k,t,CKh,CTh,f,p,CFh,CPh
  
  # Use precomputed word frequency table for the entire VMS.

  LANG := voyn
  BOOK := vms
  SUBDIR := ${LANG}/${BOOK}/tot.t
  SOURCE_WFR :=  sample/${SUBDIR}/gud.wfr

  SHOW_BAD_WORDS := 1
  SHOW_FREQS := 1
  NCOLS_SINGLE := 2
endif

ifeq "${GLYPH_KIND}" "rare"
  # The "slightly-weird" glyphs -- weirdos that occur at least a 
  # few times, or look like they belong to a valid series. 

  GLYPHS := g,x,CHh,SHh,CKHh,CTHh,CFHh,CPHh,IKh,ITh,IFh,IPh,IKHh,ITHh,IFHh,IPHh

  # We use Takahashi's version of the text, because those glyphs
  # were omitted or invalidated in some of the other
  # versions (including the majority one).

  LANG := voyn
  BOOK := tak
  SUBDIR := ${LANG}/${BOOK}/tot.t
  SOURCE_EVT := ../../L16+H-eva/text16e6.evt
  SOURCE_WFR :=  sample/${SUBDIR}/gud.wfr

  SHOW_BAD_WORDS := 0
  SHOW_FREQS := 0
  NCOLS_SINGLE := 4

  ${SOURCE_WFR}: ${SOURCE_EVT} \
                 basify-weirdos words-from-evt compute-freqs \
                 glyph-freqs.make
	mkdir -p sample/${SUBDIR}
	cat ${SOURCE_EVT} \
          | grep ';H>' \
          | basify-weirdos \
          | words-from-evt \
          | sort | uniq -c | expand \
          | compute-freqs \
          > ${SOURCE_WFR}
endif

PAPER_DIR := /home/staff/stolfi/papers/voynich-stats/techrep
TBL_DIR := ${PAPER_DIR}/tables/auto
FIG_DIR := ${PAPER_DIR}/figures/auto

OUT_PRF := ${SUBDIR}/${GLYPH_KIND}-glyph
TW_FRQ_FILES := \
  sample/${OUT_PRF}-t.frq \
  sample/${OUT_PRF}-w.frq 
JFR_JOINED :=  sample/${OUT_PRF}-tw.jfr
TEX_JOINED :=  sample/${OUT_PRF}-tw-freqs.tex
TEX_JOINED_EXP :=  ${TBL_DIR}/${OUT_PRF}-tw-freqs.tex

joined: ${JFR_JOINED} ${TEX_JOINED}

singles: 
	for tw in t w; do \
	  ${MAKE} TW=$$tw -f glyph-freqs.make single; \
	done

${JFR_JOINED}: singles
	@echo "${OUT_PRF}-{t,w}.frq -> ${JFR_JOINED}"
	join \
	    -1 3 -2 3 -o 1.1,1.2,2.1,2.2,0 \
	    ${TW_FRQ_FILES} \
	  > ${JFR_JOINED}

${TEX_JOINED}: ${JFR_JOINED} \
               tex-format-elem-tw-freqs parse-elem-list.gawk \
               glyph-freqs.make
	@echo "${JFR_JOINED} -> ${TEX_JOINED}"
	mkdir -p ${TBL_DIR}/${SUBDIR}
	cat ${JFR_JOINED} \
	  | tex-format-elem-tw-freqs -f parse-elem-list.gawk \
	      -v elemList="${GLYPHS}" \
	      -v ncols=2 \
              -v showCounts=1 -v showFreqs=${SHOW_FREQS} \
	  > ${TEX_JOINED}
	update-paper-include ${TEX_JOINED} ${TEX_JOINED_EXP}

######################################################################
# Recursive make (caller must define ${GLYPH_KIND} and ${TW})
#
TW := TW.IS.UNDEFINED
ifneq "${TW}" "TW.IS.UNDEFINED"

OUT_PRF_TW := ${OUT_PRF}-${TW}
FRQ_SINGLE := sample/${OUT_PRF_TW}.frq
TEX_SINGLE := sample/${OUT_PRF_TW}-freq.tex
TEX_SINGLE_EXP := ${TBL_DIR}/${OUT_PRF_TW}-freq.tex

single: ${FRQ_SINGLE} ${TEX_SINGLE}

${FRQ_SINGLE}: ${SOURCE_WFR} \
               capitalize-ligatures \
               factor-field-general factor-text-basic.gawk \
               count-elems parse-elem-list.gawk compute-freqs \
               glyph-freqs.make
	@echo "${SOURCE_WFR} -> ${FRQ_SINGLE}"
	cat ${SOURCE_WFR} \
	  | capitalize-ligatures -v field=3 \
	  | factor-field-general \
              -f factor-text-basic.gawk -v inField=3 -v outField=4 \
	  | gawk -v tw="${TW}" \
	      '/./{ print (tw == "t" ? $$1 : 1), $$4; }'  \
	  | count-elems -f parse-elem-list.gawk \
	      -v elemList="${GLYPHS}" \
	      -v joinRepeats=0 \
	      -v showBadWords=${SHOW_BAD_WORDS} \
	  | compute-freqs \
	  > ${FRQ_SINGLE}

${TEX_SINGLE}: ${FRQ_SINGLE} \
               tex-format-elem-freqs parse-elem-list.gawk \
               glyph-freqs.make
	@echo "${FRQ_SINGLE} -> ${TEX_SINGLE}"
	mkdir -p ${TBL_DIR}/${SUBDIR}
	cat ${FRQ_SINGLE} \
	  | tex-format-elem-freqs -f parse-elem-list.gawk \
	      -v elemList="${GLYPHS}" \
	      -v ncols=${NCOLS_SINGLE} \
	      -v showCounts=1 -v showFreqs=${SHOW_FREQS} \
	      -v showClasses=0 -v showHeader=0 \
	  > ${TEX_SINGLE}
	update-paper-include ${TEX_SINGLE} ${TEX_SINGLE_EXP}

endif
# End of ${TW} recursion
######################################################################

endif
# End of ${GLYPH_KIND} recursion
######################################################################
