# Last edited on 2002-01-17 03:32:45 by stolfi
# Makefile for tabulating frequencies of pairs of basic glyphs

all:
	for tw in t w; do \
	  ${MAKE} TW=$$tw -f glyph-pair-freqs.make single; \
	done

PAPER_DIR := /home/staff/stolfi/papers/voynich-stats/techrep
TBL_DIR := ${PAPER_DIR}/tables/auto
FIG_DIR := ${PAPER_DIR}/figures/auto

# Use precomputed word frequency table for the entire VMS.

LANG := voyn
BOOK := vms
SUBDIR :=  ${LANG}/${BOOK}/tot.t
SOURCE_WFR := sample/${SUBDIR}/gud.wfr
ROW_GLYPHS := _,-,q,-,y,l,-,r,s,-,n,m,-,i,a,-,o,-,d,-,e,Ch,Sh,-,k,t,-,f,p,-,CKh,CTh,CFh,CPh
COL_GLYPHS := _,-,q,-,e,d,s,a,o,y,Ch,Sh,-,i,-,l,r,-,m,n,-,k,t,f,p,-,CKh,CTh,CFh,CPh

OUT_PRF := ${SUBDIR}/glyph-pair

######################################################################
# Recursive make for tokens or words
# Caller must define ${TW} = "t" or "w"
#
TW := TW.IS.UNDEFINED
ifneq "${TW}" "TW.IS.UNDEFINED"

OUT_PRF_TW := ${OUT_PRF}-${TW}

GPF_TW := sample/${OUT_PRF_TW}.gpf
TEX_CTS_TW := sample/${OUT_PRF_TW}-counts.tex
TEX_CTS_TW_EXP := ${TBL_DIR}/${OUT_PRF_TW}-counts.tex

single: single-counttbl single-freqtbls

single-counttbl: ${GPF_TW} ${TEX_CTS_TW}

single-freqtbls:
	${MAKE} TW=${TW} PN=next -f glyph-pair-freqs.make  freqtbl
	${MAKE} TW=${TW} PN=prev -f glyph-pair-freqs.make  freqtbl

${GPF_TW}: ${SOURCE_WFR} \
            capitalize-ligatures \
            factor-field-general factor-text-basic.gawk \
            count-elem-pairs parse-elem-list.gawk \
            compute-row-col-freqs \
            glyph-pair-freqs.make
	@echo "${SOURCE_WFR} -> ${GPF_TW}"
	cat ${SOURCE_WFR} \
	  | capitalize-ligatures -v field=3 \
	  | factor-field-general \
              -f factor-text-basic.gawk \
              -v inField=3 -v outField=4 \
	  | gawk -v tw="${TW}" '/./{ print (tw == "t" ? $$1 : 1), $$4; }'  \
	  | count-elem-pairs -f parse-elem-list.gawk \
	      -v endMarker='_' -v showBadWords=0 \
	      -v rowList="${ROW_GLYPHS}" -v colList="${COL_GLYPHS}" \
	  | compute-row-col-freqs -v outputTotals=1 \
	  > ${GPF_TW}

${TEX_CTS_TW}: ${GPF_TW} \
            tex-format-elem-pair-freqs parse-elem-list.gawk \
            glyph-pair-freqs.make
	@echo "${GPF_TW} -> ${TEX_CTS_TW}"
	cat ${GPF_TW} \
	  | tex-format-elem-pair-freqs -f parse-elem-list.gawk \
	      -v rowList="${ROW_GLYPHS}" \
              -v colList="${COL_GLYPHS},-,+" \
	      -v endMarker='_' -v minFreq=0.015 \
	      -v showCounts=1 \
	      -v showColFreqs=0 -v showRowFreqs=0 \
	  > ${TEX_CTS_TW}
	update-paper-include ${TEX_CTS_TW} ${TEX_CTS_TW_EXP}

######################################################################
# Recursive make for prev/next frequency tables.
# Caller must define ${TW} = "t" or "w"
# and ${PN} = "prev" or "next"
#
PN := PN.IS.UNDEFINED
ifneq "${PN}" "PN.IS.UNDEFINED"

OUT_PRF_TW_PN := ${OUT_PRF_TW}-${PN}
TEX_FRQ_TW_PN := sample/${OUT_PRF_TW_PN}-freqs.tex
TEX_FRQ_TW_PN_EXP := ${TBL_DIR}/${OUT_PRF_TW_PN}-freqs.tex

freqtbl: ${TEX_FRQ_TW_PN}

${TEX_FRQ_TW_PN}: ${GPF_TW} \
            tex-format-elem-pair-freqs parse-elem-list.gawk \
            glyph-pair-freqs.make
	@echo "${GPF_TW} -> ${TEX_FRQ_TW_PN}"
ifeq "${PN}" "next"
	cat ${GPF_TW} \
	  | tex-format-elem-pair-freqs -f parse-elem-list.gawk \
	      -v rowList="${ROW_GLYPHS}" \
	      -v colList="`echo ${COL_GLYPHS} | sed -e 's/[,][-]//g'`" \
	      -v endMarker='_' -v minFreq=0.015 \
	      -v showCounts=0 \
	      -v showRowFreqs=1 -v showColFreqs=0 \
	  > ${TEX_FRQ_TW_PN}
endif
ifeq "${PN}" "prev"
	cat ${GPF_TW} \
	  | tex-format-elem-pair-freqs -f parse-elem-list.gawk \
	      -v rowList="`echo ${ROW_GLYPHS} | sed -e 's/[,][-]//g'`" \
              -v colList="${COL_GLYPHS}" \
	      -v endMarker='_' -v minFreq=0.015 \
	      -v showCounts=0 \
	      -v showRowFreqs=0 -v showColFreqs=1 \
	  > ${TEX_FRQ_TW_PN}
endif
	update-paper-include ${TEX_FRQ_TW_PN} ${TEX_FRQ_TW_PN_EXP}

endif
# End of ${PN} recursion
######################################################################

endif
# End of ${TW} recursion
######################################################################

