# Last edited on 2002-01-17 03:42:42 by stolfi
# Makefile for tabulating frequencies of basic glyph repeats

all: singles joined

GLYPHS := e,i,o,a,y,l,d,Ch,Sh,r,s,n,m,q,k,t,CKh,CTh,f,p,CFh,CPh
LANG := voyn
BOOK := vms
SUBDIR := ${LANG}/${BOOK}/tot.t
SOURCE_WFR := sample/${SUBDIR}/gud.wfr
MAX_REPEAT = 4

PAPER_DIR := /home/staff/stolfi/papers/voynich-stats/techrep
TBL_DIR := ${PAPER_DIR}/tables/auto
FIG_DIR := ${PAPER_DIR}/figures/auto

OUT_PRF := ${SUBDIR}/glyph-rep
TW_FRQ_FILES := \
  sample/${OUT_PRF}-t.frq \
  sample/${OUT_PRF}-w.frq 
JFR_JOINED :=  sample/${OUT_PRF}-tw.jfr
TEX_JOINED :=  sample/${OUT_PRF}-tw-freqs.tex
TEX_JOINED_EXP :=  ${TBL_DIR}/${OUT_PRF}-tw-freqs.tex

joined: ${JFR_JOINED} ${TEX_JOINED}

singles: 
	for tw in t w; do \
	  ${MAKE} TW=$$tw -f glyph-rep-freqs.make single; \
	done

${JFR_JOINED}: singles
	@echo "${OUT_PRF}-{t,w}.frq -> ${JFR_JOINED}"
	join \
	    -1 3 -2 3 -o 1.1,1.2,2.1,2.2,0 \
	    ${TW_FRQ_FILES} \
	  > ${JFR_JOINED}

${TEX_JOINED}: ${JFR_JOINED} \
            tex-format-elem-rep-tw-freqs parse-elem-list.gawk \
            glyph-rep-freqs.make
	@echo "${JFR_JOINED} -> ${TEX_JOINED}"
	cat ${JFR_JOINED} \
	  | tex-format-elem-rep-tw-freqs -f parse-elem-list.gawk \
	      -v elemList="${GLYPHS}" \
	      -v maxRepeat=${MAX_REPEAT} \
              -v showCounts=1 -v showFreqs=1 \
	  > ${TEX_JOINED}
	update-paper-include ${TEX_JOINED} ${TEX_JOINED_EXP}

######################################################################
# Recursive make for token/word
# Caller must define ${TW} = "t" or "w"
#
TW := TW.IS.UNDEFINED
ifneq "${TW}" "TW.IS.UNDEFINED"

OUT_PRF_TW := ${OUT_PRF}-${TW}
FRQ_SINGLE := sample/${OUT_PRF_TW}.frq
TEX_SINGLE := sample/${OUT_PRF_TW}-freq.tex
TEX_SINGLE_EXP := ${TBL_DIR}/${OUT_PRF_TW}-freq.tex

single: ${FRQ_SINGLE} ${TEX_SINGLE}

${FRQ_SINGLE}: ${SOURCE_WFR} \
            capitalize-ligatures \
            factor-field-general factor-text-basic.gawk \
            count-elems parse-elem-list.gawk compute-freqs \
            glyph-rep-freqs.make
	@echo "${SOURCE_WFR} -> ${FRQ_SINGLE}"
	cat ${SOURCE_WFR} \
	  | capitalize-ligatures -v field=3 \
	  | factor-field-general \
              -f factor-text-basic.gawk -v inField=3 -v outField=4 \
	  | gawk -v tw="${TW}" '/./{ print (tw == "t" ? $$1 : 1), $$4; }'  \
	  | count-elems -f parse-elem-list.gawk \
	      -v elemList="${GLYPHS}" \
	      -v joinRepeats=1 \
	      -v showBadWords=0 \
	  | compute-freqs \
	  > ${FRQ_SINGLE}

${TEX_SINGLE}: ${FRQ_SINGLE} \
            tex-format-elem-rep-freqs parse-elem-list.gawk \
            glyph-rep-freqs.make
	@echo "${FRQ_SINGLE} -> ${TEX_SINGLE}"
	cat ${FRQ_SINGLE} \
	  | tex-format-elem-rep-freqs -f parse-elem-list.gawk \
	      -v elemList="${GLYPHS}" \
	      -v showCounts=1 -v showFreqs=0 \
	      -v maxRepeat=${MAX_REPEAT} \
	  > ${TEX_SINGLE}
	update-paper-include ${TEX_SINGLE} ${TEX_SINGLE_EXP}

endif
# End of ${TW} recursion
######################################################################
