% -------  New function --------------

function dest = Dest(e)

dest = DData(e);
% -------  End of function --------------



% -------  New function --------------
 
function org= Org(e)

org = OData(e);
% -------  End of function --------------



% -------  New function --------------
 
function Swap(e)

a = Oprev(e);
b = Oprev(Symet(e));
splice(e,a);
splice(Symet(e),b);
splice(e,Lnext(a));
splice(Symet(e),Lnext(b));
set_Org(e,Dest(a));
set_Dest(e,Dest(b));



% -------  End of function --------------



% -------  New function --------------
 
function res = ccw(site_a, site_b, site_c)

x1 = site_a.x;
y1 = site_a.y;

x2 = site_b.x;
y2 = site_b.y;

x3 = site_c.x;
y3 = site_c.y;


res = (x2*y3-y2*x3) - (x1*y3-y1*x3) + (x1*y2-y1*x2);


%float ccw(site_struct *a, site_struct *b, site_struct *c)
%  {
%    double x1 = a->x, y1 = a->y;
%    double x2 = b->x, y2 = b->y;
%    double x3 = c->x, y3 = c->y;
%
%    return (x2*y3-y2*x3) - (x1*y3-y1*x3) + (x1*y2-y1*x2);
%  }

% -------  End of function --------------



% -------  New function --------------
 
function e = conn(a,b)
%   (edge_ref) e = conn( edge_ref a, edge_ref b)
% Adds a new edge "e" connecting the destination of "a" to the 
% origin of "b" 

e = make_edge;
set_Org(e,Dest(a));
set_Dest(e,Org(b));
splice(e,LNext(a));
splice(Symet(e),b);


%edge_ref connect(edge_ref a, edge_ref b)
%  {
%    edge_ref e;
%
%    e = make_edge();
%    ORG(e) = DEST(a);
%    DEST(e) = ORG(b);
%    splice(e, LNEXT(a));
%    splice(SYM(e), b);
%    return e;
%  }

% -------  End of function --------------



% -------  New function --------------
 
function [le,re] = delaunay_build(sites,nsites)
global sites;

sites= sort_sites(sites,nsites);
[le,re] = rec_delaunay(sites,1,nsites);

%edge_ref delaunay_build(site_struct sites[], int nsites)
%
%{
%    edge_ref le, re;
%    sort_sites(sites, nsites);
%    rec_delaunay(sites, 0, nsites, &le, &re);
%    return (le);
%  }

% -------  End of function --------------



% -------  New function --------------
 
function res = equal(site1,site2)

if(site1.x == site2.x)
   if(site1.y==site2.y)
      res = 1;
   else
      res = 0;
   end;
else
   res = 0;
end;

% -------  End of function --------------



% -------  New function --------------
 
wf = init_wf(19);

sites = cell(1,wf.raynum);

for i=1:wf.raynum
   sites{i}.x = wf.dest{i}(1);
   sites{i}.y = wf.dest{i}(2);
	sites{i}.z = wf.dest{i}(3);
end;

% -------  End of function --------------



% -------  New function --------------
 
function res = incircle(a,b,c,d)

x1 = a.x;
y1 = a.y;

x2 = b.x;
y2 = b.y;

x3 = c.x;
y3 = c.y;

x4 = d.x;
y4 = d.y;

res = ((y4-y1)*(x2-x3)+(x4-x1)*(y2-y3))*((x4-x3)*(x2-x1)-(y4-y3)*(y2-y1)) > ...
   ((y4-y3)*(x2-x1)+(x4-x3)*(y2-y1))*((x4-x1)*(x2-x3)-(y4-y1)*(y2-y3));

%int incircle(site_struct *a, site_struct *b, site_struct *c, site_struct *d)
%  {
%    double x1 = a->x, y1 = a->y;
%    double x2 = b->x, y2 = b->y;
%    double x3 = c->x, y3 = c->y;
%    double x4 = d->x, y4 = d->y;
%
%    return ((y4-y1)*(x2-x3)+(x4-x1)*(y2-y3))*((x4-x3)*(x2-x1)-(y4-y3)*(y2-y1)) >
%	   ((y4-y3)*(x2-x1)+(x4-x3)*(y2-y1))*((x4-x1)*(x2-x3)-(y4-y1)*(y2-y3));
%  }

% -------  End of function --------------



% -------  New function --------------
 
function res = leftof(site,e)

res = ccw(site,Org(e),Dest(e)) > 0;

%int leftof(site_struct *s, edge_ref e)
%  {
%    return ccw(s, ORG(e), DEST(e)) > 0.0;
%  }

% -------  End of function --------------



% -------  New function --------------
 
function main(n,p)

figure;
hold on;

global next_mark;
global sites;

nsites = n;

%[sites,nsites,xlimts,ylimts] = makesites(nsites,p);

get_sites;
plot_sites(sites);
nsites = length(sites);


%axis([xlimts(1) xlimts(2) ylimts(1) ylimts(2)]);

[e1,e2] = delaunay_build (sites, nsites);

next_mark = 1;

%quad_enum(e1,'visit_proc');
%quad_enum(e2,'visit_proc');

%int main(void)
%  {
%    edge_ref e;
%
%    makesites();
%
%    e = delaunay_build (sites, NSITES);
%
%    printf("Delaunay returned %x:%d \n", (e & 0xfffffffcu), (e&3));
%
%    plot_delaunay(e);
%
%    return(0);
%  }


% -------  End of function --------------



% -------  New function --------------
 
function [sites,n,xlim,ylim] = makesites(nsites,p)

rx = random('unid',p,1,nsites);
ry = random('unid',p,1,nsites);

ctrl = zeros(max(rx),max(ry));

xlim(1)=min([0,rx]);
xlim(2)=max(rx);

ylim(1)=min([0,ry]);
ylim(2)=max(ry);


n = nsites;

sites = cell(1,nsites)

for i=1:nsites
   if(ctrl(rx(i),ry(i))~=1)
	   sites{i}.x = rx(i);
      sites{i}.y = ry(i);
      ctrl(rx(i),ry(i))=1;
   else
      n = n-1;
   end;
   
end;

%void makesites()
%  {
%    int i, j;
%    float s, t;
%    
%    srandom(4615);
%
%    if (NORMAL) 

%{	/* central limit approx to normal distribuition: */
%	for (i=0; i < NSITES; i++) 
%          {
%            s = t = 0.0;
%	    for (j=0; j<9; j++)
%              { s += frandom() - 0.5; t += frandom() - 0.5; }
%	    sites[i].x = s;
%	    sites[i].y = t;
%	  }
%      }
%    else 
%      {	/* uniform distribution: */
%	for (i=0; i<NSITES; i++) 
%	  {           
%	    sites[i].x = frandom() - 0.5;
%	    sites[i].y = frandom() - 0.5;
%	  }
%      }
%  }

% -------  End of function --------------



% -------  New function --------------
 
function [sites,n] = makesites3(op)

wf = init_wf(19);
sites = cell(1,length(wf.dest));

for i=1:length(wf.dest);
   sites{i}.x = wf.dest{i}(1);
   sites{i}.y = wf.dest{i}(2);
   sites{i}.z = wf.dest{i}(3);
end;

% -------  End of function --------------



% -------  New function --------------
 
function plot_edge(e,cor)

o = Org(e);
d = Dest(e);

plot3([o.x,d.x],[o.y,d.y],[o.z,d.z],cor);


% -------  End of function --------------



% -------  New function --------------
 
function plot_sites(sites)

x=[];
y=[];
z=[];

for i=1:length(sites)
   x = [x, sites{i}.x];
   y = [y,sites{i}.y];
   z = [z,sites{i}.z];

end;

plot3(x,y,z,'gp');
hold on;
% -------  End of function --------------



% -------  New function --------------
 
function [le,re] = rec_delaunay(sites,sl,sh)

if( sh == sl + 1)
   a = make_edge;
   set_Org(a,sites{sl});
   set_Dest(a,sites{sl+1});
   plot_edge(a,'r');
   %pause(0.01);
   
   le = a;
   re = Symet(a);
else
   if (sh == sl+2)
      a = make_edge;
      b = make_edge;
      splice(Symet(a),b);
      set_Org(a,sites{sl});
      set_Dest(a,sites{sl+1});
	   set_Org(b,sites{sl+1});
      set_Dest(b,sites{sl+2});
      
      plot_edge(a,'r');
      %pause(0.01);
      plot_edge(b,'r');
      %pause(0.01);
      
      ct = ccw(sites{sl},sites{sl+1},sites{sl+2});
      
      if(ct==0)
         le = a;
         re = Symet(b);
      else
         c = conn(b,a);
         plot_edge(c,'r');
         %pause(0.01);
         
         if(ct>0)
            le=a;
            re = Symet(b);
         else
            le=Symet(c);
            re = c;
         end;
      end;
      
   else
      sm = floor((sl + sh)/2);
      [ldo,ldi ] = rec_delaunay(sites, sl, sm);
      %quad_enum(ldo,'visit_proc');
      %quad_enum(ldi,'visit_proc');
      %pause(0.01);
      
      [rdi,rdo ] = rec_delaunay(sites, sm+1, sh);
      %quad_enum(rdi,'visit_proc');
      %quad_enum(rdo,'visit_proc');
      %pause(0.01);

      while(1)
         if(leftof(Org(rdi),ldi))
            ldi = Lnext(ldi);
         else
            if (rightof(Org(ldi),rdi))
               rdi = Onext(Symet(rdi));
            else
               break;
            end;
         end;
      end;
      
      basel = conn(Symet(rdi),ldi);
      plot_edge(basel,'r');
      %disp('basel');
      %pause(0.01);
      if(equal(Org(ldi),Org(ldo)))
         ldo = Symet(basel);
      end;
      if(equal(Org(rdi),Org(rdo)))
         rdo = basel;
      end;
      
      
      while(1) % Merge Loop
         lcand = Onext(Symet(basel));
         if(rightof(Dest(lcand),basel))
            while(incircle(Dest(basel),Org(basel),Dest(lcand),Dest(Onext(lcand))))
               t = Onext(lcand);
               destroy_edge(lcand);
               plot_edge(lcand,'y');
         
               lcand = t;
            end;
         end;
         
         rcand = Oprev(basel);
         if(rightof(Dest(rcand),basel))
            while(incircle(Dest(basel),Org(basel),Dest(rcand),Dest(Oprev(rcand))))
               t = Oprev(rcand);
               destroy_edge(rcand);
               plot_edge(rcand,'y');
               rcand = t;
            end;
         end;
         
         
         if((rightof(DEST(lcand), basel)==0)&(rightof(DEST(rcand), basel)==0))
            %le = ldo;
            %re = rdo;
            %plot_edge(basel,'r');
            break;
         end;
         
         if ( (rightof(DEST(lcand), basel)==0) |( rightof(DEST(rcand), basel) & ...
               incircle(DEST(lcand), ORG(lcand), ORG(rcand), DEST(rcand)))...
               )
            basel = conn(rcand, Symet(basel));
            plot_edge(basel,'r');
            %disp('basel');
            %pause(0.01);
         else
            basel = conn(Symet(basel), Symet(lcand));
            plot_edge(basel,'r');
            %disp('basel');
            %pause(0.01);
         end;
         
         le = ldo;
         re = rdo;
         %plot_edge(re,'r');
         %plot_edge(le,'r');
         %quad_enum(le,'visit_proc');
         %quad_enum(re,'visit_proc');
         pause(0.01);
      end;
   end;
end;

% -------  End of function --------------



% -------  New function --------------
 
function res = rightof(site,e)

res = ccw(site,Dest(e),Org(e)) > 0;

%int rightof(site_struct *s, edge_ref e)
%  {
%    return ccw(s, DEST(e), ORG(e)) > 0.0;
%  }

% -------  End of function --------------



% -------  New function --------------
 
function set_Dest(e,value)

set_DData(e,value);
% -------  End of function --------------



% -------  New function --------------
 
function set_Org(e,value)

set_OData(e,value);
% -------  End of function --------------



% -------  New function --------------
 
function [sites] = sort_sites(sites, nsites)

gap=floor(nsites/2);
while(gap > 0)
   for i=gap:(nsites-1)
      j = i - gap + 1;
      while(j>0)
         if(sites{j}.x ~= sites{j+gap}.x)
            if(sites{j}.x < sites{j+gap}.x)
               break;
            end;
         else
            if(sites{j}.y < sites{j+gap}.y)
               break;
            end;
         end;
         tmp = sites{j};
         sites{j} = sites{j+gap};
         sites{j+gap} = tmp;
         
         j = j - gap;
      end;
   end;
   
   gap = floor(gap/2);
end;
   
%void sort_sites(site_struct sites[], int nsites)
%  {
%    int gap, i, j;
%    site_struct tmp;

%    for (gap = nsites/2; gap > 0; gap /= 2)
%      for (i = gap; i < nsites; i++)
%	for (
%	    j = i-gap; 
%	    j >= 0 && 
%	      ( sites[j].x != sites[j+gap].x ? 
%                (sites[j].x > sites[j+gap].x) : 
%                (sites[j].y > sites[j+gap].y)
%              );
%	    j -= gap
%	  ) 
%	  {
%	    tmp = sites[j]; sites[j] = sites[j+gap]; sites[j+gap] = tmp;
%	  }
%  }

% -------  End of function --------------



% -------  New function --------------
 
function visit_proc(e)

global saida;


o = Org(e);
d = Dest(e);
x = [o(1),d(1)];
y = [o(2),d(2)];

aresta.x = x;
aresta.y = y;

saida(length(saida)+1) = aresta

plot(x,y,'b-');
% -------  End of function --------------



% -------  New function --------------
 
