#declare fan_outer_chain_even_radius = 100.0000;

#declare fan_outer_chain_odd_radius = 81.3473;

#declare fan_inner_chain_even_radius = 30.2264;

#declare fan_inner_chain_odd_radius = 37.1572;

#declare fan_thickness = 9.9996;

#declare fan_min_elevation = 60.00000; // Degrees.

#declare fan_max_elevation = 120.00000; // Degrees.

#declare fan_num_faces = 24;

#declare fan_num_edges = 66;

#declare fan_num_vertices = 44;

#declare fan_num_outer_chain_edges = 10;

#declare fan_num_inner_chain_edges = 10;

#declare fan_outer_chain_shape = 3;

#macro fan_vertices()
  #local Nv = fan_num_vertices;
  // Returns an array {V} of {Nv+1} elements.
  // Element {V[kv]} is the vertex with OBJ index {kv} in {1..Nv}.
  // Element {V[0]} is not used.
  #local V = array[Nv+1]
  #local V[   0] = < -1, -1, -1>; // Not used.
  #local V[   1] = < 4.9998, 50.0000, 86.6026 >; // vo.0.0
  #local V[   2] = < 4.9998, 33.0870, 74.3144 >; // vo.0.1
  #local V[   3] = < 4.9998, 30.9016, 95.1056 >; // vo.0.2
  #local V[   4] = < 4.9998, 16.9130, 79.5696 >; // vo.0.3
  #local V[   5] = < 4.9998, 10.4528, 99.4522 >; // vo.0.4
  #local V[   6] = < 4.9998, 0.0000, 81.3474 >; // vo.0.5
  #local V[   7] = < 4.9998, -10.4528, 99.4522 >; // vo.0.6
  #local V[   8] = < 4.9998, -16.9130, 79.5696 >; // vo.0.7
  #local V[   9] = < 4.9998, -30.9016, 95.1056 >; // vo.0.8
  #local V[  10] = < 4.9998, -33.0870, 74.3144 >; // vo.0.9
  #local V[  11] = < 4.9998, -50.0000, 86.6026 >; // vo.0.10
  #local V[  12] = < 4.9998, 15.1132, 26.1768 >; // vi.0.0
  #local V[  13] = < 4.9998, 15.1132, 33.9448 >; // vi.0.1
  #local V[  14] = < 4.9998, 9.3404, 28.7470 >; // vi.0.2
  #local V[  15] = < 4.9998, 7.7254, 36.3452 >; // vi.0.3
  #local V[  16] = < 4.9998, 3.1596, 30.0608 >; // vi.0.4
  #local V[  17] = < 4.9998, 0.0000, 37.1572 >; // vi.0.5
  #local V[  18] = < 4.9998, -3.1596, 30.0608 >; // vi.0.6
  #local V[  19] = < 4.9998, -7.7254, 36.3452 >; // vi.0.7
  #local V[  20] = < 4.9998, -9.3404, 28.7470 >; // vi.0.8
  #local V[  21] = < 4.9998, -15.1132, 33.9448 >; // vi.0.9
  #local V[  22] = < 4.9998, -15.1132, 26.1768 >; // vi.0.10
  #local V[  23] = < -4.9998, 50.0000, 86.6026 >; // vo.1.0
  #local V[  24] = < -4.9998, 33.0870, 74.3144 >; // vo.1.1
  #local V[  25] = < -4.9998, 30.9016, 95.1056 >; // vo.1.2
  #local V[  26] = < -4.9998, 16.9130, 79.5696 >; // vo.1.3
  #local V[  27] = < -4.9998, 10.4528, 99.4522 >; // vo.1.4
  #local V[  28] = < -4.9998, 0.0000, 81.3474 >; // vo.1.5
  #local V[  29] = < -4.9998, -10.4528, 99.4522 >; // vo.1.6
  #local V[  30] = < -4.9998, -16.9130, 79.5696 >; // vo.1.7
  #local V[  31] = < -4.9998, -30.9016, 95.1056 >; // vo.1.8
  #local V[  32] = < -4.9998, -33.0870, 74.3144 >; // vo.1.9
  #local V[  33] = < -4.9998, -50.0000, 86.6026 >; // vo.1.10
  #local V[  34] = < -4.9998, 15.1132, 26.1768 >; // vi.1.0
  #local V[  35] = < -4.9998, 15.1132, 33.9448 >; // vi.1.1
  #local V[  36] = < -4.9998, 9.3404, 28.7470 >; // vi.1.2
  #local V[  37] = < -4.9998, 7.7254, 36.3452 >; // vi.1.3
  #local V[  38] = < -4.9998, 3.1596, 30.0608 >; // vi.1.4
  #local V[  39] = < -4.9998, 0.0000, 37.1572 >; // vi.1.5
  #local V[  40] = < -4.9998, -3.1596, 30.0608 >; // vi.1.6
  #local V[  41] = < -4.9998, -7.7254, 36.3452 >; // vi.1.7
  #local V[  42] = < -4.9998, -9.3404, 28.7470 >; // vi.1.8
  #local V[  43] = < -4.9998, -15.1132, 33.9448 >; // vi.1.9
  #local V[  44] = < -4.9998, -15.1132, 26.1768 >; // vi.1.10
  V
#end

#macro fan_edges()
  #local Ne = fan_num_edges;
  // Returns an array {E} of {Ne+1} elements.
  // Element {E[ke]} is the triple {<ko[ke],kd[ke],ty[ke]>}, for {ke} in {1..Ne}.
  // Here {ko[ke],kd[ke]} are the indices of the vertices
  // which are the endpoints of edge {E[ke]},
  // and {ty[ke]} is an edge type code:
  // 
  //   100-199 outer chain edge of plaza [0].
  //   200-299 inner chain edge of plaza [0].
  //   300-399 outer chain edge of plaza [1].
  //   400-499 inner chain edge of plaza [1].
  //   0       other.
  // 
  // The index of the edge in the chain is {ty[ke] % 100}.
  #local E = array[Ne+1]
  #local E[   0] = < -1, -1, -1 >; // Not used.
  #local E[   1] = < 1, 23, 0 >;
  #local E[   2] = < 23, 24, 300 >;
  #local E[   3] = < 2, 24, 0 >;
  #local E[   4] = < 24, 25, 301 >;
  #local E[   5] = < 3, 25, 0 >;
  #local E[   6] = < 25, 26, 302 >;
  #local E[   7] = < 4, 26, 0 >;
  #local E[   8] = < 26, 27, 303 >;
  #local E[   9] = < 5, 27, 0 >;
  #local E[  10] = < 27, 28, 304 >;
  #local E[  11] = < 6, 28, 0 >;
  #local E[  12] = < 28, 29, 305 >;
  #local E[  13] = < 7, 29, 0 >;
  #local E[  14] = < 29, 30, 306 >;
  #local E[  15] = < 8, 30, 0 >;
  #local E[  16] = < 30, 31, 307 >;
  #local E[  17] = < 9, 31, 0 >;
  #local E[  18] = < 31, 32, 308 >;
  #local E[  19] = < 10, 32, 0 >;
  #local E[  20] = < 32, 33, 309 >;
  #local E[  21] = < 12, 13, 100 >;
  #local E[  22] = < 13, 35, 0 >;
  #local E[  23] = < 13, 14, 101 >;
  #local E[  24] = < 14, 36, 0 >;
  #local E[  25] = < 14, 15, 102 >;
  #local E[  26] = < 15, 37, 0 >;
  #local E[  27] = < 15, 16, 103 >;
  #local E[  28] = < 16, 38, 0 >;
  #local E[  29] = < 16, 17, 104 >;
  #local E[  30] = < 17, 39, 0 >;
  #local E[  31] = < 17, 18, 105 >;
  #local E[  32] = < 18, 40, 0 >;
  #local E[  33] = < 18, 19, 106 >;
  #local E[  34] = < 19, 41, 0 >;
  #local E[  35] = < 19, 20, 107 >;
  #local E[  36] = < 20, 42, 0 >;
  #local E[  37] = < 20, 21, 108 >;
  #local E[  38] = < 21, 43, 0 >;
  #local E[  39] = < 21, 22, 0 >;
  #local E[  40] = < 22, 44, 0 >;
  #local E[  41] = < 12, 34, 0 >;
  #local E[  42] = < 1, 12, 0 >;
  #local E[  43] = < 11, 33, 0 >;
  #local E[  44] = < 33, 44, 0 >;
  #local E[  45] = < 1, 2, 100 >;
  #local E[  46] = < 2, 3, 101 >;
  #local E[  47] = < 3, 4, 102 >;
  #local E[  48] = < 4, 5, 103 >;
  #local E[  49] = < 5, 6, 104 >;
  #local E[  50] = < 6, 7, 105 >;
  #local E[  51] = < 7, 8, 106 >;
  #local E[  52] = < 8, 9, 107 >;
  #local E[  53] = < 9, 10, 108 >;
  #local E[  54] = < 10, 11, 0 >;
  #local E[  55] = < 11, 22, 0 >;
  #local E[  56] = < 23, 34, 0 >;
  #local E[  57] = < 34, 35, 400 >;
  #local E[  58] = < 35, 36, 401 >;
  #local E[  59] = < 36, 37, 402 >;
  #local E[  60] = < 37, 38, 403 >;
  #local E[  61] = < 38, 39, 404 >;
  #local E[  62] = < 39, 40, 405 >;
  #local E[  63] = < 40, 41, 406 >;
  #local E[  64] = < 41, 42, 407 >;
  #local E[  65] = < 42, 43, 408 >;
  #local E[  66] = < 43, 44, 409 >;
  E
#end

#macro fan_faces()
  #local Nf = fan_num_faces;
  // Returns an array {F} of {Nf+1} elements.
  // Element {F[kf]} is an instance of the
  // 'plane' (halfspace) POV-ray primitive
  // for {kf} in {1..Nf}.
  // The order is outer chain faces, inner chain faces.
  // inner-outer connecting faces,
  // and finally the plazas.
  #local F = array[Nf+1]
  #local F[   0] = sphere{ <0,0,0>, 1000} // Not used.
  #local F[   1] = plane{  < 0.0000000, -0.5877853, 0.8090170 >, 0 translate < 4.9998, 50.0000, 86.6025 > }
  #local F[   2] = plane{  < 0.0000000, 0.9945219, 0.1045285 >, 0 translate < 4.9998, 33.0869, 74.3145 > }
  #local F[   3] = plane{  < 0.0000000, -0.7431448, 0.6691306 >, 0 translate < 4.9998, 30.9017, 95.1057 > }
  #local F[   4] = plane{  < 0.0000000, 0.9510565, 0.3090170 >, 0 translate < 4.9998, 16.9131, 79.5697 > }
  #local F[   5] = plane{  < 0.0000000, -0.8660254, 0.5000000 >, 0 translate < 4.9998, 10.4528, 99.4522 > }
  #local F[   6] = plane{  < 0.0000000, 0.8660254, 0.5000000 >, 0 translate < 4.9998, 0.0000, 81.3473 > }
  #local F[   7] = plane{  < 0.0000000, -0.9510565, 0.3090170 >, 0 translate < 4.9998, -10.4528, 99.4522 > }
  #local F[   8] = plane{  < 0.0000000, 0.7431448, 0.6691306 >, 0 translate < 4.9998, -16.9131, 79.5697 > }
  #local F[   9] = plane{  < 0.0000000, -0.9945219, 0.1045285 >, 0 translate < 4.9998, -30.9017, 95.1057 > }
  #local F[  10] = plane{  < 0.0000000, 0.5877853, 0.8090170 >, 0 translate < 4.9998, -33.0869, 74.3145 > }
  #local F[  11] = plane{  < 0.0000000, -1.0000000, 0.0000000 >, 0 translate < -4.9998, 15.1132, 26.1769 > }
  #local F[  12] = plane{  < 0.0000000, 0.6691306, -0.7431448 >, 0 translate < -4.9998, 15.1132, 33.9448 > }
  #local F[  13] = plane{  < 0.0000000, -0.9781476, -0.2079117 >, 0 translate < -4.9998, 9.3405, 28.7470 > }
  #local F[  14] = plane{  < 0.0000000, 0.8090170, -0.5877853 >, 0 translate < -4.9998, 7.7254, 36.3453 > }
  #local F[  15] = plane{  < 0.0000000, -0.9135455, -0.4067366 >, 0 translate < -4.9998, 3.1595, 30.0608 > }
  #local F[  16] = plane{  < 0.0000000, 0.9135455, -0.4067366 >, 0 translate < -4.9998, 0.0000, 37.1572 > }
  #local F[  17] = plane{  < 0.0000000, -0.8090170, -0.5877853 >, 0 translate < -4.9998, -3.1595, 30.0608 > }
  #local F[  18] = plane{  < 0.0000000, 0.9781476, -0.2079117 >, 0 translate < -4.9998, -7.7254, 36.3453 > }
  #local F[  19] = plane{  < 0.0000000, -0.6691306, -0.7431448 >, 0 translate < -4.9998, -9.3405, 28.7470 > }
  #local F[  20] = plane{  < -0.0000000, 1.0000000, 0.0000000 >, 0 translate < -4.9998, -15.1132, 33.9448 > }
  #local F[  21] = plane{  < 0.0000000, 0.8660254, -0.5000000 >, 0 translate < 4.9998, 15.1132, 26.1769 > }
  #local F[  22] = plane{  < -0.0000000, -0.8660254, -0.5000000 >, 0 translate < 4.9998, -50.0000, 86.6025 > }
  #local F[  23] = plane{  < 1.0000000, 0.0000000, 0.0000000 >, 0 translate < 4.9998, 15.1132, 26.1769 > }
  #local F[  24] = plane{  < -1.0000000, 0.0000000, 0.0000000 >, 0 translate < -4.9998, -15.1132, 26.1769 > }
  F
#end

