import java.awt.*;

// importa a classe de Layout personalizado
import InterfaceLayout;

// Classe: CanvasBotaoZoomOut
// Autor: Fbio Dalla Vecchia - RA:981091
// Canvas que controla o Botao Zoom OUT
class CanvasBotaoZoomOut extends Canvas {
    private int largura;
    private int altura;
    private Image img[] = new Image[2];
    private int Estado = 0;
    
    // acessveis ao Applet
    protected boolean BotaoPressionado = false;
    protected String msg = "Clique para Zoom Out no Mapa";
    protected boolean msgStatus=false;

    // Construtor
    public CanvasBotaoZoomOut( int larg,int alt, Image imagem[]) {
        largura = larg;
        altura = alt;
        img[0] = imagem[0];
        img[1] = imagem[1];

        reshape( 0,0,larg,alt );
        }

    // Mouse foi pressionado
    public boolean mouseDown( Event evt,int x,int y ) {
        BotaoPressionado = true;
        repaint();
        return( true );
        }

    // Boto do mouse foi solto
    public boolean mouseUp( Event evt,int x,int y ) {
        BotaoPressionado = false; // by fdv
        repaint();
        return( true );
        }
                         
    // Quando mouse passa sobre controle, exibimos uma mensagem
    // na linha de estado inferior da tela
    public boolean mouseEnter( Event evt,int x,int y ) {
        //showStatus( "Clique para Zoom Out no Mapa" );
        msgStatus=true;
        repaint();
        return( true );
        }

    // Limpa linha de status quando mouse sai do controle
    public boolean mouseExit( Event evt,int x,int y ) {
        BotaoPressionado = false; 
        //showStatus( "" );
        msgStatus=false;
        repaint();
        return( true );
        }

    public void update( Graphics g ) {
        // Muda estado do controle (pressionado ou no)
        if( !BotaoPressionado )
            Estado = 0;
        else 
            Estado = 1;
        paint( g );
        }

    public void paint( Graphics g ) {
        g.drawImage( img[Estado],0,0,this );
        }
    } 