#! /bin/bash 

TAG="$1"; shift
NS="$1"; shift
NR="$1"; shift
NB="$1"; shift
SUBD="$1"; shift
SHOW="$1"; shift # YES or NO

QUICK=0
if [[ ${QUICK} -ne 0 ]]; then
  WIDTH=360
  HEIGHT=480
  NRAYS=1
else
  WIDTH=600
  HEIGHT=800
  NRAYS=2
fi

NS5="`printf '%05d' ${NS}`"
NR5="`printf '%05d' ${NR}`"
NB5="`printf '%05d' ${NB}`"
OBJ_PREF="${TAG}_ns${NS5}_nr${NR5}_nb${NB5}_${SUBD}"
INC_FILE="out/${OBJ_PREF}.inc"
IMG_FILE="out/${OBJ_PREF}.png"

printf "run_keg_povray.sh:\n" 1>&2
printf "  TAG=${TAG}\n" 1>&2
printf "  NS=${NS}\n" 1>&2
printf "  NR=${NR}\n" 1>&2
printf "  NB=${NB}\n" 1>&2
printf "  SUBD = ${SUBD}\n" 1>&2
printf "  QUICK = ${QUICK}\n" 1>&2
printf "  WIDTH = ${WIDTH}\n" 1>&2
printf "  HEIGHT = ${HEIGHT}\n" 1>&2
printf "  NRAYS = ${NRAYS}\n" 1>&2
printf "  INC_FILE = ${INC_FILE}\n" 1>&2
printf "  IMG_FILE = ${IMG_FILE}\n" 1>&2

# Should filter error messages (0 or 1):
FILTER=1

# Directories where POV-Ray is installed:
POVRAY=/usr/bin/povray
POVINC=( +L.. )

# Main input files:
POV_FILE=slicing_keg_main.pov

# Command to display resultin image:
IMVIEW=( display -title '%f' )

rm -f ${IMG_FILE} params.inc
echo "#declare inc_file = \"${INC_FILE}\"" >> out/params.inc

${POVRAY} \
    +K0.5000 \
    +FN +Q9 \
    +W${WIDTH} +H${HEIGHT} \
    +AM1 +A0.0 +R${NRAYS} \
    +D \
    ${POV_INC[@]} \
    +I${POV_FILE} \
    +O${IMG_FILE} \
  2>&1 \
  | povray-output-filter.gawk -v do_filter=${FILTER}

if [[ "/${SHOW}" == "/YES" ]]; then
  if [[ -s ${IMG_FILE} ]]; then
    ${IMVIEW[@]} ${IMG_FILE}
  fi
fi
