#include <cdt2d/iterator.hpp>

#include "cdt2d/cairo-helpers.hpp"

namespace cdt{

void surface_to_mat(cairo_surface_t* surface, cv::Mat& dst)
{
	int w = cairo_image_surface_get_width(surface);
	int h = cairo_image_surface_get_height(surface);
	int stride = cairo_image_surface_get_stride(surface);
	unsigned char* data = cairo_image_surface_get_data(surface);

	int format = cairo_image_surface_get_format(surface);

	if(format != CAIRO_FORMAT_A1){
		throw std::runtime_error(
			"function surface_to_mat is not implemented "
			"for this cairo format"
		);
	}

	dst.create(cv::Size{w, h}, CV_8UC1);

	for(int i=0; i<h; i++){
		auto dst_ptr = dst.ptr<uchar>(i);
		auto line_begin = data + i*stride;
		for(int j=0; j<w; j++){

			int32_t value = *(line_begin + j/CHAR_BIT);
			value >>= (j%CHAR_BIT);

			if(value&1)
				*dst_ptr = 255;
			else
				*dst_ptr = 0;

			dst_ptr++;
		}
	}
}

template<class input_iterator>
void draw(cairo_t* cr, input_iterator begin, input_iterator end)
{
	if(begin != end)
		cairo_move_to(cr, begin->x(), begin->y());

	std::for_each(std::next(begin), end,
	[cr](auto const& v){
		cairo_line_to(cr, v.x(), v.y());
	});

	cairo_close_path(cr);
}

void draw(cairo_t* cr, polygon2d const& polygon)
{

	draw(
		cr,
		polygon.outer_boundary().vertices_begin(),
		polygon.outer_boundary().vertices_end()
	);

	for(auto const& hole : holes(polygon))
		draw(cr, hole.vertices_begin(), hole.vertices_end());
}

}
