#ifndef BEZIERRESTRICTION_H_
#define BEZIERRESTRICTION_H_

#include "../dataStruct/HyperIndex.h"
#include "../dataType/Matrix.h"


/*
 * Restriction over the Bezier coefficients in the form
 * 
 *  summation_(for n blocks)  summation (coefs_0[i] * { hi_0[i),rc_0[i] } ) = 0   
 */

class BezierRestriction
{
	
	/*
	 * Number of blocks
	 */
	 int nblocks;
	
	
	/*
	 * Blocks
	 */
	int* blockId;
	
	
	/*
	 * Number of indices for each block
	 */
	int* size;
	
	
	
	/*
	 * Indices on each block
	 */	
	HyperIndex* **hi;
	
	
	
	/*
	 * Range coordinate
	 * (one for each element of hi)
	 */
	int** rc;
	
	
	
	/*
	 * 1D Matrices with the coefficients of the restriction
	 */
	Matrix** coefs;
	
	
	
	
public:
	BezierRestriction();
	virtual ~BezierRestriction();
};

#endif /*BEZIERRESTRICTION_H_*/
