/** @file cdt2d.hpp
  * Header for the operations on the delta-clipped distance representation
  */

#pragma once
#include <cdt2d/polygon2d.hpp>
#include <cdt2d/ruler.hpp>

#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>

namespace cdt{

using delta_type	= double;
using k_type		= double;
using margin_type	= uint64_t;

/**
  * Converts polygon to binary representation. More specifically, draws the
  * polygon in the image `binary`.
  *
  * @param polygon	polygon representation to be converted in binary
  * @param binary	output image to hold the binary representation of
  *			`polygon`
  * @param resolution	resolution in pixel per centimeter
  * @param margin	the margin to consider around the object in pixels
  *
  * @see polygon
  */
void polygon_to_binary(
	polygon2d const& polygon,
	cv::Mat& binary,
	ruler::ppmm resolution,
	margin_type margin
);

/**
  * Convert binary representation to cdt2d. Considering the `m` parameter of
  * the cdt2d is 255
  *
  * @param binary	input representation to be converted do cdt2d
  * @param cdt2d	output image to output the image
  * @param resolution	resolution in pixel per centimeter
  * @param k		integer that represents the amount that the binary
  *			image will be reduced
  * @param delta	delta parameter for the cdt
  * @param margin	margin m to draw the image, the total margin margin
  * 			to be considered is m + `delta`
  */
void binary_to_cdt2d(
	cv::Mat const& binary,
	cv::Mat& cdt2d,
	ruler::ppmm resolution,
	k_type k,
	delta_type delta,
	margin_type margin
);

}
