// POVRAY description of the DCC "abacus" logo, fancy colors
// Last edited on 2002-03-31 23:28:17 by stolfi

background{ color rgb <0.00, 0.03, 0.10> }

light_source {
  <-10.0000, +50.0000, -10.0000>
  color rgb <1.30, 1.30, 1.30>
} 

light_source {
  <50.0000, 10.0000, 10.0000>
  color rgb <0.50, 0.50, 0.50>
} 

light_source {
  <10.0000, 10.0000, 50.0000>
  color rgb <0.30, 0.30, 0.30>
} 

#declare topaz_color    = color rgb <1.00, 0.60, 0.25>;
#declare ruby_color     = color rgb <1.00, 0.00, 0.30>;
#declare sapphire_color = color rgb <0.30, 0.40, 1.00>;
#declare emerald_color  = color rgb <0.30, 0.97, 0.30>;
#declare panther_color  = color rgb <1.00, 0.75, 0.80>;
#declare ivory_color    = color rgb <1.00, 0.97, 0.95>;
#declare gold_color     = color rgb <1.00, 0.85, 0.10>;
#declare silver_color   = color rgb <0.95, 0.97, 1.00>;

#declare highlight_color = color rgb <1.00, 1.00, 1.00>;

#declare topaz_texture = 
    texture{
      pigment {color topaz_color filter 1.00}
      finish {diffuse 0.0 ambient 0.0}
    }
    texture{
      pigment {color highlight_color filter 0.70}
      finish {diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.1}
    }
#declare topaz_interior = interior{ ior 1.2 }

#declare ruby_texture = 
    texture{
      pigment {color ruby_color filter 1.00}
      finish {diffuse 0.0 ambient 0.0}
    }
    texture{
      pigment {color highlight_color filter 0.70}
      finish {diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.1}
    }
#declare ruby_interior = interior{ ior 1.2 }

#declare sapphire_texture = 
    texture{
      pigment {color sapphire_color filter 1.00}
      finish {diffuse 0.0 ambient 0.0}
    }
    texture{
      pigment {color highlight_color filter 0.70}
      finish {diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.1}
    }
#declare sapphire_interior = interior{ ior 1.2 }

#declare emerald_texture = 
    texture{
      pigment {color emerald_color filter 1.00}
      finish {diffuse 0.0 ambient 0.0}
    }
    texture{
      pigment {color highlight_color filter 0.70}
      finish {diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.1}
    }
#declare emerald_interior = interior{ ior 1.2 }

#declare panther_texture = 
    texture{
      pigment {color panther_color filter 1.00}
      finish {diffuse 0.0 ambient 0.0}
    }
    texture{
      pigment {color highlight_color filter 0.70}
      finish {diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.1}
    }
#declare panther_interior = interior{ ior 1.2 }

#declare ivory_texture = 
    texture{
      pigment {color ivory_color filter 0.00}
      finish {diffuse 0.95 ambient 0.05}
    }

#declare metal_finish =
  finish{
    metallic
    ambient 0.1
    diffuse 0.9
    specular 1 roughness 0.05
    brilliance 2
  }

#declare gold_texture = 
  texture{
    pigment{color gold_color}
    finish{metal_finish}
  }
  
#declare silver_texture = 
  texture{
    pigment{color silver_color}
    finish{metal_finish}
  }

#declare abacus_slider_width       = 1.20;
#declare abacus_slider_round_min_R = 0.30;
#declare abacus_slider_sin_t       = 0.7071067812;
#declare abacus_slider_cos_t       = 0.7071067812;
#declare abacus_slider_hole_R      = 0.32;

#declare abacus_width              = 2.0;
#declare abacus_height             = 1.8;
#declare abacus_frame_width        = 0.12;
#declare abacus_frame_thickness    = 0.30;
#declare abacus_stick_R            = 0.040;

#declare abacus_frame_texture = texture{gold_texture}
#declare abacus_stick_texture = texture{silver_texture} 
#declare abacus_slider_texture = texture{sapphire_texture}
#declare abacus_slider_interior = interior{sapphire_interior}

#include "dcc-abacus-special.inc"

object{abacus rotate <0,180,0>}

#declare baseHY = 0.10;
#declare baseY = - (2 * abacus_frame_thickness/2)
#declare baseR = 1.5;
#declare base_texture = texture{ivory_texture}

cylinder {
  <0.0, baseY-baseHY, 0.0>,
  <0.0, baseY+baseHY, 0.0>,
  baseR
  texture{base_texture}
}

#declare centerX = 0;
#declare centerY = baseY+baseHY
#declare centerZ = 0;

#declare camDX = 3.1;
#declare camDY = 7;
#declare camDZ = 4.2;

#declare skyX = 0;
#declare skyY = 1;
#declare skyZ = 0;

camera {
  location  <centerX, centerY, centerZ> + <camDX, camDY, camDZ>
  direction <-camDX, -camDY, -camDZ>
  right     <+3.1000, 00.0000, 00.0000>
  up        <00.0000, 00.0000, +3.1000>
  sky       <skyX, skyY, skyZ>
  look_at   <centerX, centerY, centerZ>
} 

