//   Partite with gold, with circular name and motto,
//   that can be used as background for the DCC abbacus.
//  
//  Assumes defined
//  
//    ring_i_texture = texture for inner part of ring
//    ring_o_texture = texture for outer part of ring
//
//    ring_i_ridge_texture = texture for inner  ridge
//    ring_m_ridge_texture = texture for middle ridge
//    ring_o_ridge_texture = texture for outer  ridge
//
//    ring_o_legend_texture
//    ring_i_legend_texture
//
//    ring_i_radius = ring inner  radius
//    ring_m_radius = ring middle radius
//    ring_o_radius = ring outer  radius
//
//    ring_ridge_radius = minor radius of ridges
//
//    ring_i_thickness = ring inner  thickness
//    ring_m_thickness = ring middle thickness
//    ring_o_thickness = ring outer  thickness
//    
//  Defines
//  
//    abacus_base = the ring

#include "dcc-ring-plain.inc"

#declare legend_font_file   = "tt-fonts/courbd.ttf"
#declare legend_font_depth  = 1.00;
#declare legend_font_height = 0.66;
#declare legend_font_width  = 0.55;
#declare legend_font_gap    = 0.20;

#declare ring_min_thickness = min(ring_i_thickness, ring_o_thickness)

#declare legend_radius = (ring_i_radius + ring_m_radius)/2;
#declare legend_width =  (2.0/3.0)*(ring_m_radius - ring_i_radius);
#declare legend_depth =  ring_i_thickness;
#declare legend_texture = texture{ ring_i_legend_texture }
#declare legend_text_up = "INSTITUTO DE COMPUTAO"
#declare legend_text_dn = "UNICAMP"
// #declare legend_text_up = "OOOOOOOOOOOOOOOOOOOOOOOOO"
// #declare legend_text_dn = "MMMMMMM"
#include "dcc-ring-legend.inc"
#declare dcc_ring_i_legend = 
  object{ dcc_ring_legend 
    translate < 0.00, 0.5*ring_min_thickness, 0.00 >
  }

#declare legend_radius = (ring_m_radius + ring_o_radius)/2;
#declare legend_width =  (2.0/3.0)*(ring_o_radius - ring_m_radius);
#declare legend_depth =  ring_i_thickness;
#declare legend_texture = texture{ ring_o_legend_texture }
#declare legend_text_up = "ARTE ENGENHARIA E CINCIA"
#declare legend_text_dn = "DA COMPUTAO"
// #declare legend_text_up = "OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
// #declare legend_text_dn = "X"
#include "dcc-ring-legend.inc"
#declare dcc_ring_o_legend = 
  object{ dcc_ring_legend 
    translate < 0.00, 0.5*ring_min_thickness, 0.00 >
  }

#declare abacus_base = 
  difference{
    object{ dcc_ring_plain }
    union{
      object{ dcc_ring_i_legend }
      object{ dcc_ring_o_legend }
    }
  }

//  #declare abacus_base = 
//    union{
//      object{ dcc_ring_i_legend }
//      object{ dcc_ring_o_legend }
//    }

//  #declare abacus_base = 
//    object{ dcc_ring_plain }

