//   Partite with gold, with circular name and motto,
//   that can be used as background for the DCC abbacus.
//  
//  Assumes defined
//  
//    ring_i_texture = texture for inner part of ring
//    ring_o_texture = texture for outer part of ring
//
//    ring_i_ridge_texture = texture for inner  ridge
//    ring_m_ridge_texture = texture for middle ridge
//    ring_o_ridge_texture = texture for outer  ridge
//
//    ring_o_legend_texture
//    ring_i_legend_texture
//
//    ring_i_radius = ring inner  radius
//    ring_m_radius = ring middle radius
//    ring_o_radius = ring outer  radius
//
//    ring_ridge_radius = minor radius of ridges
//
//    ring_i_thickness = ring inner  thickness
//    ring_m_thickness = ring middle thickness
//    ring_o_thickness = ring outer  thickness
//    
//  Defines
//  
//    abacus_base = the ring

#include "dcc-ring-plain.inc"

//  #declare legend_font_file   = "tt-fonts/courbd.ttf"
#declare legend_font_file   = "tt-fonts/cour.ttf"
#declare legend_font_depth  = 1.00;
#declare legend_font_height = 0.66;
#declare legend_font_width  = 0.55;
#declare legend_font_gap    = 0.20;

#declare ring_min_thickness =
  min(min(ring_i_thickness, ring_o_thickness), ring_m_thickness);
#declare ring_max_thickness =
  max(max(ring_i_thickness, ring_o_thickness), ring_m_thickness);

#declare ring_relief_thickness = ring_max_thickness - ring_min_thickness;

#declare legend_radius = (ring_i_radius + ring_m_radius)/2;
#declare legend_width =  0.60*(ring_m_radius - ring_i_radius);
#declare legend_depth =  ring_relief_thickness + ring_legend_relief;
#declare legend_texture = texture{ ring_i_legend_texture }
#declare legend_text_up = "INSTITUTO DE COMPUTAO"
#declare legend_text_dn = "UNICAMP"
#include "dcc-ring-legend.inc"
#declare dcc_ring_i_legend = 
  intersection{
    object{ dcc_ring_legend 
      translate < 0.00, ring_min_thickness, 0.00 >
    }
    object{ dcc_ring_plain translate <0, ring_legend_relief, 0> }
    texture{ ring_i_legend_texture }
  }

#declare legend_radius = (ring_m_radius + ring_o_radius)/2;
#declare legend_width =  0.55*(ring_o_radius - ring_m_radius);
#declare legend_depth =  ring_relief_thickness + ring_legend_relief;
#declare legend_texture = texture{ ring_o_legend_texture }
#declare legend_text_up = "ARTE ENGENHARIA E CINCIA"
#declare legend_text_dn = "DA COMPUTAO"
#include "dcc-ring-legend.inc"
#declare dcc_ring_o_legend = 
  intersection{
    object{ dcc_ring_legend 
      translate < 0.00, ring_min_thickness, 0.00 >
    }
    object{ dcc_ring_plain translate <0, ring_legend_relief, 0> }
    texture{ ring_o_legend_texture }
  }

#declare abacus_base = 
  difference{
    object{ dcc_ring_decorated }
    union{
      object{ dcc_ring_i_legend }
      object{ dcc_ring_o_legend }
    }
  }

//  #declare abacus_base = 
//    union{
//      object{ dcc_ring_i_legend }
//      object{ dcc_ring_o_legend }
//    }

//  #declare abacus_base = 
//    object{ dcc_ring_plain }

