//  Assumes defined
//  
//    ring_i_thickness = thickness of ring at inner edge
//    ring_m_thickness = thickness of ring at middle line
//    ring_o_thickness = thickness of ring at outer edge
//
//    ring_i_radius = inner  ring radius
//    ring_m_radius = middle ring radius
//    ring_o_radius = outer  ring radius
//    ring_ridge_radius = radius of ridges
//    
//    ring_o_texture
//    ring_i_texture
//
//    ring_o_ridge_texture
//    ring_m_ridge_texture
//    ring_i_ridge_texture
//

//  Defines
//  
//    dcc_ring_plain = the ring, without ridges nor legends
//    dcc_ring_decorated = the ring, with ridges but without legends

#declare ring_width = ring_o_radius - ring_i_radius;
  
#if (ring_i_thickness = ring_m_thickness)
  // Flat
  #declare rg_i = 
    cylinder{ 
      < 0.0, 0.0, 0.0 >,
      < 0.0, ring_i_thickness, 0.0 >, 
      ring_m_radius
    }
#else
  #if (ring_i_thickness < ring_m_thickness)
    // Sunken
    #declare rg_i =
      difference{
        cylinder{ 
          < 0.0, 0.0, 0.0 >,
          < 0.0, ring_m_thickness, 0.0 >, 
          ring_m_radius
        }
        cone{
          < 0.0, ring_m_thickness + 0.001, 0.0 >, ring_m_radius,
          < 0.0, ring_i_thickness, 0.0 >, ring_i_radius
        }
      }
  #else
    // Tapered
    #declare rg_i =
      merge{
        cylinder{ 
          < 0.0, 0.0, 0.0 >,
          < 0.0, ring_m_thickness, 0.0 >, 
          ring_m_radius
        }
        cone{
          < 0.0, ring_m_thickness - 0.001, 0.0 >, ring_m_radius,
          < 0.0, ring_i_thickness, 0.0 >, ring_i_radius
        }
      }
  #end
#end

#if (ring_o_thickness = ring_m_thickness)
  // Flat
  #declare rg_o = 
    cylinder{ 
      < 0.0, 0.0, 0.0 >,
      < 0.0, ring_m_thickness, 0.0 >, 
      ring_o_radius
    }
#else
  # if (ring_o_thickness < ring_m_thickness)
    // Tapered
    #declare rg_o =
      merge{
        cylinder{ 
          < 0.0, 0.0, 0.0 >,
          < 0.0, ring_o_thickness, 0.0 >, 
          ring_o_radius
        }
        cone{
          < 0.0, ring_o_thickness - 0.001, 0.0 >, ring_o_radius,
          < 0.0, ring_m_thickness, 0.0 >, ring_m_radius
        }
      }
  #else
    // Sunken
    #declare rg_o =
      difference{
        cylinder{ 
          < 0.0, 0.0, 0.0 >,
          < 0.0, ring_o_thickness, 0.0 >, 
          ring_o_radius
        }
        cone{
          < 0.0, ring_o_thickness + 0.001, 0.0 >, ring_o_radius,
          < 0.0, ring_m_thickness, 0.0 >, ring_m_radius
        }
      }
  #end
#end

#declare dcc_ring_plain =
  union{
    difference{
      object{ rg_i }
      cylinder{ 
        < 00.00, -0.01, 00.00 >,
        < 00.00, ring_m_thickness + 0.01, 00.00 >,
        ring_i_radius
      }
      texture{ ring_i_texture }
    }
    difference{
      object{ rg_o }
      cylinder{ 
        < 00.00, -0.01, 00.00 >,
        < 00.00, ring_m_thickness + 0.01, 00.00 >,
        ring_m_radius
      }
      texture{ ring_o_texture }
    }
  }
      
#declare dcc_ring_decorated =
  union{
    object{ dcc_ring_plain }
    torus{ 
      ring_o_radius - ring_ridge_radius, ring_ridge_radius
      translate < 0, ring_o_thickness, 0 >
      texture{ ring_o_ridge_texture }
    }
    torus{ 
      ring_m_radius, ring_ridge_radius
      translate < 0, ring_m_thickness, 0 >
      texture{ ring_m_ridge_texture }
    }
    torus{ 
      ring_i_radius + ring_ridge_radius, ring_ridge_radius 
      translate < 0, ring_i_thickness, 0 >
      texture{ ring_i_ridge_texture }
    }
  }
      
    

