//  The bipartite ring, untextured, without ridges nor legends.
//
//  Assumes defined
//  
//    ring_i_thickness = thickness of ring at inner edge
//    ring_m_thickness = thickness of ring at middle line
//    ring_o_thickness = thickness of ring at outer edge
//
//    ring_i_radius = inner  ring radius
//    ring_m_radius = middle ring radius
//    ring_o_radius = outer  ring radius
//    
//  Defines
//  
//    dcc_ring_plain_i = the inner ring, without ridges nor legends
//    dcc_ring_plain_o = the outer ring, without ridges nor legends
//    dcc_ring_plain = the composite ring, without ridges nor legends

#declare ring_width = ring_o_radius - ring_i_radius;
  
#if (ring_i_thickness = ring_m_thickness)
  // Flat
  #declare rg_i = 
    cylinder{ 
      < 0.0, 0.0, 0.0 >,
      < 0.0, ring_i_thickness, 0.0 >, 
      ring_m_radius
    }
#else
  #if (ring_i_thickness < ring_m_thickness)
    // Sunken
    #declare rg_i =
      difference{
        cylinder{ 
          < 0.0, 0.0, 0.0 >,
          < 0.0, ring_m_thickness, 0.0 >, 
          ring_m_radius
        }
        cone{
          < 0.0, ring_m_thickness + 0.001, 0.0 >, ring_m_radius,
          < 0.0, ring_i_thickness, 0.0 >, ring_i_radius
        }
      }
  #else
    // Tapered
    #declare rg_i =
      merge{
        cylinder{ 
          < 0.0, 0.0, 0.0 >,
          < 0.0, ring_m_thickness, 0.0 >, 
          ring_m_radius
        }
        cone{
          < 0.0, ring_m_thickness - 0.001, 0.0 >, ring_m_radius,
          < 0.0, ring_i_thickness, 0.0 >, ring_i_radius
        }
      }
  #end
#end

#declare dcc_ring_plain_i =
  difference{
    object{ rg_i }
    cylinder{ 
      < 00.00, -0.01, 00.00 >,
      < 00.00, ring_m_thickness + 0.01, 00.00 >,
      ring_i_radius
    }
  }

#if (ring_o_thickness = ring_m_thickness)
  // Flat
  #declare rg_o = 
    cylinder{ 
      < 0.0, 0.0, 0.0 >,
      < 0.0, ring_m_thickness, 0.0 >, 
      ring_o_radius
    }
#else
  # if (ring_o_thickness < ring_m_thickness)
    // Tapered
    #declare rg_o =
      merge{
        cylinder{ 
          < 0.0, 0.0, 0.0 >,
          < 0.0, ring_o_thickness, 0.0 >, 
          ring_o_radius
        }
        cone{
          < 0.0, ring_o_thickness - 0.001, 0.0 >, ring_o_radius,
          < 0.0, ring_m_thickness, 0.0 >, ring_m_radius
        }
      }
  #else
    // Sunken
    #declare rg_o =
      difference{
        cylinder{ 
          < 0.0, 0.0, 0.0 >,
          < 0.0, ring_o_thickness, 0.0 >, 
          ring_o_radius
        }
        cone{
          < 0.0, ring_o_thickness + 0.001, 0.0 >, ring_o_radius,
          < 0.0, ring_m_thickness, 0.0 >, ring_m_radius
        }
      }
  #end
#end

#declare dcc_ring_plain_o =
  difference{
    object{ rg_o }
    cylinder{ 
      < 00.00, -0.01, 00.00 >,
      < 00.00, ring_m_thickness + 0.01, 00.00 >,
      ring_m_radius
    }
  }

#declare dcc_ring_plain =
  union{
    object{ dcc_ring_plain_i }
    object{ dcc_ring_plain_o }
  }
      
