// Photometric and texture test balls, for the ring base

#declare s = (ring_o_radius + ring_i_radius)/2/0.85
#declare w = (ring_o_radius - ring_i_radius)/2/0.35

#declare test_gizmo =
  union{
    sphere{ <0,0,0>, w*0.35 }
    cylinder{ w*<0,-0.07,0>, w*<0,+0.07,0>, w*0.50 }
  }

#declare test_balls_ring =
  union{
    object{ test_gizmo 
      translate s*<-0.85,0,0>
      pigment{ color rgb <1,1,1> } 
      finish{ ambient 0.0 diffuse 1.0 }
    }
    object{ test_gizmo 
      translate s*<+0.85,0,0>
      pigment{ color rgb 0.50*<1,1,1> } 
      finish{ ambient 0.0 diffuse 1.0 }
    }
    object{ test_gizmo 
      translate s*<-0.45,0,+0.8>
      texture{ ring_i_texture }
    }
    object{ test_gizmo 
      translate s*<+0.45,0,+0.8>
      texture{ ring_o_texture }
    }
    object{ test_gizmo 
      translate s*<-0.45,0,-0.8>
      texture{ ring_i_legend_texture }
    }
    object{ test_gizmo 
      translate s*<+0.45,0,-0.8>
      texture{ ring_o_legend_texture }
    }
  }

