// POVRAY description of the DCC "abacus" logo, luxury version

light_source {
  <-10.0000, +50.0000, -10.0000>
  color rgb <1.00, 1.00, 1.00>
} 

light_source {
  <50.0000, 10.0000, 10.0000>
  color rgb <0.50, 0.50, 0.50>
} 

light_source {
  <10.0000, 10.0000, 50.0000>
  color rgb <0.30, 0.30, 0.30>
} 

// background{ color rgb <0.90, 1.00, 0.92> }
// background{ color rgb <1.00, 1.00, 1.00> }
#include "background.inc"

#declare highlight_color = color rgb <1.00, 1.00, 1.00>;

#include "textures/metals.inc"
#include "textures/gems.inc"
#include "dcc-marbles.inc"

#declare abacus_frame_texture = texture{texture_gold}
#declare abacus_stick_texture = texture{texture_silver} 
#declare abacus_unit_slider_texture = texture{texture_sapphire}
#declare abacus_unit_slider_interior = interior{ior 1.2}
#declare abacus_five_slider_texture = texture{texture_ruby}
#declare abacus_five_slider_interior = interior{ior 1.2}

#include "dcc-std-abacus.inc"

#declare abacus_Y_shift = + abacus_frame_thickness/2
#declare abacus_slider_Y_shift = +abacus_slider_width/2

#declare abacus_extra_slider =
  object{abacus_slider
    translate <0.0, +abacus_slider_width/2, 0.0>
    scale <0.20, 0.20, 0.20>
  }

union{
  object{abacus
    translate <0.00, abacus_Y_shift, 0.05>
  }

  object{abacus_extra_slider 
    translate <-0.45, 0.00, -(abacus_height/2 + abacus_frame_width + 0.20)>
    texture{texture_topaz} interior{interior_topaz}
  }
  object{abacus_extra_slider 
    translate <00.00, 0.00, -(abacus_height/2 + abacus_frame_width + 0.20)>
    texture{texture_emerald} interior{interior_emerald}
  }
  object{abacus_extra_slider 
    translate <+0.45, 0.00, -(abacus_height/2 + abacus_frame_width + 0.20)>
    texture{texture_ruby} interior{interior_ruby}
  }

  sphere{
    <0,0,0>, 0.25
    translate <-(abacus_width/2 + 0.25), 0.25, 0>
    texture{texture_gold}
  }
  sphere{
    <0,0,0>, 0.25
    translate <+(abacus_width/2 + 0.25), 0.25, 0>
    texture{texture_silver}
  }
  rotate <0,180,0>
}

#declare base_texture = texture{texture_marble_pink}

#declare base_disk_radius = 1.5;
#declare base_disk_thickness = 0.15;
#include "dcc-base-disk.inc"

#declare centerX = 0;
#declare centerY = 0;
#declare centerZ = 0;

#declare camDX = 3.1;
#declare camDY = 7;
#declare camDZ = 4.2;

#declare skyX = 0;
#declare skyY = 1;
#declare skyZ = 0;

camera {
  location  <centerX, centerY, centerZ> + <camDX, camDY, camDZ>
  sky       <skyX, skyY, skyZ>
  direction <-camDX, -camDY, -camDZ>
  right     <+3.1000, 00.0000, 00.0000>
  up        <00.0000, 00.0000, +3.1000>
  look_at   <centerX, centerY, centerZ>
} 

