## <f0.W> {}
# Last edited on 1998-12-12 14:22:43 by stolfi
#
# LINE BREAKING AND OTHER TRANSCRIPTION BUGS IN INTERLN.EVT
# by Jorge Stolfi
#
# The following is a cumulative list of various transcription bugs
# that were fixed by hand in the INTERLN.EVT file, after conversion to
# the EVA encoding.
#
# These bug fixes affected mostly line breaking and formatting.
# The main exception is a large number of "IIIR"s in some
# transcriptions, which should have been "O"s.  Presumably they
# were caused by a coding table error somewhere.
#
# Omitted from this list are hundreds of replacements of "." by "-"
# where the text was interrupted by figures, and several dozen
# replacements of "-" by "=" (or vice-versa).
#
# The locators given here assume that the "[|]" groups were
# unfolded as explained in section <f0.U>.
#
# <f1r.17;C>      replaced "IIIR" by "O".
# <f1r.18;C>      deleted "." at end of line.
#
# <f3v.4;C>       replaced "IIIR" by "O".
# <f3v.13;C>      replaced "IIIR" by "O".
#
# <f6v.4;C>       replaced "IIIR" by "O".
# <f6v.4;D>       replaced "IIIR" by "O".
#
# <f8r.10;F>      added "K" at end of line.
# <f8r.11;F>      deleted "K." at beginning of line.
# <f8r.13;F>      added "K" at end of line.
# <f8r.14;F>      deleted "K." at beginning of line.
# <f8r.17;F>      deleted whole line.
# <f8r.18;F>      added "ODAR." at beginning of line.
#
# <f9r.3;F>       added "AK" at end of line.
# <f9r.4;F>       deleted "AK." at beginning of line.
#
# <f11v.4;F>      added "OL" at end of line.
# <f11v.5;F>      deleted "OL." from beginning of line.
# <f11v.5;F>      added "K" at end of line.
# <f11v.6;F>      deleted "K." from beginning of line.
#
# <f13r.1;F>      added "K" at end of line.
# <f13r.2;F>      deleted "K." at beginning of line.
#
# <f13v.4;F>      added "DZG" at end of line.
# <f13v.5;F>      deleted "DZG." from beginning of line.
#
# <f14r.2;C>      replaced "IIIL" by "O".
# <f14r.12;F>     added "K" at end of line.
# <f14r.13;F>     deleted "K" at beginning of line.
#
#
# <f15r.9;F>      deleted ".G" at end of line.
# <f15r.10;F>     added "G" at beginning of line.
#
# <f15v.7;F>      added "2" at end of line.
# <f15v.8;F>      deleted "2." at beginning of line.
#
# <f17r.9;C>      replaced "IIIR" by "O".
#
# <f17v.16;F>     added "K" at end of line.
# <f17v.17;F>     deleted "K." at beginning of line.
#
# <f18r.2;F>      added "IIIL" at end of line.
# <f18r.3;F>      deleted "IIIL." at beginning of line.
# <f18r.3;F>      added "K" at end of line.
# <f18r.4;F>      deleted "K." at beginning of line.
#
# <f18v.4;F>      added "R" at end of line.
# <f18v.5;F>      deleted "R." from beginning of line.
#
# <f19v.6;C>      replaced by "!!!!!!...!!!".
# <f19v.6;F>      truncated after "TOHZG.2".
# <f19v.6a;C>     new line, same as old <f19v.6;C>.
# <f19v.6a;F>     new line, with the part of old <f19v.6;F> after "TOHZG.2".
#
# <f20v.10;F>     deleted "*." at beginning of line.
#
# <f23r.7;F>      added "K" at end of line.
# <f23r.8;F>      deleted "K." at beginning of line.
#
# <f24r.4;F>      added "A" at end of line.
# <f24r.5;F>      deleted "A." at beginning of line.
#
# <f24v.4;F>      deleted "G." at beginning of line.
# <f24v.4;F>      deleted ".OCOR" at end of line.
# <f24v.5;F>      added "OCOR." at beginning of line.
#
# <f25r.3;F>      added "N" at end of line.
# <f25r.4;F>      deleted "N." at beginning of line.
#
# <f26r.2;F>      added "R" at end of line.
# <f26r.3;F>      deleted "R." at beginning of line.
#
# <f26r.8;C>      replaced "IIIL" by "O".
#
# <f27r.9;F>      added "K" at end of line.
# <f27r.10;F>     deleted "K." at beginning of line.
#
# <f27v.4;F>      bogus "=" in middle of line; replaced by ".".
# <f27v.5;C>      replaced by "!!!!!...!!!!!".
# <f27v.5;F>      truncated after "HZO.8OE".
# <f27v.6;C>      added old <f27v.5;C> at beginning of line.
# <f27v.6;F>      added the truncated part of old <f27v.5;F> at beginning of line.
#
# <f28v.1;C>      replaced "PZ" by "IIIL" (twice).
#
# <f29v.1;C>      replaced "IIIL" by "T".
# <f29v.4;F>      deleted "-" between words 7 and 8.
# <f29v.7;C>      deleted extra "-" between words 5 and 6.
# <f29v.7;F>      deleted "--" between words 5 and 6.
# <f29v.10;F>     inserted "-" in word 4 between "HZ" and "TG8".
# <f29v.12;C>     replaced "IIIL" by "T".
#
# <f30r.3;F>      added "IK" at end of line.
# <f30r.4;F>      deleted "IK." from beginning of line.
# <f30r.12;F>     added "M" at end of line.
# <f30r.13;F>     deleted "M." at beginning of line.
#
# <f30v.7;C>      replaced "IIIR" by "O".
#
# <f31r.15;F>     added "R" at end of line.
# <f31r.16;F>     deleted "R." at beginning of line.
#
# <f31v.2;F>      deleted starting from "GDCCO"
# <f31v.3;F>      created from parts of lines 2 and 4.
# <f31v.4;F>      deleted up to "EDC8G".
# <f31v.4;F>      added "K" at end of line.
# <f31v.5;F>      deleted "K." at beginning of line.
#
# <f32r.2;F>      added "F" at end of line.
# <f32r.3;F>      deleted "F." at beginning of line.
#
# <f32v.11;C>     replaced "IIIL" by "T".
#
# <f33r.5;C>      replaced "IIR" by "O".
#
# <f33v.1;F>      added ".C2" at end of line.
# <f33v.2;F>      deleted "C2." from beginning of line.
# <f33v.4;F>      added "M" at end of line.
# <f33v.5;F>      deleted "M." at beginning of line.
# <f33v.9;C>      replaced ".-" by "-".
# <f33v.9;F>      replaced ".-" by "-".
#
# <f34r.7;F>      moved "IIR.AKK." to end of line.
# <f34r.9;F>      "TZH" replaced by "THZ" (from ";C>" version).
#
# <f34r.4;C>      deleted right half after plant.
# <f34r.4;C>      appended right half of <f34r.5;C>.
# <f34r.4;F>      deleted right half after plant.
# <f34r.4;F>      appended right half of <f34r.5;F>.
# <f34r.5;C>      deleted right half after plant.
# <f34r.5;C>      appended right half of <f34r.6;C>.
# <f34r.5;F>      deleted right half after plant.
# <f34r.5;F>      appended right half of <f34r.6;F>.
# <f34r.6;C>      deleted right half after plant.
# <f34r.6;C>      appended right half of <f34r.7;C>.
# <f34r.6;F>      deleted right half after plant.
# <f34r.6;F>      appended right half of <f34r.7;F>.
# <f34r.7;C>      deleted right half after plant.
# <f34r.7;C>      appended right half of <f34r.8;C>.
# <f34r.7;F>      deleted right half after plant.
# <f34r.7;F>      appended right half of <f34r.8;F>.
# <f34r.8;C>      deleted right half after plant.
# <f34r.8;C>      appended right half of <f34r.9;C>.
# <f34r.8;F>      deleted right half after plant.
# <f34r.8;F>      appended right half of <f34r.9;F>.
# <f34r.9;C>      deleted right half after plant.
# <f34r.9;C>      appended <f34r.10;C>.
# <f34r.9;F>      deleted right half after plant.
# <f34r.9;F>      appended <f34r.10;F>.
# <f34r.10;C>     deleted line.
# <f34r.10;F>     deleted line.
#
# <f34v.6;F>      deleted ".OET8AM" at end of line.
# <f34v.7;F>      added "OET8AM." at beginning of line.
#
# <f35r.10;C>     replaced "IIIL" by "T".
# <f36r.4;C>      replaced "IIR" by "K".
#
# <f36v.7;C>      replaced "IIIR" by "O".
#
# <f37r.10;F>     added "IIR" at end of line.
# <f37r.11;F>     deleted "IIR." at beginning of line.
# <f37r.5;C>      replaced "IIIL" by "O".
# <f37r.6;C>      replaced "IIIL" by "O".
#
# <f37v.15;F>     added "N" at end of line.
# <f37v.16;F>     deleted "N." at beginning of line.
# <f37v.19;F>     truncated line after "4ODOIIIL.GDCCOE2".
# <f37v.19a;F>    created line with part of <f37v.19;F>.
# <f37v.19b;F>    created line with part of <f37v.19;F>.
# <f37v.19;C>     renumbered <f37v.19b;C>.
#
# <f39r.4;F>      added "K" at end of line.
# <f39r.5;F>      deleted "K." at beginning of line.
# <f39r.14;C>     replaced "IIR" by "O".
#
# <f39v.6;C>      replaced "IIIR" by "O".
# <f39v.10;F>     added "P" at end of line.
# <f39v.11;F>     deleted "P." at beginning of line.
# <f39v.12;F>     deleted from "8AN.ODZC8G.OHC8G." onwards.
# <f39v.12;C>     deleted from "8AN.ODZC8G.OHC8G." onwards.
# <f39v.P.13;F>   created from right half of <f39v.12;F>.
# <f39v.P.13;C>   created from right half of <f39v.12;C>.
#
# <f40r.8;F>      added "K" at end of line.
# <f40r.9;F>      deleted "K." from beginning of line.
#
# <f40v.7;F>      added "R" at end of line.
# <f40v.8;F>      deleted "R." at beginning of line.
#
# <f41r.8;G>      deleted line.
# <f41r.9;G>      added "4ODCC8G.ODC8G." at beginning of line, from <f41r.8;G>.
# <f41r.10;C>     replaced "IIIR" by ".".
#
# <f41v.3;C>      replaced "IIIR" by "O" (twice).
#
# <f42r.9;C>      renamed <f42r.P2.9a;C>.
# <f42r.9;F>      truncated line after "SOE.CHG.TARG".
# <f42r.9;G>      deleted, tail became <f42r.9a;G>.
# <f42r.9a;F>     created from tail of line <f42r.9;F>.
# <f42r.9a;G>     created from tail of line <f42r.9;G>.
# <f42r.14;F>     added "-{plant}8AIK" at end of line.
# <f42r.15;F>     deleted "8AIK=" at beginning of line.
#
# <f42v.4;F>      added "K" at end of line.
# <f42v.4;G>      added "K" at end of line.
# <f42v.5;F>      deleted "K." at beginning of line.
# <f42v.5;G>      deleted "K." at beginning of line.
# <f42v.5;C>      replaced "IIIL" by "T".
# <f42v.12;C>     replaced "IIIL" by "T".
#
# <f43r.4;G>      leading ".", deleted.
# <f43r.8;F>      replaced "-8.8SC8G" on by "8-".
# <f43r.8;G>      deleted from "-8.8SC8G" on.
# <f43r.9;C>      replaced by <f43v.1;C>.
# <f43r.9;F>      replaced by part of line 8 from "8SC8G" on.
# <f43r.10;C>     replaced "IIR" by "O".
# <f43r.12;C>     replaced "IIR" by "O".
# <f43r.12;F>     added "M" at end of line.
# <f43r.13;F>     deleted "M." at beginning of line.
# <f43r.13;G>     deleted "M." at beginning of line.
#
# <f43v.1;C>      replaced by <f43r.9;C>.
# <f43v.1;F>      added "G" at end of line.
# <f43v.1;G>      added "G" at end of line.
# <f43v.2;F>      deleted "G." at beginning of line.
# <f43v.3;C>      replaced "IIIL" by "O".
# <f43v.5;C>      replaced "IIIL" by "O".
#
# <f44v.5;F>      added "N" at end of line.
# <f44v.5;G>      added "N" at end of line.
# <f44v.6;F>      deleted "N." at beginning of line.
# <f44v.6;G>      deleted "N." at beginning of line.
# <f44v.10;C>     replaced "IIIR" by "*".
#
# <f45r.8;F>      added ".K" at end of line.
# <f45r.8;G>      added ".K" at end of line.
# <f45r.9;F>      deleted "K." at beginning of line.
# <f45r.9;G>      deleted "K." at beginning of line.
#
# <f45v.6;F>      added "K" at end of line.
# <f45v.6;G>      added "K" at end of line.
# <f45v.7;F>      deleted "K." at beginning of line.
#
# <f46r.3;C>      replaced "IIIL" by "O".
#
# <f46v.7;G>      duplicate ".", replaced by single ".".
# <f46v.7;C>      replaced "-ODCC8T2G....-" by "=".
# <f46v.7;G>      replaced "-ODCC8T2G....-" by "=".
# <f46v.7;F>      replaced "-ODCC8T2G....-" by "=".
# <f46v.7a;C>     created from deleted part of <f46v.7;C>
# <f46v.7a;G>     created from deleted part of <f46v.7;G>
# <f46v.7a;F>     created from deleted part of <f46v.7;F>
#
# <f47r.9;C>      replaced "IIIL" by "O".
#
# <f47v.9;F>      added "M" at end of line.
# <f47v.10;F>     deleted "M." at beginning of line.
# <f47v.10;G>     deleted "M." at beginning of line.
# <f47v.12;F>     duplicate ".", replaced by single ".".
# <f47v.12;G>     leading ".", deleted.
#
# <f48r.3;C>      replaced "IIIL" by "O".
#
# <f48v.7;F>      bogus "=" in middle of line; replaced by ".".
# <f48v.7;F>      added "G" at end of line.
# <f48v.8;F>      deleted "G." at beginning of line.
# <f48v.8;G>      deleted "G." at beginning of line.
# <f48v.10;C>     replaced "=" by "-" at end of line.
# <f48v.10;F>     deleted ".GDCC8AE.TDZG.....8ARG=" at end of line.
# <f48v.10;F>     added "-" at end of line.
# <f48v.10;G>     deleted ".GDCC8AE.*DZG.....8ARG=" at end of line.
# <f48v.10;G>     added "-" at end of line.
# <f48v.11;C>     created line with "!!!!...!!!!".
# <f48v.11;F>     created line with "GDCC8AE.TDZG.....8ARG=" from <f48v.10;F>.
# <f48v.11;G>     created line with "GDCC8AE.*DZG.....8ARG=" from <f48v.10;G>.
#
# <f49r.20;F>     added "M" at end of line.
# <f49r.21;F>     deleted "M." at beginning of line.
# <f49r.21;G>     deleted "M." at beginning of line.
#
# <f49v.16;F>     added "K" at end of line.
# <f49v.16;G>     added "K" at end of line.
# <f49v.17;F>     deleted "K." from beginning of line.
# <f49v.17;G>     deleted "K." from beginning of line.
# <f49v.19;F>     added "K" at end of line.
# <f49v.19;G>     added "K" at end of line.
# <f49v.20;F>     deleted "K." from beginning of line.
# <f49v.20;G>     deleted "K." from beginning of line.
# <f49v.23;F>     added ".R" at end of line.
# <f49v.23;G>     added ".R" at end of line.
# <f49v.24;F>     deleted "R." from beginning of line.
# <f49v.24;G>     deleted "R." from beginning of line.
#
# <f50r.2;F>      added "AR.ODAK" at end of line.
# <f50r.3;C>      replaced "IIIL" by "O".
# <f50r.3;F>      deleted "AR.ODAK." from beginning of line.
# <f50r.3;G>      deleted "AR.ODAK." from beginning of line.
#
# <f50r.2;C>      deleted ".OEAM.TCFT8G" from end of line (dupl above).
# <f50r.4;C>      replaced "IIIL" by "O".
# <f50r.4;F>      deleted ".2" from end of line.
# <f50r.4;G>      deleted ".2" from end of line.
# <f50r.5;F>      added "2" at beginning of line.
# <f50r.5;G>      added "2" at beginning of line.
# <f50r.7;C>      replaced "IIK" by "O".
# 
# <f51r.7;C>      renamed <f51r.P.7a;C>.
# <f51r.7;F>      truncated line after "8AM.GDAE8".
# <f51r.7;G>      deleted; part of it became <f51r.7a;G>.
# <f51r.7a;F>     created from second half of <f51r.7;F>.
# <f51r.7a;F>     added "E" at end of line.
# <f51r.7a;G>     created from second half of <f51r.7;G>.
# <f51r.7a;G>     added "E" at end of line.
# <f51r.8;F>      deleted "E." from beginning of line.
#
# <f51v.4;F>      added "K" at end of line.
# <f51v.4;F>      added "K" at end of line.
# <f51v.5;F>      deleted "K." from beginning of line.
#
# <f52r.7;F>      added "E" at end of line.
# <f52r.7;G>      added "E" at end of line.
# <f52r.8;F>      deleted "E." from beginning of line.
# <f52r.8;G>      deleted "E." from beginning of line.
#
# <f52v.5;F>      added "K" at end of line.
# <f52v.6;F>      deleted "K." at beginning of line.
#
# <f53v.2;F>      added "G" at end of line.
# <f53v.3;F>      deleted "G." at beginning of line.
#
# <f54r.6;F>      added "AR" at end of line.
# <f54r.7;F>      deleted "AR." at beginning of line.
#
# <f54v.8;C>      deleted bogus text after "ODAE.OK-".
# <f54v.8;F>      deleted "G-" at end of line.
# <f54v.9;F>      added "G" at beginning of line.
#
# <f55r.11;F>     added "M" at end of line.
# <f55r.12;F>     deleted "M." at beginning of line.
#
# <f55v.5;C>      replaced "IIIL" by "O".
# <f55v.11;F>     added "M" at end of line.
# <f55v.12;F>     deleted "M." at beginning of line.
#
# <f56v.4;F>      added "M" at end of line.
# <f56v.5;F>      deleted "M." at beginning of line.
# <f56v.12;F>     added "M" at end of line.
# <f56v.13;F>     deleted "M." at beginning of line.
#
# <f57r.7;F>      added "K" at end of line.
# <f57r.8;F>      deleted "K." at beginning of line.
#
# <f58r.7;F>      added ".OHTG" at end of line.
# <f58r.8;F>      deleted "OHTG." from beginning of line.
# <f58r.24;F>     deleted ".OAR" at end of line.
# <f58r.25;F>     added "OAR." at beginning of line.
# <f58r.32;F>     truncated after "4ODAE8G", moved to <f58r.32a;F>.
# <f58r.32a;F>    created from right 2/3 of <f58r.32;F>.
#
# <f66r.L.14;F>   bogus FSG "Z", replaced by "*".
#
# <f66r.3;C>      duplicate ".", replaced by single ".".
# <f66r.24;C>     replaced "IIIR" by "O".
#
# <f66r.W.1;C>    replaced "IIE" by "H" (twice).
# <f66r.W.1;C>    replaced "IR" by "T" (four times).
# <f66r.W.1;C>    replaced "IE" by "G" (twice).
#
# <f66v.7;F>      bogus FSG "J", replaced by "*".
#
# <f68r1.3;C>     added "ODCCG.RAR.CDZCAR.8ARA7-" at end of line.
# <f68r1.3;F>     added "ODCG.ROR.TDZAR.8ARAK-" at end of line.
# <f68r1.4;C>     deleted "ODCCG.RAR.CDZCAR.8ARA7-" from end of line.
# <f68r1.4;F>     deleted "ODCG.ROR.TDZAR.8ARAK-" from end of line.
#
# <f68r2.S18.1;R> added ".TOE" at end of line, from <f68r2.S19;R>.
# <f68r2.S18.1;V> added ".TOE" at end of line, from <f68r2.S19;V>.
#
# <f68r2.S19;R>   deleted, merged into <f68r2.S18.1;R>
# <f68r2.S19;V>   deleted, merged into <f68r2.S18.1;V>
#
# <f68v3.1;C>     duplicate line number, renumbered <f68v3.0;C>.
# <f68v3.1;F>     duplicate line number, renumbered <f68v3.0;F>.
# <f68v3.0;F>     deleted ".2SCG" from end of line.
# <f68v3.1;F>     added "2SCG." at beginning of line.
#
# <f68v2.C.1;C>   replaced by join of C.1 thru C.4, with new break at 10:30.
# <f68v2.C.1;D>   replaced by join of D.1 and C2 thru C.4, with new break at 10:30.
# <f68v2.C.1;C>   replaced "IIIR" by "O".
# <f68v2.C.1;D>   replaced "IIIR" by "O".
# <f68v2.C.2;C>   deleted line.
# <f68v2.C.3;C>   deleted line.
# <f68v2.C.4;C>   deleted line.
#
# <f68v2.R.12;C>  replaced "IIIR" by "O".
# <f68v2.R.4;C>   replaced "IIIR" by "O".
#
# <f70r2.4;F>     bogus FSG "Z", replaced by "*".
# <f70r2.9;F>     deleted "4ODAE.TOE...TCCG.ODAE-" from end of line.
# <f70r2.9a;F>    created line with "{crease}4ODAE.TOE...TCCG.ODAE-".
# <f70r2.10;F>    deleted "4ODAE.SDAE...4ODAE.T8G-" from end of line.
# <f70r2.10a;F>   created line "4ODAE.SDAE...4ODAE.T8G-".
# <f70r2.11;F>    deleted "ODAM.THZCG.2.OR.ARG=" frm end of line.
# <f70r2.11a;F>   created line with "ODAM.THZCG.2.OR.ARG=".
#
# <f75r.7;F>      added right half of <f75r.8;F>.
# <f75r.8;F>      replaced right half by right half of <f75r.9;F>.
# <f75r.9;F>      deleted right half.
#
# <f75v.28;C>     leading ".", deleted.
#
# <f76r.5;F>      added "R" at end of line.
#
# <f76r.L.6;F>    deleted "R." at beginning of line.
# <f76r.L.13;F>   deleted "IR." at beginning of line.
# <f76r.L.14;F>   added "O" label.
# <f76r.L.15;F>   deleted "O" label.
# <f76r.L.26;F>   deleted "R" label.
# <f76r.L.38;F>   deleted "M" label.
#
# <f76r.12;F>     added "IR" at end of line.
# <f76r.14;F>     added "8TC8G.4OETCG.4ODCFG" from line <f76r.15;F>.
# <f76r.15;F>     deleted "8TC8G.4OETCG.4ODCFG" from beginning of line.
# <f76r.25;F>     added "R" at end of line.
# <f76r.33;F>     added ".ETC8G.4OEAN....OHAEAK" at end of line.
# <f76r.34;F>     deleted "ETC8G.4OEAN....OHAEAK." at beginning of line.
# <f76r.37;F>     added "M" at end of line.
#
# <f77v.28;F>     added "M" at end of line.
# <f77v.29;F>     deleted "M." at beginning of line.
#
# <f78r.7;F>      deleted ".8AR.AEOFZG" at end of line.
# <f78r.11;F>     deleted ".8TC8AEG" at end of line.
# <f78r.24;F>     deleted ".OHARO8E.SG.ORORG" at end of line.
#
# <f78r.X.3;F>    created line with "8AR.AEOFZG=" from <f78r.7;F>.
# <f78r.X.4;F>    created line with "8TC8AEG=" from <f78r.11;F>.
# <f78r.X.5;F>    created line with "OHARO8E.SG.ORORG=" from <f78r.24;F>.
#
# <f78v.3;F>      added "K" at end of line.
# <f78v.4;F>      deleted "K." at beginning of line.
# <f78v.8;G>      replaced "IIIK" by "N".
# <f78v.8;F>      added "M" at end of line.
# <f78v.9;F>      deleted "M." at beginning of line.
# <f78v.12;F>     added "M" at end of line.
# <f78v.13;F>     deleted "M." at beginning of line.
# <f78v.15;F>     added "2" at end of line.
# <f78v.16;F>     deleted "2." at beginning of line.
# <f78v.19;F>     deleted bogus "-" near end of line.
#
# <f79r.9;F>      added "K" at end of line.
# <f79r.10;F>     deleted "K." at beginning of line.
# <f79r.14;F>     added ".TCCG.TCG.8AM.TC8G.4OE" at end of line.
# <f79r.15;F>     deleted "TCCG.TCG.8AM.TC8G.4OE." at beginning of line.
# <f79r.16;F>     added "K" at end of line.
# <f79r.17;F>     deleted "K." at beginning of line.
# <f79r.30;F>     deleted bogus "-" in "OEOL".
#
# <f79v.8;F>      added "E" at end of line.
# <f79v.9;F>      deleted "E" at beginning of line.
# <f79v.13;F>     added "K" at end of line.
# <f79v.14;F>     deleted "K." at beginning of line.
# <f79v.15;F>     added "M" at end of line.
# <f79v.16;F>     deleted "M." at beginning of line.
# <f79v.18;F>     deleted ".G" from linendof line.
# <f79v.19;F>     added "G" at beginning of line.
# <f79v.26;F>     added "*" at end of line.
# <f79v.27;F>     deleted "*." at beginning of line.
# <f79v.31;F>     added "M" at end of line.
# <f79v.32;F>     deleted "M." at beginning of line.
# <f79v.38;F>     added "K" at end of line.
# <f79v.39;F>     deleted ""m."" at beginning of line.
# <f79v.41;F>     added "M" at end of line.
# <f79v.42;F>     deleted "M." at beginning of line.
#
# <f80r.2;F>      added "2" at end of line.
# <f80r.3;F>      deleted "2." at beginning of line.
# <f80r.3;F>      added "K" at end of line.
# <f80r.4;F>      deleted "K." at beginning of line.
# <f80r.7;F>      added "K" at end of line.
# <f80r.8;F>      deleted "K." at beginning of line.
# <f80r.10;F>     added "K" at end of line.
# <f80r.11;F>     deleted "K." at beginning of line.
# <f80r.16;F>     deleted whole line.
# <f80r.17;F>     added "4OE." in front from pev line.
# <f80r.38;F>     added "K" at end of line.
# <f80r.39;F>     deleted "K." at beginning of line.
#
# <f80v.14;F>     added "R" at end of line.
# <f80v.15;F>     deleted "R." at beginning of line.
# <f80v.18;F>     deleted "-" near end of line.
# <f80v.21;F>     added "K" at end of line.
# <f80v.22;F>     deleted "K." at beginning of line.
# <f80v.33;F>     added "K" at end of line.
# <f80v.34;F>     deleted "K." at beginning of line.
# <f80v.31;F>     added "M" at end of line.
# <f80v.32;F>     deleted "M." at beginning of line.
#
# <f81r.5;F>      added "M" at end of line.
# <f81r.6;F>      deleted "M." at beginning of line.
# <f81r.7;F>      added "M" at end of line.
# <f81r.8;F>      deleted "M." at beginning of line.
#
# <f81v.4;F>      added "G" at end of line.
# <f81v.5;F>      deleted "G." at beginning of line.
#
# <f81v.5;F>      added ".DAR.8AM.ODAR" at end of line.
# <f81v.6;F>      deleted "DAR.8AM.ODAR." at beginning of line.
#
# <f81v.15;F>     added "!!!...!!!!" after ".TC8G.O"
# <f81v.15;F>     deleted ".4OR." at end of line.
# <f81v.16;F>     added "4OR." at beginning of line.
#
# <f82r.31;F>     added "M" at end of line.
# <f82r.32;F>     deleted "M." at beginning of line.
#
# <f82v.30;F>     added "M" at end of line.
# <f82v.31;F>     deleted "M." at beginning of line.
#
# <f83r.11;F>     added "O" at end of line.
# <f83r.12;F>     deleted "O." at beginning of line.
# <f83r.25;F>     added "E" at end of line.
# <f83r.26;F>     deleted "E." at beginning of line.
# <f83r.30;F>     added "M" at end of line.
# <f83r.31;F>     deleted "M." at beginning of line.
# <f83r.33;F>     added "M" at end of line.
# <f83r.34;F>     deleted "M." at beginning of line.
# <f83r.32;F>     split part to "SC8AE" as line <f83r.X.3;F>
# <f83r.33;F>     split part to "T8AEAM" as line <f83r.X.4;F>
# <f83r.34;F>     split part to "TC8G" as line <f83r.X.5;F>
# <f83r.41;C>     split part to "RAEG.OE" as line <f83r.Z.8;F>
# <f83r.41;F>     split part to "RAEG.OE" as line <f83r.Z.8;F>
# <f83r.42;C>     split part to "4OHAR.OE" as line <f83r.Z.9;F>
# <f83r.42;F>     split part to "4OHAR.OE" as line <f83r.Z.9;F>
# <f83r.43;C>     split part to "E8AEOR" as line <f83r.Z.10;F>
# <f83r.43;F>     split part to "E8AEOR" as line <f83r.Z.10;F>
# <f83r.44;C>     split part to "HZCIE" as line <f83r.Z.11;F>
# <f83r.44;F>     split part to "HZOE" as line <f83r.Z.11;F>
#
# <f83v.14;F>     deleted "4ODAN.TCCAE" (nothing left on the line).
# <f83v.15;F>     added "4ODAN.TCCAE." at beginning of line.
# <f83v.16;F>     deleted ".TC8G.4OE" at end of line.
# <f83v.17;F>     added "TC8G.4OE" at beginning of line.
# <f83v.20;F>     added "2" at end of line.
# <f83v.20;F>     deleted "ODT8G." at beginning of line, moved to <f83v.Y.8;F>.
# <f83v.21;F>     deleted "2." at beginning of line.
# <f83v.25;F>     added "2" at end of line.
# <f83v.26;F>     deleted "2." at beginning of line.
#
# <f83v.Y.8;F>    created with "ODT8G=" from <f83v.P.20;F>.
#
# <f84r.24;C>     deleted to "OROE.", moved to <f84r.Z.24;C>.
# <f84r.24;F>     deleted to "OROE.", moved to <f84r.Z.24;C>.
#
# <f84r.16;F>     added "M" at end of line.
# <f84r.17;F>     deleted "M." at beginning of line.
# <f84r.18;F>     deleted "OHAEG." at beginning of line.
# <f84r.30;F>     deleted up to first "SC8G.2AM.".
#
# <f84r.Y.13;F>   added "OHAEG=" from <f84r.18;F>.
#
# <f84v.12;F>     added "M" at end of line.
# <f84v.13;F>     deleted "M." at beginning of line.
# <f84v.21;F>     deleted "ODAR." at beginning of line.
# <f84v.22;F>     deleted "G8AIROE." at beginning of line.
# <f84v.23;F>     deleted "GTDZG." at beginning of line.
# <f84v.24;F>     deleted "8SC8G." at beginning of line.
# <f84v.31;F>     deleted "ODT8G." at beginning of line.
# <f84v.32;F>     deleted "2OETCG." at beginning of line.
# <f84v.33;F>     deleted "8AIROE8G." at beginning of line.
# <f84v.34;F>     deleted "8ORTG." at beginning of line.
# <f84v.35;F>     added "2" at end of line.
# <f84v.35;F>     deleted "4DZG." at beginning of line.
# <f84v.36;F>     deleted "OTC8G." at beginning of line.
# <f84v.36;F>     deleted "2." at beginning of line.
# <f84v.X.20;F>   created with "ODAR" from <f84v.21;F>.
# <f84v.X.21;F>   created with "G8AIROE" from <f84v.22;F>.
# <f84v.X.22;F>   created with "GTDZG" from <f84v.23;F>.
# <f84v.X.23;F>   created with "8SC8G" from <f84v.24;F>.
# <f84v.Y.30;F>   created with "ODT8G" from <f84v.31;F>.
# <f84v.Y.31;F>   created with "2OETCG" from <f84v.32;F>.
# <f84v.Y.32;F>   created with "8AIROE8G" from <f84v.33;F>.
# <f84v.Y.33;F>   created with "8ORTG" from <f84v.34;F>.
# <f84v.Y.34;F>   created with "4DZG" from <f84v.35;F>.
# <f84v.Y.35;F>   created with "OTC8G" from <f84v.36;F>.
#
# <f85r1.29;F>    split off after "4ODT8G." as separate line.
# <f85r1.29a;F>   created from second half of <f85r1.29;F>.
#
# <f86v4.4;F>     deleted ".8AR.OECCG.OEGG" at end of line.
# <f86v4.5;F>     created new line with "{centered -- "title"?}8AR.OECCG.OEGG=".
#
# <f86v6.22;F>    bogus FSG "X", replaced by "*".
#
# <f86v5.7;F>     deleted ".OHZAE" at end of line.
# <f86v5.8;F>     added "OHZAE." at beginning of line.
# <f86v5.9;F>     truncated line after "AE.GDAN".
# <f86v5.9a;F>    created line from right half of <f86v5.9;F>.
# <f86v5.18;F>    truncated line after "TCG.SDZG".
# <f86v5.18a;F>   created line from right half of <f86v5.18;F>.
# <f86v5.22;F>    deleted ".2AIR" at end of line.
# <f86v5.23;F>    added "2AIR." at beginning of line.
#
# <f86v3.4;F>     added "GDAM!!!...!!!!K" at beginning of line
# <f86v3.5;F>     deleted "GDAMK." from beginning of line.
#
# <f87v.3;F>      truncated from "GTCODZG.ODCG" onwards.
# <f87v.3a;F>     created from right half of <f87v.3;F>.
# <f87v.4;F>      truncated from "8TCO2.SCG" onwards.
# <f87v.4a;F>     created from right half of <f87v.4;F>.
# <f87v.6;F>      truncated from "HCTOE.4OSTCO8G" onwards.
# <f87v.6a;F>     created from right half of <f87v.6;F>.
#
# <f88r.b.3;L>    replaced "IIIR" by "O".
#
# <f88v.3;L>      replaced "IIIR" by "O".
# <f88v.4;L>      replaced "IIIR" by "O" (twice).
#
# <f88v.7;L>      replaced "IIIR" by "O".
# <f88v.8;L>      replaced "IIIR" by "O" (twice).
# <f88v.9;L>      replaced "IIIR" by "O".
# <f88v.14;L>     replaced "IIIR" by "O".
#
# <f89r1.1;L>     replaced "IIIR" by "O".
# <f89r1.2;L>     replaced "IIIR" by "O".
# <f89r1.3;L>     replaced "IIIR" by "O" (twice).
# <f89r1.4;L>     replaced "IIIR" by "O".
#
# <f89r1.8;L>     replaced "IIIR" by "O".
# <f89r1.9;L>     replaced "IIIR" by "O".
#
# <f89r1.9;F>     replaced ".2SCGR.4ODAIR.G8AK.8AEG=" at end of line by "=".
# <f89r1.10;F>    added "2SCGR.4ODAIR.G8AK.8AEG" at end of line.
#
# <f89r.32A;K>    replaced "IIIR" by "O".
#
# <f89r2.m2.6;K>  created with "ODS8TA2=" from <f89r2.45A;K>.
# <f89r2.b.0a;L>  created with "ODAL." from <f89r2.b.1;L>.
#
# <f89v.45A;K>    deleted "ODS8TA2." at beginning of line.
#
# <f89r2.b.1;L>   deleted "ODAL." from beginning of line.
#
# <f89r2.2;L>     replaced "IIIR" by "O" (twice).
#
# <f89r2.4;F>     deleted garbled part "OE8A4.6H6E...*C6E.6H6EF*G.HAR".
# <f89r2.4;F>     inserted guessed fix "OE8AM.OHOE....*COE.OHOEF*G.8AR" after "4OHCOE".
# <f89r2.4;L>     replaced "IIIR" by "O".
# <f89r2.5;L>     replaced "IIIR" by "O".
# <f89r2.10;L>    replaced "IIIR" by "O".
# <f89r2.11;L>    replaced "IIIR" by "O".
# <f89r2.12;L>    replaced "IIIR" by "O".
# <f89r2.14;L>    replaced "IIIR" by "O".
#
# <f89v2.9;F>     deleted "P*G.8AIRG.SCO2."
# <f89v2.9;F>     deleted "{lost synch}" at end of line.
# <f89v2.9;F>     inserted ".4ODOR.ODCOR.OHOE.SCCG.8AE.8AM" from <f89v2.10;F> at end of line.
# <f89v2.9;L>     deleted bogus text ".O8OR.SCO2...EHTCO8G.OHAE" at end of line.
# <f89v2.9;L>     inserted "{skipped rest of line}" at end of line.
# <f89v2.9;L>     replaced "IIIR" by "O".
# <f89v2.10;F>    deleted "4ODOR.ODCOR...8AM." at beginning of line, moved to <f89v2.10;F>.
# <f89v2.10;L>    replaced "IIIR" by "O".
# <f89v2.12;L>    replaced "IIIR" by "O" (twice).
# <f89v2.13;L>    replaced "IIIR" by "O".
# <f89v2.10;F>    inserted ".O8OR.SCO2.AM...EHTCO8G.OHAE" from <f89v2.11;F> at end of line.
# <f89v2.10;F>    deleted "{lost synch}" at end of line.
# <f89v2.11;F>    deleted line, joined to <f89v2.10;F>.
# <f89v2.11;L>    deleted blank line.
#
# <f89v1.7;F>     truncated from "" onwards.
# <f89v1.7a;F>    created from right half of <f89v1.7;F>.
# <f89v1.7;L>     truncated from "" onwards.
# <f89v1.7a;L>    created from right half of <f89v1.7;L>.
# <f89v1.7;L>     replaced "IIIR" by "O".
# <f89v1.11;F>    deleted "4ODAM" at end of line.
# <f89v1.12;F>    added "4ODAM." at beginning of line.
# <f89v1.13;F>    added ".ODCOE.8AE.TG" at end of line.
# <f89v1.14;F>    deleted "ODCOE.8AE.TG." at beginning of line.
# <f89v1.15;F>    added "HZG" at end of line.
# <f89v1.16;F>    deleted "HZG." at beginning of line.
#
# <f89v1.b.2;L>   deleted bogus "-2IIIR" at end of line.
# <f89v1.b.3;L>   deleted bogus "-2IIIR" at end of line.
# <f89v1.b.4;L>   deleted, bogus copy of <f89v1.t.4;L>.
# <f89v1.b.4;V>   deleted, bogus copy of <f89v1.t.4;V>.
#
# <f90r2.4;L>     replaced "IIIR" by "O".
# <f90r2.5;L>     truncated from "8AM.4ODOR." onwards.
# <f90r2.5a;L>    created from right half of <f90r2.5;L>.
# <f90r2.5;F>     truncated from "8AM.4ODOR." onwards.
# <f90r2.5a;F>    created from right half of <f90r2.5;F>.
#
# <f90v1.5;L>     replaced "IIIR" by "O".
#
# <f93r.4;C>      deelted "-TO8AN" at end of line.
# <f93r.5;C>      replaced "IIIR" by "O".
#
# <f95v2.2;F>     truncated from "CDAM.ODAR.OR." onwards.
# <f95v2.2a;F>    created from right half of <f95v2.2;F>.
#
# <f99v.11;F>     truncated from "OE.OEAE.ODCOE" onwards.
# <f99v.11a;F>    created with "!!!...!!!!".
# <f99v.11b;F>    created with "!!!...!!!!".
# <f99v.11c;F>    created with "!!!...!!!!".
# <f99v.11d;F>    created with "!!!...!!!!".
# <f99v.14;F>     deleted "GTOE.OEDCCOE8G-" at end of line.
# <f99v.14a;F>    created from "GTOE.OEDCCOE8G" of line <f99v.14;F>.
#
# <f100v.T.1;C>   deleted, mislabeled copy of <f100v2.R1.5;C>.
# <f100v.T.2;C>   deleted, mislabeled copy of <f100v2.R1.7;C>.
# <f100v.T.2;V>   added, was <f100v.B.2;V>.
# <f100v.T.3;C>   deleted, moved to <f100v.T.3;D>.
# <f100v.T.3;D>   added, was <f100v.T.3;C>.
# <f100v.T.3;V>   added, was <f100v.B.3;V>.
# <f100v.T.4;C>   deleted, moved to <f100v.T.4;D>.
# <f100v.T.4;D>   added, was <f100v.T.4;C>.
# <f100v.T.4;V>   added, was <f100v.B.4;V>.
#
# <f100v.M.1;C>   deleted, moved to <f100v.M.1;D>.
# <f100v.M.1;D>   added, was <f100v.M.1;C>.
# <f100v.M.1;V>   added, was <f100v.B.5;V>.
# <f100v.M.2;C>   deleted, mislabeled copy of <f100v.M.2;C>.
# <f100v.M.2;V>   added, was <f100v.B.6;V>.
# <f100v.M.3;C>   deleted, moved to <f100v.M.3;D>.
# <f100v.M.3;D>   added, was <f100v.M.3;C>.
# <f100v.M.3;V>   added, was <f100v.B.7;V>.
# <f100v.M.4;C>   deleted, mislabeled copy of <f100v.M.5;C>.
# <f100v.M.4;V>   added, was <f100v.B.8;V>.
# <f100v.M.5;C>   deleted, moved to <f100v.M.5;D>.
# <f100v.M.5;V>   added, was <f100v.B.9;V>.
# <f100v.M.5;D>   added, was <f100v.M.5;C>.
#
# <f100v.B.1;V>   deleted, moved to <f100v.T.1;V>.
# <f100v.B.1;V>   added, was <f100v.B.10;V>.
# <f100v.B.2;V>   deleted, moved to <f100v.T.2;V>.
# <f100v.B.2;V>   added, was <f100v.B.11;V>.
# <f100v.B.3;V>   deleted, moved to <f100v.T.3;V>.
# <f100v.B.3;V>   added, was <f100v.B.12;V>.
# <f100v.B.4;V>   deleted, moved to <f100v.T.4;V>.
# <f100v.B.4;V>   added, was <f100v.B.13;V>.
# <f100v.B.5;V>   deleted, moved to <f100v.M.1;V>.
# <f100v.B.6;V>   deleted, moved to <f100v.M.2;V>.
# <f100v.B.7;V>   deleted, moved to <f100v.M.3;V>.
# <f100v.B.8;V>   deleted, moved to <f100v.M.4;V>.
# <f100v.B.9;V>   deleted, moved to <f100v.M.5;V>.
# <f100v.B.10;V>  deleted, moved to <f100v.B.1;V>.
# <f100v.B.11;V>  deleted, moved to <f100v.B.2;V>.
# <f100v.B.12;V>  deleted, moved to <f100v.B.3;V>.
# <f100v.B.13;V>  deleted, moved to <f100v.B.4;V>.
#
#
# <f101v2.1;F>    deleted "OE-" at end of line.
# <f101v2.1;F>    added "!!...!!!.ORAR...O8AMG-" at end of line, from <f101v1.1;F>.
# <f101v2.1a;F>   created missing line with "!!...!!!!".
# <f101v2.1a;F>   added "OE...ODO8G.8AR" at end of line, from <f101v1.2;F>.
# <f101v2.2;F>    added "HZG.8AM.T*8O.8G8G" at end of line, from <f101v1.3;F>.
# <f101v2.3;F>    added "COE.....2O8AM.8G" at end of line, from <f101v1.4;F>.
# <f101v2.4;F>    added ".4ODCOE.....8G.8AR" at end of line, from <f101v1.5;F>.
# <f101v2.5;F>    deleted "8A*" at end of line.
# <f101v2.5;F>    added "8AM.TCCO8G.....TCC8G" at end of line, from <f101v1.6;F>.
# <f101v2.6;F>    added ".ODCCG.DZCO.....OETOR" at end of line, from <f101v1.7;F>.
# <f101v2.7;F>    added ".TCCG.HCG.....ARG" at end of line, from <f101v1.8;F>.
# <f101v2.8;F>    deleted "S*" at end of line.
# <f101v2.8;F>    added "TCCCO.***.!!!!!!!!!.TCOE...TCO8AK" at end of line, from <f101v1.9;F>.
#
# <f101v2.9;F>    deleted "O" at end of line.
# <f101v2.9;F>    added "*4OR.TCOE....4DAR" at end of line, from <f101v1.10;F>.
#
# <f101v1.1;F>    deleted line, joined to <f101v2.1;F>.
# <f101v1.2;F>    deleted line, joined to <f101v2.1a;F>.
# <f101v1.3;F>    deleted line, joined to <f101v2.2;F>.
# <f101v1.4;F>    deleted line, joined to <f101v2.3;F>.
# <f101v1.5;F>    deleted line, joined to <f101v2.4;F>.
# <f101v1.6;F>    deleted line, joined to <f101v2.5;F>.
# <f101v1.7;F>    deleted line, joined to <f101v2.6;F>.
# <f101v1.8;F>    deleted line, joined to <f101v2.7;F>.
# <f101v1.9;F>    deleted line, joined to <f101v2.8;F>.
#
# <f101v1.10;F>   deleted line, joined to <f101v2.9;F>.
#
# <f102v1.6;F>    deleted ".HOM.OE.8AM-" at end of line.
# <f102v1.6;F>    added "=" at end of line.
# <f102v1.7;F>    added "HOM.OE.8AM." at beginning of line.
#
# <f103r.1;J>     leading ".", deleted.
# <f103r.2;J>     leading ".", deleted.
# <f103r.2;I>     leading ".", deleted.
# <f103r.3;J>     leading ".", deleted.
# <f103r.5;F>     deleted comment "{'yt----rkar,otai' where?}".
# <f103r.5;F>     added ".RDAR,OHAI" at end of line, from comment.
# <f103r.14;F>    deleted ".4OHC8G" from end of line.
# <f103r.15;F>    added "4OHC8G." at beginning of line.
# <f103r.15;F>    deleted duplicate text ".4ODG.4OHC8G.4ODCCG.SOE.4OHCG.S".
# <f103r.15;G>    created line from duplicate text removed from <f103r.15;F>.
#
# <f103v.1;J>     added ".OEPTCG.4ODG.....4OHCAR.SC8G.8AE" at end of line.
# <f103v.4;J>     added "EDCC2.OE.4OHCC8G.ODCC8G" at end of line.
# <f103v.5;J>     added "4ODS8G.4ODAM.ODCT8G.4OPT8G.4OHC8G.4ODAM.OEG" at end of line.
# <f103v.6;J>     added "TCOE.4OCCOR.ESOR.4ODG.SC8G.4ODAM.TC8G.4ODA" at end of line.
# <f103v.38;F>    deleted ".8AM" at end of line.
# <f103v.39;F>    addded "8AM." at beginning of line.
#
# <f104r.4;F>     leading ".", deleted.
# <f104r.7;J>     added "8TO8CC2.SCOR.....4O8AM.ODAR" at beginning of line.
# <f104r.8;J>     added "OESCC8G.EDCC8G.....O8AR.4ODAE" at beginning of line.
# <f104r.44;F>    replaced ".E.2AM.OHAM....OHAM.OHAM=" by "-" at end of line.
# <f104r.45;F>    created with ".E.2AM.....OHAM=" from line <f104r.44;F>.
#
# <f105r.16;F>    leading ".", deleted.
#
# <f105v.15;F>    added ".R" at end of line.
# <f105v.16;F>    deleted "R." at beginning of line.
#
# <f106r.30;T>    deleted (empty) line.
# <f106r.30;F>    deleted line "2AM.TAE....TAR.AMG-".
#
# <f106v.20;F>    deleted ".GTCOE.DAM" at end of line.
# <f106v.21;F>    added "GTCOE.DAM." at beginning of line.
#
# <f107r.33;T>    duplicate ".", replaced by single ".".
#
# <f107r.8;F>     replaced "IIIR" by "O".
# <f107r.24;F>    replaced "IIIR" by "O".
# <f107r.27;F>    replaced "IIIR" by "O".
# <f107r.33;F>    replaced "IIIR" by "O" (twice).
# <f107v.32;F>    replaced "IIIR" by "O".
# <f107v.46;F>    replaced "IIIR" by "O".
#
# <f108v.17;F>    replaced "IIIR" by "O".
# <f108v.52;F>    replaced "IIIRFN" by ".OE".
#
# <f111r.1;F>     replaced "IIIR" by "II".
# <f111r.16;F>    replaced "IIIR" by "**".
# <f111r.18;F>    replaced "IIIRIIIR" by "**".
# <f111r.20;F>    replaced "IIIR" by "IK".
# <f111r.21;F>    replaced "EIIIR" by "**".
# <f111r.24;F>    replaced "IIIRIIIR" by "IK".
# <f111r.25;F>    replaced "IIIR" by "O".
# <f111r.29;F>    replaced "IIIRIIIR" by "TR".
# <f111r.34;F>    deleted "8AE" at end of line.
# <f111r.36;F>    inserted "!!!...!!8AE." at beginning of line. 
# <f111r.50;F>    replaced "IIIR" by "*".
#
# <f112v.42;F>    added ".OHARAG.SAM.4ODC8G" at end of line.
# <f112v.42;G>    added ".OHARAG.SAN.4ODC8G" at end of line.
# <f112v.43;F>    deleted "OHARAG.SAM.4ODC8G." from beginning of line.
# <f112v.43;F>    added ".AK" at end of line.
# <f112v.43;G>    deleted "OHARAG.SAN.4ODC8G." from beginning of line.
# <f112v.43;G>    added ".AK" at end of line.
# <f112v.44;F>    deleted "AK." at beginning of line.
# <f112v.44;G>    deleted ".AK." at beginning of line.
# <f112v.45;F>    deleted ".*EHAR.AIK" at end of line.
# <f112v.45;G>    deleted ".C.OHAR.AIK" at end of line.
# <f112v.47;F>    added "*EHAR.AIK." at beginning of line.
# <f112v.47;G>    added "C.OHAR.AIK." at beginning of line.
#
# <f114v.38;F>    deleted ".4OECCTC8G" at end of line.
# <f114v.39;F>    added "4OECCTC8G." at beginning of line.
#
# <f115r.36;F>    replaced "2OROE2.TCO2....PTAR-" by "=".
# <f115r.36a;F>   created from right half of <f115r.36;F>.
#
# <f116r.43;F>    deleted ".2AGDCC8G.....TCG.4OE.ODAK" at end of line.
# <f116r.43a;F>   created with "2AGDCC8G.....TCG.4OE.ODAK-" from <f116r.43;F>.
#
# <f116r.28;F>    bogus FSG "Z", replaced by "*".

