## <f0.S> {}
# --- begin comments by J. Stolfi --------------------------
# Last edited on 1998-10-09 22:21:20 by stolfi
#
# Splitting Landini's interlinear file v1.6.
# Jorge Stolfi 12 Oct 1997
# 
# Overview
# 
#   This directory contains a copy of Gabriel Landini's interlinear
#   transcription of the Voynich manuscript, version 1.6, split
#   into "textual units".
#
# Substantive changes
# 
#   This file ("f0.S") describes the splitting process only.
#   The Voynich text proper has been edited and reformatted to
#   some extent. These changes are described in companion
#   documents ("f0.U", "f0.E").
# 
# Textual units
# 
#   A textual unit is a maximal contiguous subset of a page that 
#   has the same location code (excluding line number), and 
#   a homogeneous "text structure", which is one of:
# 
#     "parags"      
# 
#       apparently prose, in multi-line paragraphs
# 
#     "starred-parags"    
# 
#       Like parags, but with a star-like symbol 
#       in front of each paragraph.
# 
#     "itemized-parags"
# 
#       Like parags, but with a single Voynich letter or symbol 
#       in front of each paragraph.  Here the letters are indicated in
#       "{}" comments; they are also listed separately as a "letters" unit.
# 
#     "circular-lines"
# 
#       Text where each line is written around a circle
#       in some diagram. (Sometimes the starting point is not known.)
# 
#     "radial-lines"
# 
#       Text where each line is written along a ray in some diagram. 
# 
#     "titles"
# 
#       Text where each line is a title for a page or figure.
# 
#     "itemized-lines"
# 
#       The right-hand column of an itemized list ("key-like sequence")
#       where each "item" is a line of text.
# 
#     "labels"
# 
#       List of labels attached to parts of figures.
#       Also the column of words from the table in f66r (page 117).
#       Here each label is terminated by "=", and multiple
#       lines of the same label are separated by "-".
# 
#     "letters"
# 
#       The single-letter labels in itemized lists.
#       Also the column of single letters in f66r (page 117).
#       Here each letter is terminated by "=".
# 
#     "-"
#     
#       No Voynich text, only comments.
#       
#     "?"
#     
#       Unknown text structure (for untranscribed or missing pages).
# 
# Unit numbering and file names
# 
#   Each unit is stored as a separate file named "fNNN.L", where
#   "NNN" is the panel number (folio, side, and division, e.g. f85r2), 
#   and L is the location code within the page. 
#   
#   Descriptive comments that apply to a whole panel are stored in a
#   separate file named "fNNN" (without location code). Gabriel's
#   opening comments are stored in the file "f0.I".
#   
#   Note that it was sometimes necessary to split a page with N
#   distinct text types into more than N units, in order to preserve
#   the ordering of the text in Gabriel's file. For example, the
#   transcribed "pharma" pages have blocks of normal text alternating
#   with rows of labels; each block of text and each row of labels
#   have therefore been made into a separate unit.
#   
#   Any textual unit that spans multiple panels has been 
#   assigned to the lowest-numbered of those panels.
#   
# Detailed description of files
# 
#   A detailed description of the splitting can be found in 
#   the "UNITS" file. Each line of UNITS describes one of the 
#   textual units above; it contains 8 fields separated by ":"
#   
#     * a 4-digit sequence number, which can be used to sort the
#       units in their "natural" reading order
#       
#     * the file name (fNNN or fNNN.L)
#     
#     * the apparent subject matter: "herbal", "bio", "astro", "cosmo", 
#       "pharma", "stars", "?" if unknown, or "-" if the file 
#       contains no text.
#       
#     * the "language" in Currier's sense ("A", "B", "?" if unknown, "-" if no text).
#     
#     * the "hand" ("1..5", "X", "Y", "?", or "-")
#     
#     * the type of textual unit ("parags", "labels", etc.; see list above)
#
#     * the sequential panel (page) number ("p001".. "p234"), in binding order
#       or "-" for files that are place-holders for missing folios.
#     
#     * other comments
#     
#   Any field may be followed by "?" denoting uncertainty.
#
# --- end comments by J. Stolfi ----------------------------
