## <f0.W> {}
# Last edited on 1998-12-08 02:01:10 by stolfi
#
# LINE BREAKING AND OTHER TRANSCRIPTION BUGS IN INTERLN.EVT
# by Jorge Stolfi
#
# The following is a cumulative list of various transcription bugs
# that were fixed by hand in the
# INTERLN.EVT file, after conversion to the EVA encoding.
#
# These bug fixes affected mostly line breaking and formatting.
# The main exception is a large number of "iiir"s in some
# transcriptions, which should have been "o"s.  Presumably they
# were caused by a coding table error somewhere.
#
# Omitted from this list are hundreds of replacements of "." by "-"
# where the text was interrupted by figures, and several dozen
# replacements of "-" by "=" (or vice-versa).
#
# The locators given here assume that the "[|]" groups were
# unfolded as explained in section <f0.U>.
#
# <f1r.17;C>      replaced "iiir" by "o".
# <f1r.18;C>      deleted "." at end of line.
#
# <f3v.4;C>       replaced "iiir" by "o".
# <f3v.13;C>      replaced "iiir" by "o".
#
# <f6v.4;C>       replaced "iiir" by "o".
# <f6v.4;D>       replaced "iiir" by "o".
#
# <f8r.10;F>      added "m" at end of line.
# <f8r.11;F>      deleted "m." at beginning of line.
# <f8r.13;F>      added "m" at end of line.
# <f8r.14;F>      deleted "m." at beginning of line.
# <f8r.17;F>      deleted whole line.
# <f8r.18;F>      added "okar." at beginning of line.
#
# <f9r.3;F>       added "am" at end of line.
# <f9r.4;F>       deleted "am." at beginning of line.
#
# <f11v.4;F>      added "on" at end of line.
# <f11v.5;F>      deleted "on." from beginning of line.
# <f11v.5;F>      added "m" at end of line.
# <f11v.6;F>      deleted "m." from beginning of line.
#
# <f13r.1;F>      added "m" at end of line.
# <f13r.2;F>      deleted "m." at beginning of line.
#
# <f13v.4;F>      added "ckhy" at end of line.
# <f13v.5;F>      deleted "ckhy." from beginning of line.
#
# <f14r.2;C>      replaced "iiin" by "o".
# <f14r.12;F>     added "m" at end of line.
# <f14r.13;F>     deleted "m" at beginning of line.
#
#
# <f15r.9;F>      deleted ".y" at end of line.
# <f15r.10;F>     added "y" at beginning of line.
#
# <f15v.7;F>      added "s" at end of line.
# <f15v.8;F>      deleted "s." at beginning of line.
#
# <f17r.9;C>      replaced "iiir" by "o".
#
# <f17v.16;F>     added "m" at end of line.
# <f17v.17;F>     deleted "m." at beginning of line.
#
# <f18r.2;F>      added "iiin" at end of line.
# <f18r.3;F>      deleted "iiin." at beginning of line.
# <f18r.3;F>      added "m" at end of line.
# <f18r.4;F>      deleted "m." at beginning of line.
#
# <f18v.4;F>      added "r" at end of line.
# <f18v.5;F>      deleted "r." from beginning of line.
#
# <f19v.6;C>      replaced by "{missing line}" comment.
# <f19v.6;F>      truncated after "chocthy.s".
# <f19v.6a;C>     new line, same as old <f19v.6;C>.
# <f19v.6a;F>     new line, with the part of old <f19v.6;F> after "chocthy.s".
#
# <f20v.10;F>     deleted "*." at beginning of line.
#
# <f23r.7;F>      added "m" at end of line.
# <f23r.8;F>      deleted "m." at beginning of line.
#
# <f24r.4;F>      added "a" at end of line.
# <f24r.5;F>      deleted "a." at beginning of line.
#
# <f24v.4;F>      deleted "y." at beginning of line.
# <f24v.4;F>      deleted ".oeor" at end of line.
# <f24v.5;F>      added "oeor." at beginning of line.
#
# <f25r.3;F>      added "in" at end of line.
# <f25r.4;F>      deleted "in." at beginning of line.
#
# <f26r.2;F>      added "r" at end of line.
# <f26r.3;F>      deleted "r." at beginning of line.
#
# <f26r.8;C>      replaced "iiin" by "o".
#
# <f27r.9;F>      added "m" at end of line.
# <f27r.10;F>     deleted "m." at beginning of line.
#
# <f27v.4;F>      bogus "=" in middle of line; replaced by ".".
# <f27v.5;C>      replaced by "{missing line}" comment.
# <f27v.5;F>      truncated after "ctho.dol".
# <f27v.6;C>      added old <f27v.5;C> at beginning of line.
# <f27v.6;F>      added the truncated part of old <f27v.5;F> at beginning of line.
#
# <f28v.1;C>      replaced "cph" by "iiin" (twice).
#
# <f29v.1;C>      replaced "iiin" by "ch".
# <f29v.4;F>      deleted "-" between words 7 and 8.
# <f29v.7;C>      deleted extra "-" between words 5 and 6.
# <f29v.7;F>      deleted "--" between words 5 and 6.
# <f29v.10;F>     inserted "-" in word 4 between "cth" and "chyd".
# <f29v.12;C>     replaced "iiin" by "ch".
#
# <f30r.3;F>      added "im" at end of line.
# <f30r.4;F>      deleted "im." from beginning of line.
# <f30r.12;F>     added "iin" at end of line.
# <f30r.13;F>     deleted "iin." at beginning of line.
#
# <f30v.7;C>      replaced "iiir" by "o".
#
# <f31r.15;F>     added "r" at end of line.
# <f31r.16;F>     deleted "r." at beginning of line.
#
# <f31v.2;F>      deleted starting from "ykeeo"
# <f31v.3;F>      created from parts of lines 2 and 4.
# <f31v.4;F>      deleted up to "lkedy".
# <f31v.4;F>      added "m" at end of line.
# <f31v.5;F>      deleted "m." at beginning of line.
#
# <f32r.2;F>      added "f" at end of line.
# <f32r.3;F>      deleted "f." at beginning of line.
#
# <f32v.11;C>     replaced "iiin" by "ch".
#
# <f33r.5;C>      replaced "iir" by "o".
#
# <f33v.1;F>      added ".es" at end of line.
# <f33v.2;F>      deleted "es." from beginning of line.
# <f33v.4;F>      added "iin" at end of line.
# <f33v.5;F>      deleted "iin." at beginning of line.
# <f33v.9;C>      replaced ".-" by "-".
# <f33v.9;F>      replaced ".-" by "-".
#
# <f34r.7;F>      moved "iir.amm." to end of line.
# <f34r.9;F>      "chZt" replaced by "chcth" (from ";C>" version).
#
# <f34r.4;C>      deleted right half after plant.
# <f34r.4;C>      appended right half of <f34r.5;C>.
# <f34r.4;F>      deleted right half after plant.
# <f34r.4;F>      appended right half of <f34r.5;F>.
# <f34r.5;C>      deleted right half after plant.
# <f34r.5;C>      appended right half of <f34r.6;C>.
# <f34r.5;F>      deleted right half after plant.
# <f34r.5;F>      appended right half of <f34r.6;F>.
# <f34r.6;C>      deleted right half after plant.
# <f34r.6;C>      appended right half of <f34r.7;C>.
# <f34r.6;F>      deleted right half after plant.
# <f34r.6;F>      appended right half of <f34r.7;F>.
# <f34r.7;C>      deleted right half after plant.
# <f34r.7;C>      appended right half of <f34r.8;C>.
# <f34r.7;F>      deleted right half after plant.
# <f34r.7;F>      appended right half of <f34r.8;F>.
# <f34r.8;C>      deleted right half after plant.
# <f34r.8;C>      appended right half of <f34r.9;C>.
# <f34r.8;F>      deleted right half after plant.
# <f34r.8;F>      appended right half of <f34r.9;F>.
# <f34r.9;C>      deleted right half after plant.
# <f34r.9;C>      appended <f34r.10;C>.
# <f34r.9;F>      deleted right half after plant.
# <f34r.9;F>      appended <f34r.10;F>.
# <f34r.10;C>     deleted line.
# <f34r.10;F>     deleted line.
#
# <f34v.6;F>      deleted ".olchdaiin" at end of line.
# <f34v.7;F>      added "olchdaiin." at beginning of line.
#
# <f35r.10;C>     replaced "iiin" by "ch".
# <f36r.4;C>      replaced "iir" by "m".
#
# <f36v.7;C>      replaced "iiir" by "o".
#
# <f37r.10;F>     added "iir" at end of line.
# <f37r.11;F>     deleted "iir." at beginning of line.
# <f37r.5;C>      replaced "iiin" by "o".
# <f37r.6;C>      replaced "iiin" by "o".
#
# <f37v.15;F>     added "in" at end of line.
# <f37v.16;F>     deleted "in." at beginning of line.
# <f37v.19;F>     truncated line after "qokoiiin.ykeeols".
# <f37v.19a;F>    created line with part of <f37v.19;F>.
# <f37v.19b;F>    created line with part of <f37v.19;F>.
# <f37v.19;C>     renumbered <f37v.19b;C>.
#
# <f39r.4;F>      added "m" at end of line.
# <f39r.5;F>      deleted "m." at beginning of line.
# <f39r.14;C>     replaced "iir" by "o".
#
# <f39v.6;C>      replaced "iiir" by "o".
# <f39v.10;F>     added "p" at end of line.
# <f39v.11;F>     deleted "p." at beginning of line.
# <f39v.12;F>     deleted from "dain.ockhedy.otedy." onwards.
# <f39v.12;C>     deleted from "dain.ockhedy.otedy." onwards.
# <f39v.P.13;F>   created from right half of <f39v.12;F>.
# <f39v.P.13;C>   created from right half of <f39v.12;C>.
#
# <f40r.8;F>      added "m" at end of line.
# <f40r.9;F>      deleted "m." from beginning of line.
#
# <f40v.7;F>      added "r" at end of line.
# <f40v.8;F>      deleted "r." at beginning of line.
#
# <f41r.8;G>      deleted line.
# <f41r.9;G>      added "qokeedy.okedy." at beginning of line, from <f41r.8;G>.
# <f41r.10;C>     replaced "iiir" by ".".
#
# <f41v.3;C>      replaced "iiir" by "o" (twice).
#
# <f42r.9;C>      renamed <f42r.P2.9a;C>.
# <f42r.9;F>      truncated line after "shol.ety.chary".
# <f42r.9;G>      deleted, tail became <f42r.9a;G>.
# <f42r.9a;F>     created from tail of line <f42r.9;F>.
# <f42r.9a;G>     created from tail of line <f42r.9;G>.
# <f42r.14;F>     added "-{plant}daim" at end of line.
# <f42r.15;F>     deleted "daim=" at beginning of line.
#
# <f42v.4;F>      added "m" at end of line.
# <f42v.4;G>      added "m" at end of line.
# <f42v.5;F>      deleted "m." at beginning of line.
# <f42v.5;G>      deleted "m." at beginning of line.
# <f42v.5;C>      replaced "iiin" by "ch".
# <f42v.12;C>     replaced "iiin" by "ch".
#
# <f43r.4;G>      leading ".", deleted.
# <f43r.8;F>      replaced "-d.dshedy" on by "d-".
# <f43r.8;G>      deleted from "-d.dshedy" on.
# <f43r.9;C>      replaced by <f43v.1;C>.
# <f43r.9;F>      replaced by part of line 8 from "dshedy" on.
# <f43r.10;C>     replaced "iir" by "o".
# <f43r.12;C>     replaced "iir" by "o".
# <f43r.12;F>     added "iin" at end of line.
# <f43r.13;F>     deleted "iin." at beginning of line.
# <f43r.13;G>     deleted "iin." at beginning of line.
#
# <f43v.1;C>      replaced by <f43r.9;C>.
# <f43v.1;F>      added "y" at end of line.
# <f43v.1;G>      added "y" at end of line.
# <f43v.2;F>      deleted "y." at beginning of line.
# <f43v.3;C>      replaced "iiin" by "o".
# <f43v.5;C>      replaced "iiin" by "o".
#
# <f44v.5;F>      added "in" at end of line.
# <f44v.5;G>      added "in" at end of line.
# <f44v.6;F>      deleted "in." at beginning of line.
# <f44v.6;G>      deleted "in." at beginning of line.
# <f44v.10;C>     replaced "iiir" by "*".
#
# <f45r.8;F>      added ".m" at end of line.
# <f45r.8;G>      added ".m" at end of line.
# <f45r.9;F>      deleted "m." at beginning of line.
# <f45r.9;G>      deleted "m." at beginning of line.
#
# <f45v.6;F>      added "m" at end of line.
# <f45v.6;G>      added "m" at end of line.
# <f45v.7;F>      deleted "m." at beginning of line.
#
# <f46r.3;C>      replaced "iiin" by "o".
#
# <f46v.7;G>      duplicate ".", replaced by single ".".
# <f46v.7;C>      replaced "-okeedchsy....-" by "=".
# <f46v.7;G>      replaced "-okeedchsy....-" by "=".
# <f46v.7;F>      replaced "-okeedchsy....-" by "=".
# <f46v.7a;C>     created from deleted part of <f46v.7;C>
# <f46v.7a;G>     created from deleted part of <f46v.7;G>
# <f46v.7a;F>     created from deleted part of <f46v.7;F>
#
# <f47r.9;C>      replaced "iiin" by "o".
#
# <f47v.9;F>      added "iin" at end of line.
# <f47v.10;F>     deleted "iin." at beginning of line.
# <f47v.10;G>     deleted "iin." at beginning of line.
# <f47v.12;F>     duplicate ".", replaced by single ".".
# <f47v.12;G>     leading ".", deleted.
#
# <f48r.3;C>      replaced "iiin" by "o".
#
# <f48v.7;F>      bogus "=" in middle of line; replaced by ".".
# <f48v.7;F>      added "y" at end of line.
# <f48v.8;F>      deleted "y." at beginning of line.
# <f48v.8;G>      deleted "y." at beginning of line.
# <f48v.10;C>     replaced "=" by "-" at end of line.
# <f48v.10;F>     deleted ".ykeedal.chckhy. ... .dary=" at end of line.
# <f48v.10;F>     added "-" at end of line.
# <f48v.10;G>     deleted ".ykeedal.*ckhy. ... .dary=" at end of line.
# <f48v.10;G>     added "-" at end of line.
# <f48v.11;C>     created line with "{skipped line}!!! ...".
# <f48v.11;F>     created line with "ykeedal.chckhy. ... .dary=" from <f48v.10;F>.
# <f48v.11;G>     created line with "ykeedal.*ckhy. ... .dary=" from <f48v.10;G>.
#
# <f49r.20;F>     added "iin" at end of line.
# <f49r.21;F>     deleted "iin." at beginning of line.
# <f49r.21;G>     deleted "iin." at beginning of line.
#
# <f49v.16;F>     added "m" at end of line.
# <f49v.16;G>     added "m" at end of line.
# <f49v.17;F>     deleted "m." from beginning of line.
# <f49v.17;G>     deleted "m." from beginning of line.
# <f49v.19;F>     added "m" at end of line.
# <f49v.19;G>     added "m" at end of line.
# <f49v.20;F>     deleted "m." from beginning of line.
# <f49v.20;G>     deleted "m." from beginning of line.
# <f49v.23;F>     added ".r" at end of line.
# <f49v.23;G>     added ".r" at end of line.
# <f49v.24;F>     deleted "r." from beginning of line.
# <f49v.24;G>     deleted "r." from beginning of line.
#
# <f50r.2;F>      added "ar.okam" at end of line.
# <f50r.3;C>      replaced "iiin" by "o".
# <f50r.3;F>      deleted "ar.okam." from beginning of line.
# <f50r.3;G>      deleted "ar.okam." from beginning of line.
#
# <f50r.2;C>      deleted ".olaiin.chefchdy" from end of line (dupl above).
# <f50r.4;C>      replaced "iiin" by "o".
# <f50r.4;F>      deleted ".s" from end of line.
# <f50r.4;G>      deleted ".s" from end of line.
# <f50r.5;F>      added "s" at beginning of line.
# <f50r.5;G>      added "s" at beginning of line.
# <f50r.7;C>      replaced "iim" by "o".
# 
# <f51r.7;C>      renamed <f51r.P.7a;C>.
# <f51r.7;F>      truncated line after "daiin.ykald".
# <f51r.7;G>      deleted; part of it became <f51r.7a;G>.
# <f51r.7a;F>     created from second half of <f51r.7;F>.
# <f51r.7a;F>     added "l" at end of line.
# <f51r.7a;G>     created from second half of <f51r.7;G>.
# <f51r.7a;G>     added "l" at end of line.
# <f51r.8;F>      deleted "l." from beginning of line.
#
# <f51v.4;F>      added "m" at end of line.
# <f51v.4;F>      added "m" at end of line.
# <f51v.5;F>      deleted "m." from beginning of line.
#
# <f52r.7;F>      added "l" at end of line.
# <f52r.7;G>      added "l" at end of line.
# <f52r.8;F>      deleted "l." from beginning of line.
# <f52r.8;G>      deleted "l." from beginning of line.
#
# <f52v.5;F>      added "m" at end of line.
# <f52v.6;F>      deleted "m." at beginning of line.
#
# <f53v.2;F>      added "y" at end of line.
# <f53v.3;F>      deleted "y." at beginning of line.
#
# <f54r.6;F>      added "ar" at end of line.
# <f54r.7;F>      deleted "ar." at beginning of line.
#
# <f54v.8;C>      deleted bogus text after "okal.om-".
# <f54v.8;F>      deleted "y-" at end of line.
# <f54v.9;F>      added "y" at beginning of line.
#
# <f55r.11;F>     added "iin" at end of line.
# <f55r.12;F>     deleted "iin." at beginning of line.
#
# <f55v.5;C>      replaced "iiin" by "o".
# <f55v.11;F>     added "iin" at end of line.
# <f55v.12;F>     deleted "iin." at beginning of line.
#
# <f56v.4;F>      added "iin" at end of line.
# <f56v.5;F>      deleted "iin." at beginning of line.
# <f56v.12;F>     added "iin" at end of line.
# <f56v.13;F>     deleted "iin." at beginning of line.
#
# <f57r.7;F>      added "m" at end of line.
# <f57r.8;F>      deleted "m." at beginning of line.
#
# <f58r.32;F>     truncated after "qokaldy", moved to <f58r.32a;F>.
# <f58r.32a;F>    created from right 2/3 of <f58r.32;F>.
#
# <f66r.L.14;F>   bogus FSG "Z", replaced by "*".
#
# <f66r.3;C>      duplicate ".", replaced by single ".".
# <f66r.24;C>     replaced "iiir" by "o".
#
# <f66r.W.1;C>    replaced "iil" by "t" (twice).
# <f66r.W.1;C>    replaced "ir" by "ch" (four times).
# <f66r.W.1;C>    replaced "il" by "y" (twice).
#
# <f66v.7;F>      bogus FSG "J", replaced by "*".
#
# <f68r1.3;C>     added "okeey.rar.eckhear.daraj-" at end of line.
# <f68r1.3;F>     added "okey.ror.chckhar.daram-" at end of line.
# <f68r1.4;C>     deleted "okeey.rar.eckhear.daraj-" from end of line.
# <f68r1.4;F>     deleted "okey.ror.chckhar.daram-" from end of line.
#
# <f68r2.S18.1;R> added ".chol" at end of line, from <f68r2.S19;R>.
# <f68r2.S18.1;V> added ".chol" at end of line, from <f68r2.S19;V>.
#
# <f68r2.S19;R>   deleted, merged into <f68r2.S18.1;R>
# <f68r2.S19;V>   deleted, merged into <f68r2.S18.1;V>
#
# <f68v3.1;C>     duplicate line number, renumbered <f68v3.0;C>.
# <f68v3.1;F>     duplicate line number, renumbered <f68v3.0;F>.
# <f68v3.0;F>     deleted ".sshey" from end of line.
# <f68v3.1;F>     added "sshey." at beginning of line.
#
# <f68v2.C.1;C>   replaced by join of C.1 thru C.4, with new break at 10:30.
# <f68v2.C.1;D>   replaced by join of D.1 and C2 thru C.4, with new break at 10:30.
# <f68v2.C.1;C>   replaced "iiir" by "o".
# <f68v2.C.1;D>   replaced "iiir" by "o".
# <f68v2.C.2;C>   deleted line.
# <f68v2.C.3;C>   deleted line.
# <f68v2.C.4;C>   deleted line.
#
# <f68v2.R.12;C>  replaced "iiir" by "o".
# <f68v2.R.4;C>   replaced "iiir" by "o".
#
# <f70r2.4;F>     bogus FSG "Z", replaced by "*".
# <f70r2.9;F>     deleted "qokal.chol...cheey.okal-" from end of line.
# <f70r2.9a;F>    created line with "{crease}qokal.chol...cheey.okal-".
# <f70r2.10;F>    deleted "qokal.shkal...qokal.chdy-" from end of line.
# <f70r2.10a;F>   created line "qokal.shkal...qokal.chdy-".
# <f70r2.11;F>    deleted "okaiin.chcthey.s.or.ary=" frm end of line.
# <f70r2.11a;F>   created line with "okaiin.chcthey.s.or.ary=".
#
# <f75r.7;F>      added right half of <f75r.8;F>.
# <f75r.8;F>      replaced right half by right half of <f75r.9;F>.
# <f75r.9;F>      deleted right half.
#
# <f75v.28;C>     leading ".", deleted.
#
# <f76r.5;F>      added "r" at end of line.
#
# <f76r.L.6;F>    deleted "r." at beginning of line.
# <f76r.L.13;F>   deleted "ir." at beginning of line.
# <f76r.L.14;F>   added "o" label.
# <f76r.L.15;F>   deleted "o" label.
# <f76r.L.26;F>   deleted "r" label.
# <f76r.L.38;F>   deleted "iin" label.
#
# <f76r.12;F>     added "ir" at end of line.
# <f76r.14;F>     added "dchedy.qolchey.qokefy" from line <f76r.15;F>.
# <f76r.15;F>     deleted "dchedy.qolchey.qokefy" from beginning of line.
# <f76r.25;F>     added "r" at end of line.
# <f76r.33;F>     added ".lchedy.qolain....otalam" at end of line.
# <f76r.34;F>     deleted "lchedy.qolain....otalam." at beginning of line.
# <f76r.37;F>     added "iin" at end of line.
#
# <f77v.28;F>     added "iin" at end of line.
# <f77v.29;F>     deleted "iin." at beginning of line.
#
# <f78r.7;F>      deleted ".dar.alocfhy" at end of line.
# <f78r.11;F>     deleted ".dchedaly" at end of line.
# <f78r.24;F>     deleted ".otarodl.shy.orory" at end of line.
#
# <f78r.X.4;F>    created line with "dchedaly=" from <f78r.11;F>.
# <f78r.X.3;F>    created line with "dar.alocfhy=" from <f78r.7;F>.
# <f78r.X.5;F>    created line with "otarodl.shy.orory=" from <f78r.24;F>.
#
# <f78v.3;F>      added "m" at end of line.
# <f78v.4;F>      deleted "m." at beginning of line.
# <f78v.8;G>      replaced "iiim" by "in".
# <f78v.8;F>      added "iin" at end of line.
# <f78v.9;F>      deleted "iin." at beginning of line.
# <f78v.15;F>     added "s" at end of line.
# <f78v.16;F>     deleted "s." at beginning of line.
#
# <f79r.9;F>      added "m" at end of line.
# <f79r.10;F>     deleted "m." at beginning of line.#
# <f79r.14;F>     added ".cheey.chey.daiin.chedy.qol" at end of line.
# <f79r.15;F>     deleted "cheey.chey.daiin.chedy.qol." at beginning of line.
# <f79r.16;F>     added "m" at end of line.
# <f79r.17;F>     deleted "m." at beginning of line.
# <f79r.30;F>     deleted bogus "-" in "olon".
#
# <f79v.8;F>      added "l" at end of line.
# <f79v.9;F>      deleted "l" at beginning of line.
# <f79v.13;F>     added "m" at end of line.
# <f79v.14;F>     deleted "m." at beginning of line.
# <f79v.15;F>     added "iin" at end of line.
# <f79v.16;F>     deleted "iin." at beginning of line.
# <f79v.18;F>     deleted ".y" from linendof line.
# <f79v.19;F>     added "y" at beginning of line.
# <f79v.26;F>     added "*" at end of line.
# <f79v.27;F>     deleted "*." at beginning of line.
# <f79v.31;F>     added "iin" at end of line.
# <f79v.32;F>     deleted "iin." at beginning of line.
# <f79v.38;F>     added "m" at end of line.
# <f79v.39;F>     deleted ""m."" at beginning of line.
# <f79v.41;F>     added "iin" at end of line.
# <f79v.42;F>     deleted "iin." at beginning of line.
#
# <f80r.2;F>      added "s" at end of line.
# <f80r.3;F>      deleted "s." at beginning of line.
# <f80r.3;F>      added "m" at end of line.
# <f80r.4;F>      deleted "m." at beginning of line.
# <f80r.7;F>      added "m" at end of line.
# <f80r.8;F>      deleted "m." at beginning of line.
# <f80r.10;F>     added "m" at end of line.
# <f80r.11;F>     deleted "m." at beginning of line.
# <f80r.16;F>     deleted whole line.
# <f80r.17;F>     added "qol." in front from pev line.
# <f80r.38;F>     added "m" at end of line.
# <f80r.39;F>     deleted "m." at beginning of line.
# <f80r.41;F>     added "***.*" at beginning of line.
# <f80r.40;F>     replaced "o-" by "o**-"
#
# <f80v.14;F>     added "r" at end of line.
# <f80v.15;F>     deleted "r." at beginning of line.
# <f80v.21;F>     added "m" at end of line.
# <f80v.22;F>     deleted "m." at beginning of line.
# <f80v.33;F>     added "m" at end of line.
# <f80v.34;F>     deleted "m." at beginning of line.
# <f80v.31;F>     added "iin" at end of line.
# <f80v.32;F>     deleted "iin." at beginning of line.
#
# <f81r.5;F>      added "iin" at end of line.
# <f81r.6;F>      deleted "iin." at beginning of line.
# <f81r.7;F>      added "iin" at end of line.
# <f81r.8;F>      deleted "iin." at beginning of line.
#
# <f81v.4;F>      added "y" at end of line.
# <f81v.5;F>      deleted "y." at beginning of line.
#
# <f81v.5;F>      added ".kar.daiin.okar" at end of line.
# <f81v.6;F>      deleted "kar.daiin.okar." at beginning of line.
#
# <f81v.15;F>     added "*{skipped text}" after ".chedy.o"
# <f81v.15;F>     deleted ".qor." at end of line.
# <f81v.16;F>     added "qor." at beginning of line.
#
# <f82r.31;F>     added "iin" at end of line.
# <f82r.32;F>     deleted "iin." at beginning of line.
#
# <f82v.21;F>     added "***." at beginning of line.
# <f82v.30;F>     added "iin" at end of line.
# <f82v.31;F>     deleted "iin." at beginning of line.
#
# <f83r.11;F>     added "o" at end of line.
# <f83r.12;F>     deleted "o." at beginning of line.
# <f83r.25;F>     added "l" at end of line.
# <f83r.26;F>     deleted "l." at beginning of line.
# <f83r.30;F>     added "iin" at end of line.
# <f83r.31;F>     deleted "iin." at beginning of line.
# <f83r.33;F>     added "iin" at end of line.
# <f83r.34;F>     deleted "iin." at beginning of line.
# <f83r.32;F>     split part to "shedal" as line <f83r.X.3;F>
# <f83r.33;F>     split part to "chdal aiin" as line <f83r.X.4;F>
# <f83r.34;F>     split part to "chedy" as line <f83r.X.5;F>
# <f83r.41;C>     split part to "raly.ol" as line <f83r.Z.8;F>
# <f83r.41;F>     split part to "raly.ol" as line <f83r.Z.8;F>
# <f83r.42;C>     split part to "qotar.ol" as line <f83r.Z.9;F>
# <f83r.42;F>     split part to "qotar.ol" as line <f83r.Z.9;F>
# <f83r.43;C>     split part to "ldalor" as line <f83r.Z.10;F>
# <f83r.43;F>     split part to "ldalor" as line <f83r.Z.10;F>
# <f83r.44;C>     split part to "ctheil" as line <f83r.Z.11;F>
# <f83r.44;F>     split part to "cthol" as line <f83r.Z.11;F>
#
# <f83v.14;F>     deleted "qokain.cheeal" (nothing left on the line).
# <f83v.15;F>     added "qokain.cheeal." at beginning of line.
# <f83v.16;F>     deleted ".chedy.qol" at end of line.
# <f83v.17;F>     added "chedy.qol" at beginning of line.
# <f83v.20;F>     added "s" at end of line.
# <f83v.20;F>     deleted "okchdy." at beginning of line, moved to <f83v.Y.8;F>.
# <f83v.21;F>     deleted "s." at beginning of line.
# <f83v.25;F>     added "s" at end of line.
# <f83v.26;F>     deleted "s." at beginning of line.
#
# <f83v.Y.8;F>    created with "okchdy=" from <f83v.P.20;F>.
#
# <f84r.24;C>     deleted to "orol.", moved to <f84r.Z.24;C>.
# <f84r.24;F>     deleted to "orol.", moved to <f84r.Z.24;C>.
#
# <f84r.16;F>     added "iin" at end of line.
# <f84r.17;F>     deleted "iin." at beginning of line.
# <f84r.18;F>     deleted "otaly." at beginning of line.
# <f84r.30;F>     deleted up to first "shedy.saiin.".
#
# <f84r.X.13;F>   added "otaly=" from <f84r.18;F>.
#
# <f84v.12;F>     added "iin" at end of line.
# <f84v.13;F>     deleted "iin." at beginning of line.
# <f84v.21;F>     deleted "okar." at beginning of line.
# <f84v.22;F>     deleted "ydairol." at beginning of line.
# <f84v.23;F>     deleted "ychckhy." at beginning of line.
# <f84v.24;F>     deleted "dshedy." at beginning of line.
# <f84v.31;F>     deleted "okchdy." at beginning of line.
# <f84v.32;F>     deleted "solchey." at beginning of line.
# <f84v.33;F>     deleted "dairoldy." at beginning of line.
# <f84v.34;F>     deleted "dorchy." at beginning of line.
# <f84v.35;F>     added "s" at end of line.
# <f84v.35;F>     deleted "qckhy." at beginning of line.
# <f84v.36;F>     deleted "ochedy." at beginning of line.
# <f84v.36;F>     deleted "s." at beginning of line.
# <f84v.X.20;F>   created with "okar" from <f84v.21;F>.
# <f84v.X.21;F>   created with "ydairol" from <f84v.22;F>.
# <f84v.X.22;F>   created with "ychckhy" from <f84v.23;F>.
# <f84v.X.23;F>   created with "dshedy" from <f84v.24;F>.
# <f84v.Y.30;F>   created with "okchdy" from <f84v.31;F>.
# <f84v.Y.31;F>   created with "solchey" from <f84v.32;F>.
# <f84v.Y.32;F>   created with "dairoldy" from <f84v.33;F>.
# <f84v.Y.33;F>   created with "dorchy" from <f84v.34;F>.
# <f84v.Y.34;F>   created with "qckhy" from <f84v.35;F>.
# <f84v.Y.35;F>   created with "ochedy" from <f84v.36;F>.
#
# <f85r1.29;F>    split off after "qokchdy." as separate line.
# <f85r1.29a;F>   created from second half of <f85r1.29;F>.
#
# <f86v4.4;F>     deleted ".dar.oleey.olyy" at end of line.
# <f86v4.5;F>     created new line with "{centered -- "title"?}dar.oleey.olyy=".
#
# <f86v6.22;F>    bogus FSG "X", replaced by "*".
#
# <f86v5.7;F>     deleted ".octhal" at end of line.
# <f86v5.8;F>     added "octhal." at beginning of line.
# <f86v5.9;F>     truncated line after "al.ykain".
# <f86v5.9a;F>    created line from right half of <f86v5.9;F>.
# <f86v5.18;F>    truncated line after "chey.shckhy".
# <f86v5.18a;F>   created line from right half of <f86v5.18;F>.
# <f86v5.22;F>    deleted ".sair" at end of line.
# <f86v5.23;F>    added "sair." at beginning of line.
#
# <f86v3.4;F>     added "ykaiin{skipped line}m" at beginning of line
# <f86v3.5;F>     deleted "ykaiinm." from beginning of line.
#
# <f87v.3;F>      truncated from "ycheockhy.okey" onwards.
# <f87v.3a;F>     created from right half of <f87v.3;F>.
# <f87v.4;F>      truncated from "dcheos.shey" onwards.
# <f87v.4a;F>     created from right half of <f87v.4;F>.
# <f87v.6;F>      truncated from "techol.qoshcheody" onwards.
# <f87v.6a;F>     created from right half of <f87v.6;F>.
#
# <f88r.b.3;L>    replaced "iiir" by "o".
#
# <f88v.3;L>      replaced "iiir" by "o".
# <f88v.4;L>      replaced "iiir" by "o" (twice).
#
# <f88v.7;L>      replaced "iiir" by "o".
# <f88v.8;L>      replaced "iiir" by "o" (twice).
# <f88v.9;L>      replaced "iiir" by "o".
# <f88v.14;L>     replaced "iiir" by "o".
#
# <f89r1.1;L>     replaced "iiir" by "o".
# <f89r1.2;L>     replaced "iiir" by "o".
# <f89r1.3;L>     replaced "iiir" by "o" (twice).
# <f89r1.4;L>     replaced "iiir" by "o".
#
# <f89r1.8;L>     replaced "iiir" by "o".
# <f89r1.9;L>     replaced "iiir" by "o".
#
# <f89r1.9;F>     replaced ".ssheyr.qokair.ydam.daly=" at end of line by "=".
# <f89r1.10;F>    added "ssheyr.qokair.ydam.daly" at end of line.
#
# <f89r.32A;K>    replaced "iiir" by "o".
#
# <f89r2.m2.6;K>  created with "okshdchas=" from <f89r2.45A;K>.
# <f89r2.b.0a;L>  created with "okan." from <f89r2.b.1;L>.
#
# <f89v.45A;K>    deleted "okshdchas." at beginning of line.
#
# <f89r2.b.1;L>   deleted "okan." from beginning of line.
#
# <f89r2.2;L>     replaced "iiir" by "o" (twice).
#
# <f89r2.4;F>     deleted garbled part "oldaq.gtgl ...*egl.gtglf*y.tar".
# <f89r2.4;F>     inserted guessed fix "oldaiin.otol....*eol.otolf*y.dar" after "qoteol".
# <f89r2.4;L>     replaced "iiir" by "o".
# <f89r2.5;L>     replaced "iiir" by "o".
# <f89r2.10;L>    replaced "iiir" by "o".
# <f89r2.11;L>    replaced "iiir" by "o".
# <f89r2.12;L>    replaced "iiir" by "o".
# <f89r2.14;L>    replaced "iiir" by "o".
#
# <f89v2.9;F>     deleted "p*y.dairy.sheos."
# <f89v2.9;F>     deleted "{lost synch}" at end of line.
# <f89v2.9;F>     inserted ".qokor.okeor.otol.sheey.dal.daiin" from <f89v2.10;F> at end of line.
# <f89v2.9;L>     deleted bogus text ".odor.sheos ... ltcheody.otal" at end of line.
# <f89v2.9;L>     inserted "{skipped rest of line}" at end of line.
# <f89v2.9;L>     replaced "iiir" by "o".
# <f89v2.10;F>    deleted "qokor.okeor ... daiin." at beginning of line, moved to <f89v2.10;F>.
# <f89v2.10;L>    replaced "iiir" by "o".
# <f89v2.12;L>    replaced "iiir" by "o" (twice).
# <f89v2.13;L>    replaced "iiir" by "o".
# <f89v2.10;F>    inserted ".odor.sheos.aiin ... ltcheody.otal" from <f89v2.11;F> at end of line.
# <f89v2.10;F>    deleted "{lost synch}" at end of line.
# <f89v2.11;F>    deleted line, joined to <f89v2.10;F>.
# <f89v2.11;L>    deleted blank line.
#
# <f89v1.7;F>     truncated from "" onwards.
# <f89v1.7a;F>    created from right half of <f89v1.7;F>.
# <f89v1.7;L>     truncated from "" onwards.
# <f89v1.7a;L>    created from right half of <f89v1.7;L>.
# <f89v1.7;L>     replaced "iiir" by "o".
#
# <f89v1.b.2;L>   deleted bogus "-siiir" at end of line.
# <f89v1.b.3;L>   deleted bogus "-siiir" at end of line.
# <f89v1.b.4;L>   deleted, bogus copy of <f89v1.t.4;L>.
# <f89v1.b.4;V>   deleted, bogus copy of <f89v1.t.4;V>.
#
# <f90r2.4;L>     replaced "iiir" by "o".
# <f90r2.5;L>     truncated from "daiin.qokor." onwards.
# <f90r2.5a;L>    created from right half of <f90r2.5;L>.
# <f90r2.5;F>     truncated from "daiin.qokor." onwards.
# <f90r2.5a;F>    created from right half of <f90r2.5;F>.
#
# <f90v1.5;L>     replaced "iiir" by "o".
#
# <f93r.4;C>      deelted "-chodain" at end of line.
# <f93r.5;C>      replaced "iiir" by "o".
#
# <f95v2.2;F>     truncated from "ekaiin.okar.or." onwards.
# <f95v2.2a;F>    created from right half of <f95v2.2;F>.
#
# <f99v.11;F>     truncated from "ol.olal.okeol" onwards.
# <f99v.11a;F>    created with "{skipped line}".
# <f99v.11b;F>    created with "{skipped line}".
# <f99v.11c;F>    created with "{skipped line}".
# <f99v.11d;F>    created with "{skipped line}".
# <f99v.14;F>     deleted "ychol.olkeeoldy-" at end of line.
# <f99v.14a;F>    created from "ychol.olkeeoldy" of line <f99v.14;F>.
#
# <f100v.T.1;C>   deleted, mislabeled copy of <f100v2.R1.5;C>.
# <f100v.T.2;C>   deleted, mislabeled copy of <f100v2.R1.7;C>.
# <f100v.T.2;V>   added, was <f100v.B.2;V>.
# <f100v.T.3;C>   deleted, moved to <f100v.T.3;D>.
# <f100v.T.3;D>   added, was <f100v.T.3;C>.
# <f100v.T.3;V>   added, was <f100v.B.3;V>.
# <f100v.T.4;C>   deleted, moved to <f100v.T.4;D>.
# <f100v.T.4;D>   added, was <f100v.T.4;C>.
# <f100v.T.4;V>   added, was <f100v.B.4;V>.
#
# <f100v.M.1;C>   deleted, moved to <f100v.M.1;D>.
# <f100v.M.1;D>   added, was <f100v.M.1;C>.
# <f100v.M.1;V>   added, was <f100v.B.5;V>.
# <f100v.M.2;C>   deleted, mislabeled copy of <f100v.M.2;C>.
# <f100v.M.2;V>   added, was <f100v.B.6;V>.
# <f100v.M.3;C>   deleted, moved to <f100v.M.3;D>.
# <f100v.M.3;D>   added, was <f100v.M.3;C>.
# <f100v.M.3;V>   added, was <f100v.B.7;V>.
# <f100v.M.4;C>   deleted, mislabeled copy of <f100v.M.5;C>.
# <f100v.M.4;V>   added, was <f100v.B.8;V>.
# <f100v.M.5;C>   deleted, moved to <f100v.M.5;D>.
# <f100v.M.5;V>   added, was <f100v.B.9;V>.
# <f100v.M.5;D>   added, was <f100v.M.5;C>.
#
# <f100v.B.1;V>   deleted, moved to <f100v.T.1;V>.
# <f100v.B.1;V>   added, was <f100v.B.10;V>.
# <f100v.B.2;V>   deleted, moved to <f100v.T.2;V>.
# <f100v.B.2;V>   added, was <f100v.B.11;V>.
# <f100v.B.3;V>   deleted, moved to <f100v.T.3;V>.
# <f100v.B.3;V>   added, was <f100v.B.12;V>.
# <f100v.B.4;V>   deleted, moved to <f100v.T.4;V>.
# <f100v.B.4;V>   added, was <f100v.B.13;V>.
# <f100v.B.5;V>   deleted, moved to <f100v.M.1;V>.
# <f100v.B.6;V>   deleted, moved to <f100v.M.2;V>.
# <f100v.B.7;V>   deleted, moved to <f100v.M.3;V>.
# <f100v.B.8;V>   deleted, moved to <f100v.M.4;V>.
# <f100v.B.9;V>   deleted, moved to <f100v.M.5;V>.
# <f100v.B.10;V>  deleted, moved to <f100v.B.1;V>.
# <f100v.B.11;V>  deleted, moved to <f100v.B.2;V>.
# <f100v.B.12;V>  deleted, moved to <f100v.B.3;V>.
# <f100v.B.13;V>  deleted, moved to <f100v.B.4;V>.
#
#
# <f101v2.1;F>    deleted "ol-" at end of line.
# <f101v2.1;F>    added "{skipped}.orar...odaiiny-" at end of line, from <f101v1.1;F>.
# <f101v2.1a;F>   created missing line with "{skipped}******".
# <f101v2.1a;F>   added "ol...okody.dar" at end of line, from <f101v1.2;F>.
# <f101v2.2;F>    added "cthy.daiin.ch*do.dydy" at end of line, from <f101v1.3;F>.
# <f101v2.3;F>    added "eol.....sodaiin.dy" at end of line, from <f101v1.4;F>.
# <f101v2.4;F>    added ".qokeol.....dy.dar" at end of line, from <f101v1.5;F>.
# <f101v2.5;F>    deleted "da*" at end of line.
# <f101v2.5;F>    added "daiin.cheeody.....cheedy" at end of line, from <f101v1.6;F>.
# <f101v2.6;F>    added ".okeey.ckheo.....olchor" at end of line, from <f101v1.7;F>.
# <f101v2.7;F>    added ".cheey.tey.....ary" at end of line, from <f101v1.8;F>.
# <f101v2.8;F>    deleted "sh*" at end of line.
# <f101v2.8;F>    added "cheeeo.***.{skipped}.cheol...cheodam" at end of line, from <f101v1.9;F>.
#
# <f101v2.9;F>    deleted "o" at end of line.
# <f101v2.9;F>    added "*qor.cheol....qkar" at end of line, from <f101v1.10;F>.
#
# <f101v1.1;F>    deleted line, joined to <f101v2.1;F>.
# <f101v1.2;F>    deleted line, joined to <f101v2.1a;F>.
# <f101v1.3;F>    deleted line, joined to <f101v2.2;F>.
# <f101v1.4;F>    deleted line, joined to <f101v2.3;F>.
# <f101v1.5;F>    deleted line, joined to <f101v2.4;F>.
# <f101v1.6;F>    deleted line, joined to <f101v2.5;F>.
# <f101v1.7;F>    deleted line, joined to <f101v2.6;F>.
# <f101v1.8;F>    deleted line, joined to <f101v2.7;F>.
# <f101v1.9;F>    deleted line, joined to <f101v2.8;F>.
#
# <f101v1.10;F>   deleted line, joined to <f101v2.9;F>.
#
# <f102v1.6;F>    deleted ".toiin.ol.daiin-" at end of line.
# <f102v1.6;F>    added "=" at end of line.
# <f102v1.7;F>    added "toiin.ol.daiin." at beginning of line.
#
# <f103r.1;J>     leading ".", deleted.
# <f103r.2;J>     leading ".", deleted.
# <f103r.2;I>     leading ".", deleted.
# <f103r.3;J>     leading ".", deleted.
#
# <f103v.1;J>     added ".olpchey.qoky.....qotear.shedy.dal" at end of line.
# <f103v.4;J>     added "lkees.ol.qoteedy.okeedy" at end of line.
# <f103v.5;J>     added "qokshdy.qokaiin.okechdy.qopchdy.qotedy.qokaiin.oly" at end of line.
# <f103v.6;J>     added "cheol.qoeeor.lshor.qoky.shedy.qokaiin.chedy.qoka" at end of line.
# <f104r.4;F>     leading ".", deleted.
# <f104r.7;J>     added "dchodees.sheor.....qodaiin.okar" at beginning of line.
# <f104r.8;J>     added "olsheedy.lkeedy.....odar.qokal" at beginning of line.
#
# <f104r.44;F>    replaced ".l.saiin.otaiin....otaiin.otaiin=" by "-" at end of line.
# <f104r.45;F>    created with ".l.saiin.....otaiin=" from line <f104r.44;F>.
#
# <f105r.16;F>    leading ".", deleted.
#
# <f105v.15;F>    added ".r" at end of line.
# <f105v.16;F>    deleted "r." at beginning of line.
#
# <f106r.30;T>    deleted (empty) line.
# <f106r.30;F>    deleted line "saiin.chal....char.aiiny-".
#
# <f107r.33;T>    duplicate ".", replaced by single ".".
#
# <f107r.8;F>     replaced "iiir" by "o".
# <f107r.24;F>    replaced "iiir" by "o".
# <f107r.27;F>    replaced "iiir" by "o".
# <f107r.33;F>    replaced "iiir" by "o" (twice).
# <f107v.32;F>    replaced "iiir" by "o".
# <f107v.46;F>    replaced "iiir" by "o".
#
# <f108v.17;F>    replaced "iiir" by "o".
# <f108v.52;F>    replaced "iiirfin" by ".ol".
#
# <f111r.1;F>     replaced "iiir by "ii".
# <f111r.16;F>    replaced "iiir" by "**".
# <f111r.18;F>    replaced "iiiriiir" by "**".
# <f111r.20;F>    replaced "iiir" by "im".
# <f111r.21;F>    replaced "liiir" by "**".
# <f111r.24;F>    replaced "iiiriiir" by "im".
# <f111r.25;F>    replaced "iiir" by "o".
# <f111r.29;F>    replaced "iiiriiir" by "chr".
# <f111r.50;F>    replaced "iiir" by "*".
#
# <f112v.42;F>    added ".otaray.shaiin.qokedy" at end of line.
# <f112v.42;G>    added ".otaray.shain.qokedy" at end of line.
# <f112v.43;F>    deleted "otaray.shaiin.qokedy." from beginning of line.
# <f112v.43;F>    added ".am" at end of line.
# <f112v.43;G>    deleted "otaray.shain.qokedy." from beginning of line.
# <f112v.43;G>    added ".am" at end of line.
# <f112v.44;F>    deleted "am." at beginning of line.
# <f112v.44;G>    deleted ".am." at beginning of line.
# <f112v.45;F>    deleted ".*ltar.aim" at end of line.
# <f112v.45;G>    deleted ".e.otar.aim" at end of line.
# <f112v.47;F>    added "*ltar.aim." at beginning of line.
# <f112v.47;G>    added "e.otar.aim." at beginning of line.
#
# <f114v.38;F>    deleted ".qoleechedy" at end of line.
# <f114v.39;F>    added "qoleechedy." at beginning of line.
#
# <f115r.36;F>    replaced "sorols.cheos....pchar-" by "=".
# <f115r.36a;F>   created from right half of <f115r.36;F>.
#
# <f116r.43;F>    deleted ".saykeedy.....chey.qol.okam" at end of line.
# <f116r.43a;F>   created with "saykeedy.....chey.qol.okam-" from <f116r.43;F>.
#
# <f116r.28;F>    bogus FSG "Z", replaced by "*".

