## <f0.I> {}
# --- begin comments by G. Landini -----------------------------
# Last edited on 1998-10-29 19:10:56 by stolfi
#
# INTERLN.EVT
# file version 1.6
# by Gabriel Landini, 27 September 1996.
# 
# file version 1.7
# 9 February 1998
# Prepared by Gabriel Landini, 27 September 1996.
#
# This file is an interlinear version of the Voynich manuscript
# transcriptions from:
# a) P. Currier + new additions by the VMS list members (Jim Gillogly,
#    Jim Reeds, Mike Roe 1990-1994)
# b) the First Study Group (W. Friedman 1945-1949)
# c) other pages transcriptions (Don Latham 1996, Mike Roe 1996,
#    John H. Tiltman 1951, Karl Kluge 1992, Jim Reeds 1996)
#
# Please report any problems to: G.Landini@bham.ac.uk or to the Voynich
# list: Voynich@rand.org
#
# To join the Voynich list, send e-mail to Voynich-request@rand.org
#
# I will be responsible for keeping this file corrected and updated, so if
# you find any corrections, please contact me so they can be included in
# the next version of this file.
# All credits and thanks to the members of the Voynich list who made the
# original transcriptions available on line.
#
# This file was produced for the EVMT project (European Voynich Manuscript
# Transcription) by G. Landini and R. Zandbergen.
# We intend to transcribe the whole manuscript from T. C. Petersen's hand
# transcription of a set of photostats (1931) and from previous trans-
# criptions available in machine readable format. The transcription will
# use the EVA alphabet that will allow translation of the document into
# the three most common alphabets associated with the manuscript: FSG
# alphabet, Currier's alphabet and Frogguy (by Jacques Guy).
#
# INTERLN17.EVT is based on the files:
# voynich.now, FSG.NEW and tiltman.txt with some small corrections.
# The Currier version was originally coded in Currier's alphabet.
# I translated it to FSG "enhanced" alphabet using Jacques Guy's BITRANS
# program and a set of rules CUR2FSG2 based on a message by Jim Reeds to
# the Voynich mailing list.
# The FSG alphabet does not contain the Currier characters 6 and 7. To
# preserve these, characters 6 and 7 were kept unchanged in the resulting
# FSG version. Currier 6 usually corresponds to K in FSG, while 7 was
# transcribed as K or 8 by the FSG team.
#
# I added a few "end of line" - and "end of paragraph" = marks where missing
# to keep line lengths equal between versions.
# All double spaces ",," were replaced with single spaces.
#
# Format of this file:
# -------------------
# a) Lines starting with the hash symbol # are comments (can be ignored).
# b) All other lines have information which is either:
#  1) a folio indicator plus "parsable information" (one per folio), or
#  2) a locus indicator plus Voynich text (may have in-line comments).
#
# Folio and locus indicators appear in angle brackets <>.
# The format of the "folio indicator" is: "f" plus the folio number,
# plus "r" for "recto" or "v" for "verso", and sometimes a further number
# for complex folios. Ex: <f1v> indicates folio 1 verso.
#
#   [ Folio indicator lines were turned into special #-comments,
#     by inserting "## " in front of them. --J. Stolfi ]
#
# Rene Zandbergen has added the Parsable Information to this file:
#
# A special type of in-line comment appears after the folio indicator.
# We call this "parsable information". The information is coded in
# "variables" set to values specific for that folio, to facilitate
# the parsing and filtering using VTT. The variable names are single
# characters preceded by the $ symbol and they take as value a single
# character:
#      $I = illustration type  (T,H,A,Z,B,C,P,S)
#           Text, Herbal, Astronomical, Zodiac, Biological, Cosmological,
#           Pharmaceutical or Stars.
#      $Q = Quire              (A-T)
#      $P = page in quire      (A-X)
#      $L = Currier's language (A,B)
#      $H = Currier's hand     (1,2,3,4,5,X,Y)
#      $N = non-Voynich text   (Y)
#      $K = key-like sequence  (Y)
#      $X = extraneous writing (Y)
#
#    Ex:  <f5r> {$I=H $Q=A $P=I $L=A $H=1 $N=Y} indicates a Herbal page
#    in quire A, page I, Currier Language A, hand 1 and has non-Voynich
#    text. Refer to the VTT documentation for details on how to use the
#    parsable information.
#
# All other lines have Voynich code starting at column 20.
#
# In the locus indicator, there is semicolon followed by a letter
# that indicates the origin of the transcription:
#
#   C: Currier's transcription plus new additions from members of the
#      voynich list as found in the file voynich.now.
#   F: First study group's (Friedman's) transcription including various
#      items as found in the file FSG.NEW.
#   T: John Tiltman's transcription of some pages.
#   L: Don Latham's recent transcription of some pages.
#   R: Mike Roe's recent transcription of some pages.
#   K: Karl Kluge's transcription of some labels from Petersen's copies.
#   J: Jim Reed's transcription of some previously unreadable characters.
#   
# [ Additional codes introduced by J. Stolfi after 05 Nov 1997:
#
#   D: second choice from [|] in "C" lines.
#   G: second choice from [|] in "F" lines, mostly from [1609|16xx].
#   I: second choice from [|] in "J" lines.
#   Q: second choice from [|] in "K" lines.
#   M: second choice from [|] in "L" lines.
#
#   N: Gabriel Landini's transcriptions.
#   U: Jorge Stolfi's transcriptions.
#   V: John Grove's transcriptions.
#   P: Petersen's transcriptions.
#   X: Denis V Mardle's transcriptions.
#   Z: Rene Zandbergen's transcriptions.
# ]
#
# In some cases (mostly for labels) there is also information about the
# label position (M. Roe's transcriptions) or about the original numbering
# of the labels found in the Petersen's copies (K. Kluge's transcriptions).
# I left that numbering untouched from the original files but it will be
# changed and standardised in the new transcription exercise.
#
# Examples:
# <f100r.26A;K> K. Kluge's transcription of label number 26A from Petersen.
# <f67v2.C1;C>  M. Roe's transcription of text in a "circle" from
#               the file voynich.now.
#
# [ I later standardized the label location codes across versions,
#   in all cases where there were conflicts.  The original location 
#   codes were retained as '{}' comments. -- J. Stolfi 05 Nov 1997. ]
#
# [ Many more location codes were introduced when incorporating 
#   John Grove's label and title collection. -- J. Stolfi 05 may 1998. ]
#
# In a few places there was a "first" line not present in one
# of the other versions. These lines were numbered 0, or assigned letters.
# Examples:
# <f41v.0;C>, <f84v.a;C>, <f84v.b;F>.
#
# [ Later renumbered "0a", "0b", etc.. -- J. Stolfi 05 Nov 1997 ] 
#
# The % (percent) marks a missing character that exists at the same
# location in the other versions and which breaks synchronism.
# "Synchronism" means the vertical alignment of the sequences. Loss of
# synchronism may be due to a missing character in that version or an
# extra character in the other.
# The Friedman version (FSG.NEW) is composed of various items and therefore
# there are variations within FSG.NEW. These are indicated as [A|B], meaning
# that one item has a character transcribed as an "A" and the other a "B".
#
# [ These '[|]' constructs were later unfolded into separate lines,
#   with their own transcription codes. -- J. Stolfi 05 Nov 1997 ]
#
# Because the brackets and the "or" symbol | also break the synchronism but
# do not indicate any Voynich characters in the sequence, the exclamation
# mark "!" was used to indicate that the other version has extra characters
# that do not code Voynich text.
#
# As in the original transcription files, text limited by curly brackets {}
# is a comment. The complementary sequence will have at this position a
# number of !'s to compensate sequence length.
# Examples:
#
#     <f47r.5;C>  8AN.OE%SCG.TODOE.K=
#     <f47r.5;F>  8AN.OE.SCG.TODOE%K=
#
# the first % indicates a missing space in the Currier version which is
# present in the FSG version.
#
#     <f44r.10;C>   4ODTOR.!O!!DTG.4OHO.GDOE.TODG.TODG.TOE.8AK-
#     <f44r.10;F>   4ODTOR.[O|]DTG.4OHO.GDOE.TODG.TODG.TOE.8AK-
#
# The !'s in the Currier version indicate that the FSG version has
# non coding characters at those locations.
#
# [ I had to remove the "!%" codes in the '[|]' unfolding process. 
#   A few were latter added by hand.  -- J. Stolfi 05 Nov 1997. ]
#
# In some particular instances there were several ways of coding the
# missing symbols. In those instances the coding was chosen arbitrarily.
# Sometimes the M character in one version corresponded to III in the
# other which would mean that the following format would result:
#                ....M%%...
#                ....III...
# Therefore the 2 extra %% may not be true missing symbols.
#
# Below is part of the original heading from one of the source texts.
#
# --- end comments by G. Landini -------------------------------
