# Last edited on 2002-01-16 17:22:44 by stolfi
# Makefile for tabulating frequencies of stroke pairs 
# across word blanks (rightmost stroke of one glyph
# against leftmost stroke of next glyph).

all:
	for tw in t w; do \
	  ${MAKE} TW=$$tw -f stroke-pair-freqs.make single; \
	done


PAPER_DIR := /home/staff/stolfi/papers/voynich-stats/techrep
TBL_DIR := ${PAPER_DIR}/tables/auto
FIG_DIR := ${PAPER_DIR}/figures/auto

# Use precomputed word frequency table for the entire VMS.
LANG := voyn
BUK := vms
SOURCE_WFR := sample/${LANG}/${BUK}/tot.t/gud.wfr
ROW_STROKES := _,Q,E,I,D,Y,G,R,N,M,P,J
COL_STROKES := _,Q,E,I,K,T

OUT_PRF := ${LANG}-${BUK}-stroke-pair

######################################################################
# Recursive make for tokens or words
# Caller must define ${TW} = "t" or "w"
#
TW := TW.IS.UNDEFINED
ifneq "${TW}" "TW.IS.UNDEFINED"

OUT_PRF_TW := ${OUT_PRF}-${TW}

SPF_TW := ${OUT_PRF_TW}.spf
TEX_CTS_TW := ${OUT_PRF_TW}-counts.tex

single: single-counttbl single-freqtbls

single-counttbl: ${SPF_TW} ${TEX_CTS_TW}

single-freqtbls:
	${MAKE} TW=${TW} PN=next -f stroke-pair-freqs.make  freqtbl
	${MAKE} TW=${TW} PN=prev -f stroke-pair-freqs.make  freqtbl

${SPF_TW}: ${SOURCE_WFR} \
            capitalize-ligatures \
            factor-field-general factor-text-basic.gawk \
            count-elem-pairs parse-elem-list.gawk \
            compute-row-col-freqs
	@echo "${SOURCE_WFR} -> ${SPF_TW}"
	cat ${SOURCE_WFR} \
	  | capitalize-ligatures -v field=3 \
	  | factor-field-general \
              -f factor-text-basic -v inField=3 -v outField=4 \
	  | elem-to-stroke-pair -v inField=4 -v outField=5 \
          | gawk -v tw="${TW}" '/./{ print (tw == "t" ? $$1 : 1), $$5; }'  \
	  | count-elem-pairs -f parse-elem-list.gawk \
	      -v endMarker='_' -v showBadWords=0 \
	      -v rowList="${ROW_STROKES}" -v colList="${COL_STROKES}" \
	  | compute-row-col-freqs -v outputTotals=1 \
	  > ${SPF_TW}

${TEX_CTS_TW}: ${SPF_TW} \
            tex-format-elem-pair-freqs parse-elem-list.gawk
	@echo "${SPF_TW} -> ${TEX_CTS_TW}"
	cat ${SPF_TW} \
	  | tex-format-elem-pair-freqs -f parse-elem-list.gawk \
	      -v rowList="${ROW_STROKES}" \
              -v colList="${COL_STROKES},-,+" \
	      -v endMarker='_' -v minFreq=0.015 \
	      -v showCounts=1 \
	      -v showColFreqs=0 -v showRowFreqs=0 \
              -v elemPrefix='\\sk' \
	  > ${TEX_CTS_TW}
	update-paper-include ${TEX_CTS_TW} ${TBL_DIR}

######################################################################
# Recursive make for prev/next frequency tables.
# Caller must define ${TW} = "t" or "w"
# and ${PN} = "prev" or "next"
#
PN := PN.IS.UNDEFINED
ifneq "${PN}" "PN.IS.UNDEFINED"

OUT_PRF_TW_PN := ${OUT_PRF_TW}-${PN}
TEX_FRQ_TW_PN := ${OUT_PRF_TW_PN}-freqs.tex

freqtbl: ${TEX_FRQ_TW_PN}

${TEX_FRQ_TW_PN}: ${SPF_TW} \
            tex-format-elem-pair-freqs parse-elem-list.gawk
	@echo "${SPF_TW} -> ${TEX_FRQ_TW_PN}"
ifeq "${PN}" "next"
	cat ${SPF_TW} \
	  | tex-format-elem-pair-freqs -f parse-elem-list.gawk \
	      -v rowList="${ROW_STROKES}" \
	      -v colList="`echo ${COL_STROKES} | sed -e 's/[,][-]//g'`" \
	      -v endMarker='_' -v minFreq=0.015 \
	      -v showCounts=0 \
	      -v showRowFreqs=1 -v showColFreqs=0 \
              -v elemPrefix='\\sk' \
	  > ${TEX_FRQ_TW_PN}
endif
ifeq "${PN}" "prev"
	cat ${SPF_TW} \
	  | tex-format-elem-pair-freqs -f parse-elem-list.gawk \
	      -v rowList="`echo ${ROW_STROKES} | sed -e 's/[,][-]//g'`" \
              -v colList="${COL_STROKES}" \
	      -v endMarker='_' -v minFreq=0.015 \
	      -v showCounts=0 \
	      -v showRowFreqs=0 -v showColFreqs=1 \
              -v elemPrefix='\\sk' \
	  > ${TEX_FRQ_TW_PN}
endif
	update-paper-include ${TEX_FRQ_TW_PN} ${TBL_DIR}

endif
# End of ${PN} recursion
######################################################################

endif
# End of ${TW} recursion
######################################################################

