# Reading slice elements from a text file.
# Last edited on 2021-05-22 21:09:02 by jstolfi

import txt_read_IMP

def read(fname, mp_cont, mp_fill, angle):
  # Reads the file {fname} which should describe the contours, filling
  # elements, contacts, and link paths of a single object slice. 
  #
  # Returns (1) a list {CRS} of contour paths, (2) a list {OPHS} of
  # {Path} objects that are the filling elements, and (3) a list {CTS} of
  # contacts between the traces of the filling paths. Also returns (4) the {Z}
  # coordinate of the slice.
  # 
  # ??? Describe the file format ???
  #
  # The contour elements (defined by the lines with 'C' code) are closed paths,
  # properly oriented, with trace parameters {m_cont}.  Their procedure
  # {path.compute_contour_nesting} is called to compute and save 
  # their nesting relations.
  # 
  # The filling elements must be parallel raster lines whose axis makes 
  # the specified {angle} (in radians, counterclockwise) with the horizontal. 
  # If rotated by {-angle}, they must be sorted by increasing {Y}, then by
  # increasing {X}.
  #
  # Each filling element ('R' code) is converted to a single {Move}
  # object with parameters {mp_fill} and then to a single-move {Path}
  # object, The orientation of the latter in {OPHSS} is the one
  # indicated in the file by the 'rbit' field of its 'R' line.
  # 
  # The procedure saves in each path of {OPHS} the 'group' index from
  # the respective 'R' line, with {path_hp.set_group}. This index is
  # supposed to indicate a user-given grouping of rasters into blocks
  # such as the continuour raster sequence (CRS) created by RP3.
  # 
  # The lines with 'L' code are converted to contacts and link paths
  # between the filling elements. Each link path will consist of one or
  # more traces with the same parameters {mp_fill}.  These links are attached to
  # the raster paths with {path_hp.add_link} so that they can be obtained with
  # {path_hp.get_links} and {path_hp.connecting_link}.  
  #
  # Each contact is also attached to the two adjacent paths {oph0,oph1}
  # with {path_hp.add_contact(oph0,0)} and {path_hp.add_contact(oph1,1)},
  # assuming that {oph0} is lower than {oph1} in the direction 
  # at 90 degrees ccw from {angle}.
  # 
  return txt_read_IMP.read(fname, mp_cont, mp_fill, angle)
