# Routines for element list parsing - to be included in GAWK programs
# Last edited on 2000-10-24 14:37:16 by stolfi

function parse_explicit_elems(elemList,elem,eindex,eclass,   e,i,nels)
{
  # Parses a comma-separated list of elements 
  # Defines the global variables 
  # Defines the global variables 
  #   "elem[1..nels]" (list of elements),
  #   "eclass[1..nels]" (corrsponding classes, always ""),
  #   "eindex[e]" (element index, "1..nels") and 
  # the last two being indexed by the element "e".
  # Returns the number "nels" of elements in the list.
  # Also sets the global "hasclass" to 0.
  # 
  split("", eindex);
  split("", eclass);
  hasclass = 0;
  nels = split(elemList, elem, ",");
  for (i = 1; i <= nels; i++) 
    { e = elem[i];
      if (e !~ /^[-~\/]$/)
        { if (e in eindex) arg_error(("repeated elem = \"" e "\""));
          eindex[e] = i; eclass[e] = "";
        }
    }
  return nels;
}

function load_elems_from_file(file,elem,eindex,eclass,   e,i,lin,fld,nfld,cl,nels)
{
  # Reads a table mapping elements to classes 
  # Defines the global variables 
  #   "elem[1..nels]" (list of elements),
  #   "eclass[1..nels]" (corresponding classes),
  #   "eindex[e]" (element index, "1..nels") and 
  # the last two being indexed by the element "e".
  # Returns the number "nels" of elements in the table.
  # Also sets "hasclass" to 1.
  # 
  nels=0;
  split("", eindex);
  split("", eclass);
  hasclass = 0;
  while((getline lin < file) > 0) { 
    if (! match(lin, /^[#]/))
      { nfld = split(lin, fld, " ");
        if (nfld < 1) table_error(("bad table entry = \"" lin "\""));
        e = fld[1];
        nels++; i = nels; 
        elem[i] = e; eclass[i] = "";
        if ((e != "/") && (e != "-") && (e != "~"))
          { if (e in eindex) table_error(("repeated elem = \"" e "\""));
            if (nfld >= 2) 
              { cl = fld[2]; eclass[i] = cl; hasclass = 1; }
            eindex[e] = i;
          }
      }
  }
  if (ERRNO != "0") { table_error((file ": " ERRNO)); }
  close (file);
  if (nels == 0) { arg_error(("file \"" file "\" empty or missing")); }
  printf "loaded %6d elements\n", nels > "/dev/stderr";
  return nels;
}

