//   Partite with gold, with circular name and motto,
//   that can be used as background for the DCC abbacus.
//  
//  Assumes defined
//
//    ring_i_texture = texture for inner part of ring
//    ring_o_texture = texture for outer part of ring
//
//    ring_i_ridge_texture = texture for inner  ridge
//    ring_m_ridge_texture = texture for middle ridge
//    ring_o_ridge_texture = texture for outer  ridge
//
//    ring_o_legend_texture
//    ring_i_legend_texture
//
//    ring_i_radius = ring inner  radius
//    ring_m_radius = ring middle radius
//    ring_o_radius = ring outer  radius
//
//    ring_ridge_radius = minor radius of ridges
//
//    ring_i_thickness = ring inner  thickness
//    ring_m_thickness = ring middle thickness
//    ring_o_thickness = ring outer  thickness
//
//    ring_legends_bold  = true for boldface legends
//
//    ring_legend_raise = height of raised legend above ring surface
//    ring_legend_sink  = depth of sunken legend belo ring surface
//
//    dcc_ring_plain
//
//  Defines
//
//    dcc_ring_legends = basic legends, parallel top and bottom
//    dcc_ring_legends_trim_top = ditto, top trimmed above rings
//    dcc_ring_legends_trim_bot = ditto, bottom trimmed below rings

#if (ring_legends_bold)
  #declare legend_font_file   = "tt-fonts/courbd.ttf"
  #declare legend_font_height = 0.65;
  #declare legend_font_width  = 0.55;
  #declare legend_font_gap    = 0.20;
#else
  #declare legend_font_file   = "tt-fonts/cour.ttf"
  #declare legend_font_height = 0.60;
  #declare legend_font_width  = 0.50;
  #declare legend_font_gap    = 0.20;
#end

#declare legend_font_thickness  = 1.00;

#declare ring_max_thickness =
  max(max(ring_i_thickness, ring_o_thickness), ring_m_thickness);

#declare legend_top_Y = ring_max_thickness + ring_legend_raise;

#declare legend_radius = 0.475*ring_i_radius + 0.525*ring_m_radius;
#declare legend_width =  0.475*(ring_m_radius - ring_i_radius);
#declare legend_depth =  legend_top_Y;
#declare legend_texture = texture{ ring_i_legend_texture }
#declare legend_text_up = "INSTITUTO DE COMPUTAO"
#declare legend_text_dn = "UNICAMP"
#include "dcc-ring-legend.inc"
#declare dcc_ring_i_legend = object{ dcc_ring_legend }

#declare legend_radius = (ring_m_radius + ring_o_radius)/2;
#declare legend_width =  0.475*(ring_o_radius - ring_m_radius);
#declare legend_depth =  legend_top_Y;
#declare legend_texture = texture{ ring_o_legend_texture }
#declare legend_text_up = "ARTE ENGENHARIA E CINCIA DA COMPUTAO"
#declare legend_text_dn = ""
#include "dcc-ring-legend.inc"
#declare dcc_ring_o_legend = object{ dcc_ring_legend }

#declare dcc_ring_legends =
  union{
    object{ dcc_ring_i_legend
      texture{ ring_i_legend_texture }
    }
    object{ dcc_ring_o_legend
      texture{ ring_o_legend_texture }
    }
  }

#declare dcc_ring_legends_trim_top = 
  union{
    intersection{
      object{ dcc_ring_i_legend }
      object{ dcc_ring_plain translate <0, ring_legend_raise, 0> }
      texture{ ring_i_legend_texture }
    }
    intersection{
      object{ dcc_ring_o_legend }
      object{ dcc_ring_plain translate <0, ring_legend_raise, 0> }
      texture{ ring_o_legend_texture }
    }
  }

#declare dcc_ring_legends_trim_bot = 
  union{
    difference{
      object{ dcc_ring_i_legend }
      object{ dcc_ring_plain translate <0, -ring_legend_sink, 0> }
      texture{ ring_i_legend_texture }
    }
    difference{
      object{ dcc_ring_o_legend }
      object{ dcc_ring_plain translate <0, -ring_legend_sink, 0> }
      texture{ ring_o_legend_texture }
    }
  }
