# Implementation of module {regroup_rasters}
# Last edited on 2021-05-27 08:05:25 by jstolfi

import input_data
import block
import path
import path_hp
import move
import move_parms
import contact
import path_example
import block_example
import contour
import job_parms

import txt_read
import plot_data

import hacks
import rn

def merge_all_groups(OPHS):
  for oph in OPHS: path_hp.set_group(oph, 0)
  return 0 if len(OPHS) == 0 else 1
  # ----------------------------------------------------------------------

def define_groups_by_contour(OPHS, CRS):
    
  ncr = len(CRS)
  POLS = [None]*ncr # Contours converted to {shapely} polygons.
  
  # Convert all contours to polygons {POLS[0..ncr-1]}:
  for icr in range(ncr):
    cr = CRS[icr]
    cr_ph, cr_dr = path.unpack(cr)
    assert path.pini(cr) == path.pfin(cr)
    PTS = [ move.pini(path.elem(cr,k)) for k in range(path.nelems(cr)) ]
    POLS[icr] = Polygon(PTS)
    
  # Assign all fillers to group {ncr} to mean "not assigned"
  for oph in OPHS: path_hp.set_group(oph, ncr)
  
  # Assign each filler from {OPHS} to a group whose index is the 
  # innermost contour that contains it:
  for icr in range(ncr):
    cr = CRS[icr]
    cr_ph, cr_dr = path.unpack(cr)
    pg = POLS[icr]
    for oph in OPHS:
      cini = pg.contains(Point(path.pini(oph)))
      cfin = pg.contains(Point(path.pfin(oph)))
      assert cini == cfin
      if cini:
        # Found a contour {cr} that contains {oph}.
        # Check whether it is the innermost one:
        icr1 = path_hp.get_group(oph)
        if icr1 >= ncr:
          # Not assigned yet:
          path_hp.set_group(oph, icr)
        else:
          pg1 = POLS[icr1]
          if pg1.contains(pg):
            # Current group contains {icr}
            path_hp.set_group(oph, icr)
          else:
            # Current group does not contain {icr}, must be contained in it:
            assert pg.contains(pg1)
  return
  # ----------------------------------------------------------------------

def split_groups_at_forks(OPHS):

  # Separate fillers by group, preserving their order:
  GRS_old, ngr_old = path_hp.separate_paths_by_group(OPHS)

  ngr_new = 0  # Number of new groups created so far.
  for OPHS_gr in GRS_old:
    if OPHS_gr != None and len(OPHS_gr) > 0:
      # Split the elements of {OPHS_gr} into sub-groups at forks.

      OPHS_tail = set()  # Top elements of still-incomplete new subgroups of old group.

      # Each element of the set {OPHS_tail} is the highest element (in the
      # {ydir} direction), among the elements processed so far, in some new
      # group that has not been completed yet.
      # 
      # Every element in that new sub-group has exactly one contact on its upper
      # side (but not necessarily to an element in the same old group).  
      # Every element in that sub-group, except the first one, has
      # exactly one contact on its lower side, to the element below it in the
      # same new group.

      # Process the filler elements in of {OPHS_gr} in order, assumed to
      # be lowest to highest: in the {ydir} direction:
      for oph_this in OPHS_gr:
        oph_tail = try_adding_to_open_group(oph_this, OPHS_tail)
        if oph_tail == None:
          # Could not add {oph_this} to any existing new group.  
          # Create another new group just for it:
          path_hp.set_group(oph_this, ngr_new)
          ngr_new += 1
          OPHS_tail.add(oph_this)
          oph_tail = oph_this
        
        # Check if the new sub-group is complete:
        CTS_tail_hi = path_hp.get_contacts(oph_tail, 1) # Contacts on upper edge of {oph_tail}.
        if len(CTS_tail_hi) != 1:
          # The new sub-group is complete:
          OPHS_tail.remove(oph_tail)

      # At this point new groups that are still open must have a single upper contact 
      # with elemets in other old groups. Ignore them.

  return
  # ----------------------------------------------------------------------

def try_adding_to_open_group(oph_this, OPHS_tail):
  # Used by {split_groups_at_forks}. 
  # Tries to add the path {oph_this} to one of the open groups whose
  # top elements are in {OPHS_tail}. If it succeeds, replaces that top
  # element by {ophs_this} and returns it. Otherwise, returns {None}.

  CTS_this_lo = path_hp.get_contacts(oph_this, 0) # Contacts on lower edge of {oph_this}.
  if len(CTS_this_lo) != 1:
    # Element {oph_this} has no low-side contacts, or more than one such contact  
    # Cannot add to any existing sub-group, even if some of those contacts are not to the
    # current old group:
    return None
  else:
    # Element {oph_this} has only one low-side contact.  See if it matches 
    # any of the high-side contacts of the still open new groups:
    ct_this_lo = CTS_this_lo[0]
    for oph_tail in OPHS_tail:
      # Consider adding {oph_this} to the open group of {oph_tail}:
      CTS_tail_hi = path_hp.get_contacts(oph_tail, 1)
      assert len(CTS_tail_hi) == 1
      ct_tail_hi = CTS_tail_hi[0]
      if ct_this_lo == ct_tail_hi:
        # Contacts match. Add to new group:
        path_hp.set_group(oph_this, path.get_group(oph_tail))
        OPHS_tail.delete(oph_tail)
        OPHS_tail.add(oph_this)
        return oph_this
    # Not continuation of any open group. Assume that the contact {ct_this_lo}
    # is with a path of some other old group:
    return None
  # ......................................................................

def break_large_groups(OPHS, ydir, max_lines):

  assert type(max_lines) is int and max_lines >= 1
  
  # Separate fillers by group, with each group still sorted by scanline order:
  GRS_old, ngr_old = path_hp.separate_paths_by_group(OPHS, xdir, ydir)
  
  # Scan orig groups, splitting as requested:
  ngr_new = 0
  for OPHS_gr in GRS_old:
    # Split group into scanlines, preserving order:
    SCSS_gr = path.separate_rasters_by_scanline(OPHS, ydir)
    nsc_gr = len(SCSS_gr) # Number of scanlines in group
    if nsc_gr > 0:
      # Decide number of chunks {nck_gr}:
      nck_gr = (nsc_gr + max_lines - 1)//max_lines
      assert nck_gr * max_lines >= nsc_gr
      
      # Decide size of each chunk:
      nsc_ck = nsc_gr//nck_gr
      
      # Unite scanlines in each chunk:
      isc = 0
      for ick in range(nck_gr):
        is_lim = min(nsc_gr, isc + nsc_ck)
        while isc < isc_lim:
          # Assign fillers in scanline to group {ngr_new}:
          for oph in SCSS_gr[isc]:
            path_hp.set_group(oph, ngr_new)
          isc += 1
        # One more new group defined:
        ngr_new += 1
  return ngr_new
  # ----------------------------------------------------------------------

