package particlefiltering;

public class pHistogram {
	
	/*
	// number of bins of HSV in histogram 
	final static int NH = 10;
	final static int NS = 10;
	final static int NV = 10;

	// max HSV values 
	final static double H_MAX = 360.0;
	final static double S_MAX = 1.0;
	final static double V_MAX = 1.0;

	// low thresholds on saturation and value for histogramming 
	final static double S_THRESH = 0.1;
	final static double V_THRESH = 0.2;

	// distribution parameter 
	public final static int LAMBDA = 20; */
	
	/* An HSV histogram represented by NH * NS + NV bins.  Pixels with saturation
	   and value greater than S_THRESH and V_THRESH fill the first NH * NS bins.
	   Other, "colorless" pixels fill the last NV value-only bins. */
	private int length; /*length of histogram array*/
	private double histo[];// = new double [NH*NS + NV];   /*histogram array*/

	public void set_length (int length) {
		this.length = length;
	}
	
	public int get_length () {
		return length;
	}
	
	public void set_data (int pos, double value) {
		histo[pos] = value;
	}	
	
	public void alloc_vector (int size) {
		this.length = size;
		histo = new double[size];
		for (int i = 0; i < size; i++) { histo[i] = 0.0; }
	}
	
	public void copy_vector (double[] vector) {
		this.length = vector.length;
		histo = new double[this.length];
		for (int i = 0; i < this.length; i++) {
			histo[i] = vector[i];
		}
	}
	
	public double get_data (int pos) {
		return histo[pos];
	}
	
	public double[] get_vector () {
		return histo;
	}
	
}
