function [jnovo,base_h,A_h,inib_h,tamb_h] = abre_espaco_hier2(base_h,...
    A_h,inib_h,tamb_h,kv,passov,iv)
%rearranja as colunas da matriz de base multinivel A_h de modo a deixar uma
%coluna vazia no trecho correspondente ao nivel kv. Supoe que o maior nivel
%presente nessa matriz eh iv. Supoe tambem que o trecho de qualquer nivel k
%consiste de tamb_h(k) colunas comecando na coluna inib_h(k). Devolve um
%indice jnovo da coluna aberta. Tambem ajusta os vetores tamb_h, inib_h, e
%rearranja os elementos da base base_h.elementos de modo a manter a
%correspondencia com as colunas de A_h. Em particular, base_h.elementos(jnovo)
%ficarah indefinido.

np = size(A_h,1);
jnovo = inib_h(kv) + tamb_h(kv);
%Encontra o nivel rv seguinte a kv que nao seja vazio
rv = kv + passov;
while (rv <= iv) && (tamb_h(rv) == 0)
    rv = rv + passov;
end
if rv <= iv
    assert(jnovo == inib_h(rv))
    [jaux,base_h,A_h,inib_h,tamb_h] = abre_espaco_hier2(base_h,...
        A_h,inib_h,tamb_h,rv,passov,iv);
    A_h(:,jaux) = A_h(:,jnovo);
    base_h.elementos(jaux) = base_h.elementos(jnovo);
    A_h(:,jnovo) = sparse(np,1);
    base_h.elementos(jnovo).pos = [-1 -1]; %para mostrar que eh invalido
    inib_h(rv) = inib_h(rv) + 1;
end
tamb_h(kv) = tamb_h(kv) + 1;
