function [malha_h,base_h,A_h,inib_h,tamb_h]  = ...
            acrescenta_elementos_criticos_hier2(parametros,malha_h,p,...
            e,base_h,A_h,inib_h,tamb_h,iv,NC_iv,KP_iv,raio_rel,...
            plota,pasta_nivel,estagio)
%acrescenta ao nivel iv da base multiescala 
%todos os elementos do nivel iv cujas celulas
%centrais sao critica, isto eh, contem pontos de amonstragem onde o
%residuo {e_h} eh maior que tol. Tambem acrescente aa malha_h(iv) todas as
%celula necessaria para conter os suportes desse elementos, e atualiza os 
%vetores inib_h, tamb_h.

%supoe que a base hierarquica {base_h} contem apenas elementos dos niveis
%menores ou iguais a iv.
%supoe que malha_h(i) contem todas as celulas que interceptam os suportes
%dos elementos da base de nivel i. Supoe tambem que os elementos do
%nivel i sao base_h.elementos(j1:j2) onde j1 = inib_h(i) e
%j2 = j1 + tamb_h(i) - 1.
%As colunas j1:j2 da matris A_h sao referentes a estes elementos, bem como
%as linha e colunas j1:j2 da matriz M_h.

fprintf(2,'acrescentando elementos necessarios do nivel %d\n',iv);
tol = parametros.tol;
if norm(e,inf) <= tol
    fprintf('-- + ---\n')
    fprintf('-- + ---\n')
    fprintf('tolerancia satisfeita na etapa anterior\n')
    fprintf('-- + ---\n')
    fprintf('-- + ---\n')
    return
end

%decide o nivel inicial de ajuste
iniv = parametros.min_nivel;
passov = passo_nivel(parametros);
CD = malha_h(iniv).CD;
LD = malha_h(iniv).LD;
NP = NC_iv .* KP_iv;
np_comp = prod(NP);
assert(size(p,1) == np_comp)
raio_abs = (LD ./ NC_iv)*raio_rel; %raio absoluto do nivel iv

min_nivel = parametros.min_nivel;
NP = KP_iv .* NC_iv;
np = size(p,1);
assert(np == prod(NP))
nb_h = size(A_h,2);
%determina a lista K dessas celulas criticas do nivel iv.
nc = 0;
K = zeros(0,2);
for i = 1:np
    if abs(e(i,1)) > tol
        IX(2) = mod(i-1,NP(2)); %indice relativo do ponto i0 dentro da coluna da grade
        IX(1) = (i-1-IX(2))/NP(2); %indice relativo da coluna do ponto i0 na grade
        posi = floor(IX ./ KP_iv);
        nc = nc + 1;
        K(nc,:) = posi;
    end
end
K = posicoes_unicas(K);
nk = size(K,1);
fprintf(2,'%d celulas criticas encontrados\n',nk);
%determina a lista Q de celulas do nivel iv que combrem os suportes
%dos elementos do nivel iv cujas celulas centrais estao na lista K
[E,Q] = determina_elementos_relevantes(K,NC_iv,LD,raio_abs,...
    parametros.tipobase,false);
assert(size(E,1) == nk);
assert(size(Q,1) >= nk)
%determina elementos novos na base 
j1 = inib_h(iv);
j2 = j1 + tamb_h(iv) - 1;
E = elimina_elementos_existentes(E,NC_iv,base_h.elementos(j1:j2));
ne = size(E,1);
fprintf(2,'%d celulas criticas novas\n',ne);
if (ne == 0) 
    %nada a acrescentar
    return 
end
%amplia a malha do nivel iv
malha_h(iv) = acrescenta_celulas_na_malha(malha_h(iv),Q,p);
assert(nnz(malha_h(iv).ixc) >= size(Q,1))
%amplia a base do nivel iv
base_iv = constroi_base(malha_h(iv),E,raio_abs,parametros.tipobase);
nb_iv = size(base_iv.elementos,2);
assert(nb_iv == ne)
[A_iv,M_iv] = obtem_base_discreta(parametros,p,malha_h(iv),base_iv,...
    parametros.tensorial,KP_iv,NP,np_comp,1:np);
assert(size(A_iv,2) == ne)
%Concatena os novos elementos na base hierarquicas
A_h(:,nb_h+1:nb_h+nb_iv) = A_iv;
if nb_h == 0
    base_h.elementos = base_iv.elementos;
else
    base_h.elementos(nb_h+1:nb_h+nb_iv) = base_iv.elementos;
end
base_h.uniforme = false;
tamb_h(iv) = tamb_h(iv) + nb_iv;
verifica_base_hier2(base_h,A_h,min_nivel,passov,iv,inib_h,tamb_h,p)





