function [malha_kv,base_h,A_h,inib_h,tamb_h] = acrescenta_filhos_hier2(elem_a,...
    NC_a,malha_kv,NP,base_h,A_h,inib_h,tamb_h,kv,todos,A0)
%acrescenta aa base no nivel kv certos filhos do elemento elem_a do
%nivel anterior. Se {todos} for true acrescenta todos os filhos cujo
%suporte esta
%contido no suporte de elem_a, se {todos} for false acrescenta apenas os
%elementos cujas celulas centrais sao filha da celula central de elem_a.
%Usa a coluna zero da matriz A do nivel kv. NC_a deve ser o tamanho da
%grade de celulas do nivel anterior.

pos_a = elem_a.pos;
%determina um conjunto K das celulas do nivel iv cujos filhos queremos
K = pos_a;
assert(size(K,1) == 1)
assert(size(K,2) == 2)

if todos
    [E,K] = determina_elementos_relevantes(K,NC_a,malha_kv.LD,...
        elem.raio_abs,elem.tipobase,false);
end
U = determina_filhos_das_celulas(K,NC_a,malha_kv.NC);
%dado uma matriz Q (nq x 2), com as posicoes de certas celulas do nivel
%anterior, devolve um vetor U com as posicoes das celulas do nivel corrente
%que sao filhas dessas celulas.
%Supoe que o nivel anterior  tem NC_a(1) x NC_a(2) celulas e o nivel
%corrente tem que tem NC(1) x NC(2) celulas.

for i = 1:size(U,1)
    posi = U(i,:);
    if elemento_nao_estah_na_base(posi,base_h)
        elemi = cria_elemento_hier2(posi);
        Aj = obtem_coluna_da_matriz_A(elemi,kv,A0);
        [malha_kv,base_h,A_h,inib_h,tamb_h] = ...
            acrescenta_elemento_hier2(malha_kv,NP,base_h,A_h,inib_h,tamb_h,...
            elemj,Aj,kv);
    end
end