function alpha_v = calcula_aprox_inicial_IC_hier3(parametros,malha_v,...
    base_v,p_comp,e_comp,plota,estagio,pasta_nivel)

%determina os coefientes alpha_v da aproximacao inicial para o nivel iv
%com a base base_v, pelo metodos da interpolacao pelas medias celulares.
%Supoe que todas as celulas do suporte de base_v estao
%em malha_v. Supoe que todos os pontos de amostragem estao no vetor p_comp, 
%e que os residuos nestes pontos eh e_comp. 

CD = malha_v.CD;
LD = malha_v.LD;
NC_v = malha_v.NC;
np_comp = size(p_comp,1);
assert(size(e_comp,1) == np_comp)
nf = size(e_comp,2);
nb_v = size(base_v.elementos,2);
K_v = obtem_posicoes_dos_elementos(base_v);
nk_v = size(K_v,1);
assert(nb_v == nk_v)

%obtem os centros e medias das celulas criticas
[p_v,g_v,PR_v] = obtem_centros_e_medias_celulares(K_v,malha_v,CD,LD,...
    p_comp,e_comp);
np_v = size(p_v,1);
fprintf(2,'numero de pontos para interpolacao = %d\n',np_v);
assert(nk_v == np_v)
assert(size(g_v,1) == np_v)
assert(size(g_v,2) == nf)

%tamanho da grade completa que contem os pontos p_v
NP_v = NC_v;

if plota.funcao
    figure(6);
    for j = 1:nf
        plota_funcao(p_v,g_v(:,j),true,CD,LD,NP_v,NaN,NaN);
        title(sprintf('medias celulares criticas'),'FontSize',20);
        hold off
        if plota.salva_eps
            saveas(gcf,sprintf('%s/mc%04d.eps',pasta_nivel,j));
        end
    end
    % disp('segundo pause')
    %pause
end

[A0_v,A_v] = obtem_matriz_A(parametros,p_v,malha_v,base_v,...
    parametros.tensorial,NP_v,np_comp,PR_v);

if plota.base
    plota_base(parametros,malha_v,NP_v,p_v,A_v,base_v,pasta_nivel,...
        plota,estagio);
end

%interpola o residuo g_v nas celulas criticas usando a base_v
assert(parametros.metodo == 2)
grava_tex = true;
M_v = A_v;
assert(nb_v == np_v)
[b_v,alpha_v,gs_v,ge_v,map,condM] = ...
    aproximacao(parametros,NP_v,p_v,np_v,CD,LD,base_v,A_v,g_v,M_v,...
    pasta_nivel,plota,estagio,grava_tex);

%     figure(10 + plota.janela_base); clf;
%         plota_centros_hier2(base_h,p_h,A_h,malha_h,NP,...
%             parametros,parametros.min_nivel,passov,iv,inib_h,tamb_h,...
%             pasta_nivel,plota,estagio)

erro_v_L2 = norma_erro_L2(ge_v,np_v);
erro_v_Linf = norma_erro_Linf(ge_v);
fprintf(2,'erro residual nos centros celulares = %9.6f (L2) %9.6f (Linf)\n', ...
    erro_v_L2, erro_v_Linf);
