function alpha = calcula_aprox_inicial_MQ_hier3(parametros,...
    malha,base,A0_comp,A,NP_comp,p_comp,e_comp,...
    PRbase,plota,estagio,pasta_nivel)

%determina os coefientes alpha da aproximacao inicial para o nivel iv
%com a base base, pelo metodos dos minimos quadrados.
%Supoe que todas as celulas do suporte de base estao
%em malha. Supoe que todos os pontos de amostragem estao no vetor p_comp,
%e que os residuos nestes pontos eh e_comp. Supoe que PRbase contem os
%indices no vetor p_comp dos pontos de amostragem que estao no suporte da
%base. Supoe que A eh a matriz da
%base calculada nesse subconjunto dos pontos de amostragem e que A0_comp,
%se nao for vazia o valor do elemento de posicao [0 0] da base eh calculado
%nos pontos p_comp.

np_comp = size(p_comp,1);
p = p_comp(PRbase,:);
M = obtem_matriz_M(parametros,p,malha,base,...
    parametros.tensorial,np_comp,NP_comp,A0_comp,A);
CD = malha.CD;
LD = malha.LD;
if plota.base
    plota_base(parametros,malha,NP_comp,p,A,base,pasta_nivel,...
        plota,estagio);
end

figure(10 + plota.janela_base); clf;
plota_centros(base,p,A,malha,NP_comp,parametros,pasta_nivel,...
    plota,estagio)

assert((parametros.metodo == 1) || (parametros.metodo == 3)...
    || (parametros.metodo == 4))

%o problema eh aproximar o residuo e_comp pela base A nos pontos p
e = e_comp(PRbase); %residuo nos pontos p
grava_tex = true;
[b,alpha,es,ee,map,condM] = aproximacao(parametros,NP_comp,...
    p,np_comp,CD,LD,base,A,e,M,pasta_nivel,plota,...
    estagio,grava_tex);
