function PR = calcula_permutacao_de_centros(j,NC)
%!!!mudar para receber posj em vez de j
%devolve um vetor PR tal que M(i,j) eh M(PR(i),1) onde M eh a matriz dos
%minimos quadrados para a base regular completa com NC(1) x NC(2) elementos e uma
%grade regular completa de pontos de amostragem.

jy = mod(j-1,NC(2));
jx = floor((j-1 - jy)/NC(2));
posj = [jx,jy];
for ix = 0:NC(1)-1
    for iy = 0:NC(2)-1
        posi = [ix, iy];
        i = 1 + posi(1)*NC(2) + posi(2);
        posk = reduz_posicao(posi - posj,NC);
        PR(i) = 1 + posk(1)*NC(2) + posk(2);
        %para a coluna 1 a permutacao deve ser a identidade:
        if j == 1
            assert(PR(i) == i)
        end
    end
end
        