function PR = calcula_permutacao_de_pontos(posj,NC,NP)
%devolve um vetor PR tal que o ponto de amonstragem p(i) esta em relacao ao
%elemento da base cuja posicao eh posj assim como o ponto p(PR(i)) esta 
%para o elemento de posicao [0 0]  da
%base. Supoe uma malha regular completa com NC(1) x NC(2) celulas, numeradas
%por coluna; uma base uniforme onde os elementos estao centrados nas celulas;
%e uma grade regular completa de pontos de amostragem com 
%NP(1) x NP(2) pontos
%total, ordenados por x e por y. 

assert(max(mod(NP,NC)) == 0)
KP = NP ./ NC;
ppc = KP(1)*KP(2);
np = NP(1)*NP(2);
dx0 = posj(1)*KP(1);
dy0 = posj(2)*KP(2);
for i = 1:np
    dy = mod(i-1,NP(2)); %indice relativo do ponto i dentro da coluna da grade
    dx = (i-1-dy)/NP(2); %indice relativo da coluna do ponto i na grade
    dx = mod(dx-dx0,NP(1));
    dy = mod(dy-dy0,NP(2));
    k = 1 + dx*NP(2) + dy;
    PR(i) = k;
end