function Mij = calcula_produto_escalar_da_base(base,tensorial,...
    i,j,p,np_comp,LD)
%calcula o produto escalar dos elemento i e j da base, calculando
%explicitamente seus valores nos pontos p.

np = size(p,1);
tipoi = base.elementos(i).tipobase;
Ci = base.elementos(i).centro;
Ri = base.elementos(i).raio_abs;
tipoj = base.elementos(j).tipobase;
Cj = base.elementos(j).centro;
Rj = base.elementos(j).raio_abs;
soma = 0;
for k = 1:np
    pk = p(k,:);
    fik = phi(pk,tipoi,tensorial,Ci,Ri,LD);
    fjk = phi(pk,tipoj,tensorial,Cj,Rj,LD);
    soma = soma + fik*fjk;
end
Mij = soma/np_comp;
    