function NS = celulas_no_suporte(NC,LD,raio_abs,tipobase)
%devolve o numero NS(k) de celulas interceptadas pelo suporte de um
%elemento com funcao-mae de tipo tipobase e raio raio_abs(k) na direcao do 
%eixo k. O resultado eh sempre um numero impar. Supoe uma grade regular de 
%NC(1) x NC(2) celulas num dominio de tamanho LD(1) x LD(2), com elementos
%centrados nas celulas.

%calcula raio relativo do suporte da funcao-mae.
rsup_rel = suporte_da_funcao_mae(tipobase);

rsup_abs = rsup_rel*raio_abs;
rsup_cel = rsup_abs ./ (LD ./ NC);
RS = ceil(rsup_cel - [0.5, 0.5]);
NS = [1, 1] + 2*RS;


