function confere_matriz_A(A,p,malha,base,tensorial)

np = size(p,1);
nb = size(base.elementos,2);
assert(size(A,1) == np)
assert(size(A,2) == nb)
nb_conf = min([nb, 10]);
np_conf = min([np, 20]);
fprintf(2,'conferindo %d linhas %d colunas da matriz A\n',np_conf, nb_conf);
for j_conf = 1:nb_conf
    if j_conf <= 2
        j = j_conf;
    else
        j = 3 + floor((j_conf-3)*(nb - 3)/(nb_conf - 3));
    end
    %confere a coluna j
    elemj = base.elementos(j);
    Cj = elemj.centro;
    Rj = elemj.raio_abs;
    tipobasej = elemj.tipobase;
    
    for i_conf = 1:np_conf
        if i_conf <= 2
            i = i_conf;
        else
            i = 3 + floor((i_conf-3)*(np - 3)/(np_conf - 3));
        end
        
        z = [p(i,1) p(i,2)];
        Aij = phi(z,tipobasej,tensorial,...
            Cj,Rj,malha.LD);
        dij = abs(Aij - A(i,j));
        if dij > 1.0e-12
            fprintf(2,'** erro elemento A(%d,%d) eh %23.16e esperado %23.16e\n',...
                i,j,full(A(i,j)),full(Aij));
            fprintf(2,'raio_abs = %9.6f %9.6f  centro = %9.6f %9.6f  \n',...
                Rj,Cj);
            fprintf(2,'ponto = %9.6f %9.6f \n',z);
            assert(false)
        end
    end
end


