function confere_matriz_M(parametros,M,A,p,np_comp,base,LD)
np = size(A,1);
nb = size(base.elementos,2);
assert(size(A,2) == nb)
assert(size(M,1) == nb)
assert(size(M,2) == nb)
nb_conf = min([nb, 10]);
fprintf(2,'conferindo %d linhas e %d colunas da matriz M\n',nb_conf, nb_conf);
for j_conf = 1:nb_conf
    if j_conf <= 3
        j = j_conf;
    else
        j = 3 + floor((j_conf-3)*(nb - 3)/(nb_conf - 3));
    end
    Aj = A(:,j);
    assert(issparse(Aj))
    %confere a coluna j
    for i_conf = 1:nb_conf
        if i_conf <= 2
            i = i_conf;
        else
            i = 3 + floor((i_conf-3)*(nb - 3)/(nb_conf - 3));
        end
        Ai = A(:,i);
        assert(issparse(Ai))
        Mij = (Ai'* Aj)/np_comp;
        assert(size(Mij,1) == 1)
        assert(size(Mij,2) == 1)
        Mij = full(Mij);
        dij = abs(Mij - M(i,j));
        if dij > 1.0e-12
            fprintf(2,'** erro elemento M(%d,%d) eh %23.16e esperado %23.16e\n',...
                i,j,full(M(i,j)),Mij);
            Mij_exp = calcula_produto_escalar_da_base(base,...
                parametros.tensorial,i,j,p,np_comp,LD);
            fprintf(2,'produto explicito = %23.16e\n',Mij_exp);
            A(:,i)
            A(:,j)
            assert(false)
        end
    end
end


