function confere_pontos_da_base(malha,base,NP,PR,tensorial,p,p_g)
%p sao os pontos da grade reduzida
%p_g sao os pontos da grade completa
%PR(i) eh o indice na grade completa do ponto i da grade reduzida
fprintf(2,'conferindo consistencia da base, da malha, e dos pontos\n');
nb = size(base.elementos,2);
nc = nnz(malha.ixc);
np = size(PR,2);
assert(size(p,1) == np)
np_comp = prod(NP);
assert(size(p_g,1) == np_comp)
KP = NP ./ malha.NC;
ppc = prod(KP);
RP = inverte_permutacao(PR,np_comp);

%descobre a celulas usadas pela base
%usa_cel(ix+1,iy+1) eh 1 se a base usa a celula de posicao (ix,iy)
usa_cel = sparse(malha.NC(1),malha.NC(2));
for j = 1:nb
    elemj = base.elementos(j);
    Cj = elemj.centro;
    Rj = elemj.raio_abs;
    tipobasej = elemj.tipobase;
    posj = elemj.pos;
    NS = celulas_no_suporte(malha.NC,malha.LD,Rj,tipobasej);
    %examina uma celula alem do suporte
    d_min = primeira_celula_do_suporte(NS+[2, 2],malha.NC);
    d_max = ultima_celula_do_suporte(NS+[2, 2],malha.NC);
    for dsx = d_min(1):d_max(1)
        for dsy = d_min(2):d_max(2)
            posc = mod(posj + [dsx, dsy],malha.NC);
            %enumera os pontos da grade completa dentro dessa celula, e
            %verifica se todos os pontos onde o elemento eh nao nulo estao
            %no vetor PR
            pposc = posc .* KP; %posicao do primeiro ponto da celula posc
            for dx = 0:KP(1)-1
                for dy = 0:KP(2)-1
                    pposi = pposc + [dx, dy];
                    i = 1 + pposi(1)*NP(2) + pposi(2); %indice do ponto na grade completa
                    i_redu = RP(i);
                    assert((i_redu >= 0) && (i_redu <= np))
                    if i_redu ~= 0
                        assert(norm(p(i_redu,:) - p_g(i,:),2) == 0)
                    end
                    v = phi(p_g(i,:),tipobasej,tensorial,...
                        Cj,Rj,malha.LD);
                    if v ~= 0
                        usa_cel(posc(1)+1,posc(2)+1) = 1;
                        %confere se esse ponto esta dentro do suporte oficial
                        ds = abs([dsx, dsy]);
                        ds = min(ds,malha.NC-ds);
                        assert((ds(1) < hx) && (ds(2) < hy))
                        assert(i_redu ~= 0)
                    end
                end
            end
        end
    end
end

%verifica se as celulas estao na malha e se os pontos nessas celulas estao
%no vetor PR
[IX,IY] = find(usa_cel);
assert(size(IX,2) == 1)
assert(size(IX,1) == nnz(usa_cel))
for k = 1:size(IX,1)
    ix = IX(k) - 1;
    iy = IY(k) - 1;
    posi = [ix,iy];
    %verifica se a celula de posicao (ix,iy) estah na malha
    icel = encontra_celula_pela_posicao(posi,malha);
    assert(icel ~= 0)
    assert((icel >= 1) && (icel <= nc))
    %enumera os pontos da grade completa que estao na celula
    pposi = posi .* KP; %posicao do primeiro ponto da celula posi
    nz = 0;
    for dx = 0:KP(1)-1
        for dy = 0:KP(2)-1
            pposj = pposi + [dx, dy];
            j = 1 + pposj(1)*NP(2) + pposj(2); %indice do ponto na grade completa
            if RP(j) == 0
                nz = nz + 1;
            end
        end
    end
    if nz > 0
        fprintf(2,'celula %d = [%d %d]: %d pontos excluidos da grade\n',...
            icel,ix,iy,nz);
    end
    %verifica se o vetor ixgpontos da celula parece consistente
    assert(size(malha.celulas(icel).ixgpontos,2) == ppc)
    for ip = malha.celulas(icel).ixgpontos
        assert((ip >= 1) && (ip <= np_comp))
    end
end


