function base = constroi_base(malha,E,raio_abs,tipobase)
%constroi uma base cujos elementos tem todos o mesmo raio e tipo
%com centros nos centros das celulas da malha cujas posicoes estao
%listada na matriz E (nb x 2). Se E eh vazia constroi um elemento para cada 
%celula da malha.

nc = nnz(malha.ixc);
assert(nc <= malha.NC(1)*malha.NC(2))
ne = size(E,1);
assert(ne <= nc);
if ne == 0
    nn = nc;
else 
    nn = ne;
end

base.uniforme = true;

nb = 0;

for i = 1:nn
    if ne == 0 %nn
        celi = malha.celulas(i);
        posi = celi.pos;
    else
        posi = E(i,:);
        iceli = encontra_celula_pela_posicao(posi,malha);
        assert(iceli > 0);
    end
    CD_c = centro_da_celula(posi,malha.CD,malha.LD,malha.NC);
    elem = constroi_elemento(posi,CD_c,raio_abs,tipobase);
    nb = nb + 1;
    base.elementos(nb) = elem; 
end
if ne == 0
    assert(nb == nc)
else 
    assert(nb == ne)
end
