function p = constroi_grade_de_amostras(CD,LD,NP)
%constroi uma grade regular de np = NP(1) x NP(2) pontos de amostragem no 
%retangulo CD, LD. Devolve um vetor de pesos que soma 1.

D = [CD - 0.5*LD; CD + 0.5*LD]';
sx = (D(1,2)-D(1,1))/NP(1);
sy = (D(2,2)-D(2,1))/NP(2);
np_total = NP(1)*NP(2);
np = 0;
for ix = 1:NP(1)
    for iy = 1:NP(2)
        x = D(1,1) + (ix - 0.5)*sx;
        y = D(2,1) + (iy - 0.5)*sy;
        np = np + 1;
        p(np,:) = [x, y];
    end
end
assert(np == np_total)

