function malha = constroi_malha_completa(CD,LD,NC,p)
%constroi uma malhar regular completa com NC(1) x NC(2) celulas para o
%dominio CD, LD. Distribue os pontos p pelas celulas dessa malha. O vetor 
%p nao precisa estar ordenado.

malha.NC = NC; %tamanho da grade de celulas, (1 x 2)
malha.CD = CD; %centro do dominio (1 x 2)
malha.LD = LD; %tamanho do dominio (1 x 2)
%malha.celulas = [];
nc = 0;
ixc = sparse(NC(1),NC(2));
for dx = 0:NC(1)-1
    for dy = 0:NC(2)-1
        cel = constroi_celula([dx, dy],NC);
        cel.ixgpontos = [];
        nc = nc + 1;
        malha.celulas(nc) = cel;
        ixc(dx+1, dy+1) = nc; 
    end
end
assert(nc == NC(1)*NC(2))
malha.ixc = ixc;

%distribui os pontos pelas celulas
np = size(p,1); 
assert(size(p,2) == 2)

LD_c = LD ./ NC;  %tamanho da celula
MD = CD - 0.5*LD;  %canto inferior do dominio
for i = 1:np
    xi = p(i,1);
    yi = p(i,2);
    assert((xi > MD(1)) && (xi < MD(1)+LD(1)))
    assert((yi > MD(2)) && (yi < MD(2)+LD(2)))
    posi = floor(([xi, yi] - MD) ./ LD_c);
    icel = 1 + posi(1)*NC(2) + posi(2);
    celi = malha.celulas(icel);
    npi = size(celi.ixgpontos,2);
    celi.ixgpontos(npi+1) = i;
    malha.celulas(icel) = celi;
end
    