function [PR,malha] = constroi_malha_da_prebase(Q,CD,LD,NC,p)
%constroi uma malha regular mas incompleta que eh um subconjunto da malha
%uniforme com NC(1) x NC(2) celulas no dominio CD, LD. A malha conterah
%apenas as celulas cujas posicoes estao na matriz Q (nq x 2). Tambem
%determina um vetor PR que contem os indices de todos os pontos de p que
%estao nessas celulas em alguma ordem arbitraria. Os vetores ixgpontos dessas
%celulas conterao indices para o vetor p e nao para o vetor reduzido p(PR).

nq = size(Q,1);
assert(nq <= NC(1)*NC(2));
malha.NC = NC; %tamanho da grade completa de celulas, (1 x 2)
malha.CD = CD; %centro do dominio (1 x 2)
malha.LD = LD; %tamanho do dominio (1 x 2)
nc = 0; %numero de celulas criadas
%Constroe uma tabela ixc tal que ixc(ix+1,iy+1) eh o indice na malha nova
%da celula com posicao [ix,iy], ou zero se tal celula nao estah lah.
ixc = sparse(NC(1),NC(2)); 
for i = 1:nq
    pos = Q(i,:);
    cel = constroi_celula(pos,NC);
    cel.ixgpontos = [];
    nc = nc + 1;
    malha.celulas(nc) = cel;
    ixc(pos(1)+1,pos(2)+1) = nc; 
end
assert(nc == nq)
malha.ixc = ixc;

%distribue os pontos pelas celulas
np = size(p,1); 
assert(size(p,2) == 2)

LD_c = LD ./ NC;  %tamanho da celula
MD = CD - 0.5*LD;  %canto inferior do dominio
np_v =0; %numero de pontos relevantes encontrados

for i = 1:np
    xi = p(i,1);
    yi = p(i,2);
    assert((xi > MD(1)) && (xi < MD(1)+LD(1)))
    assert((yi > MD(2)) && (yi < MD(2)+LD(2)))
    posi = floor(([xi, yi] - MD) ./ LD_c);
    assert(posi(1) >= 0)
    assert(posi(1) < NC(1))
    assert(posi(2) >= 0)
    assert(posi(2) < NC(2))
    icel = ixc(posi(1)+1,posi(2)+1);
    if icel ~= 0
        %ponto eh relevante estah na celula icel
        assert((icel >= 1) && (icel <= nc))
        np_v = np_v + 1;
        PR(np_v) = i;  
        celi = malha.celulas(icel);
        npi = size(celi.ixgpontos,2);
        celi.ixgpontos(npi+1) = i;
        malha.celulas(icel) = celi;
    end
end

