function malha = constroi_malha_para_pontos(CD,LD,NC,p,RS)

%constroi uma malha regular mas incompleta que eh um subconjunto da malha
%uniforme com NC(1) x NC(2) celulas no dominio CD, LD. A malha conterah
%apenas as celulas que contem algum ponto da lista p. Os vetores ixgpontos
%dessas celulas conterao indices para o vetor p. RS eh o raio do suporte, em 
%celulas, alem da celula central. 

np = size(p,1);
assert(size(p,2) == 2)

%determina as celulas dos pontos dados
K = determina_celulas_para_pontos(CD,LD,NC,p);
nk = size(K,1);
fprintf('numero de celulas que contem os pontos = %d\n',nk);

%expande o conjunto de celulas para incluir osuporte da base
S = expande_conjunto_de_celulas(K,NC,RS);
ns = size(S,1);
fprintf('numero de celulas incluindo o suporte = %d\n',ns);

%calcula o conjunto de celulas ativas que podem se afetadas daqui para
%frente
U = expande_conjunto_de_celulas(S,NC,RS);
nu = size(U,1);
fprintf('numero de celulas na malha = %d\n',nu);

[PR,malha] = constroi_malha_da_prebase(U,CD,LD,NC,p);
nc = nnz(malha.ixc);
assert(nc == nu)
assert(size(PR,2) == np)
